/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.openapi.runtime.io.components;

import com.fasterxml.jackson.databind.JsonNode;
import io.smallrye.openapi.api.models.ComponentsImpl;
import io.smallrye.openapi.runtime.io.IoLogging;
import io.smallrye.openapi.runtime.io.callback.CallbackReader;
import io.smallrye.openapi.runtime.io.example.ExampleReader;
import io.smallrye.openapi.runtime.io.extension.ExtensionReader;
import io.smallrye.openapi.runtime.io.header.HeaderReader;
import io.smallrye.openapi.runtime.io.link.LinkReader;
import io.smallrye.openapi.runtime.io.parameter.ParameterReader;
import io.smallrye.openapi.runtime.io.requestbody.RequestBodyReader;
import io.smallrye.openapi.runtime.io.response.ResponseReader;
import io.smallrye.openapi.runtime.io.schema.SchemaReader;
import io.smallrye.openapi.runtime.io.securityscheme.SecuritySchemeReader;
import io.smallrye.openapi.runtime.scanner.spi.AnnotationScannerContext;
import org.eclipse.microprofile.openapi.models.Components;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationValue;

public class ComponentsReader {
    private ComponentsReader() {
    }

    public static Components readComponents(AnnotationScannerContext context, AnnotationValue annotationValue) {
        if (annotationValue == null) {
            return null;
        }
        IoLogging.log.singleAnnotation("@Components");
        AnnotationInstance nested = annotationValue.asNested();
        ComponentsImpl components = new ComponentsImpl();
        components.setCallbacks(CallbackReader.readCallbacks(context, nested.value("callbacks")));
        components.setExamples(ExampleReader.readExamples(nested.value("examples")));
        components.setHeaders(HeaderReader.readHeaders(context, nested.value("headers")));
        components.setLinks(LinkReader.readLinks(nested.value("links")));
        components.setParameters(ParameterReader.readParameters(context, nested.value("parameters")));
        components.setRequestBodies(RequestBodyReader.readRequestBodies(context, nested.value("requestBodies")));
        components.setResponses(ResponseReader.readResponsesMap(context, nested.value("responses")));
        components.setSchemas(SchemaReader.readSchemas(context, nested.value("schemas")));
        components.setSecuritySchemes(SecuritySchemeReader.readSecuritySchemes(nested.value("securitySchemes")));
        return components;
    }

    public static Components readComponents(JsonNode node) {
        if (node == null || !node.isObject()) {
            return null;
        }
        IoLogging.log.singleJsonNode("Components");
        ComponentsImpl components = new ComponentsImpl();
        components.setCallbacks(CallbackReader.readCallbacks(node.get("callbacks")));
        components.setExamples(ExampleReader.readExamples(node.get("examples")));
        components.setHeaders(HeaderReader.readHeaders(node.get("headers")));
        components.setLinks(LinkReader.readLinks(node.get("links")));
        components.setParameters(ParameterReader.readParameters(node.get("parameters")));
        components.setRequestBodies(RequestBodyReader.readRequestBodies(node.get("requestBodies")));
        components.setResponses(ResponseReader.readResponsesMap(node.get("responses")));
        components.setSchemas(SchemaReader.readSchemas(node.get("schemas")).orElse(null));
        components.setSecuritySchemes(SecuritySchemeReader.readSecuritySchemes(node.get("securitySchemes")));
        ExtensionReader.readExtensions(node, components);
        return components;
    }
}

