/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.openapi.runtime.scanner.dataobject;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.smallrye.openapi.api.OpenApiConfig;
import io.smallrye.openapi.runtime.io.schema.SchemaConstant;
import io.smallrye.openapi.runtime.scanner.IndexScannerTestBase;
import io.smallrye.openapi.runtime.scanner.dataobject.TypeResolver;
import io.smallrye.openapi.runtime.scanner.spi.AnnotationScannerContext;
import io.smallrye.openapi.runtime.util.TypeUtil;
import java.util.Iterator;
import java.util.Map;
import javax.json.bind.annotation.JsonbProperty;
import javax.json.bind.annotation.JsonbPropertyOrder;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import org.eclipse.microprofile.openapi.annotations.media.Schema;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.Type;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class TypeResolverTests
extends IndexScannerTestBase {
    TypeResolverTests() {
    }

    private Map<String, TypeResolver> getProperties(Class<?> leafClass, OpenApiConfig config, Class<?> ... indexClasses) {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        AnnotationScannerContext context = new AnnotationScannerContext((IndexView)TypeResolverTests.indexOf(indexClasses), loader, config);
        ClassInfo leafKlazz = context.getIndex().getClassByName(TypeResolverTests.componentize(leafClass.getName()));
        Type leaf = Type.create((DotName)leafKlazz.name(), (Type.Kind)Type.Kind.CLASS);
        return TypeResolver.getAllFields((AnnotationScannerContext)context, (Type)leaf, (ClassInfo)leafKlazz, null);
    }

    private Map<String, TypeResolver> getProperties(Class<?> leafClass, Class<?> ... indexClasses) {
        return this.getProperties(leafClass, TypeResolverTests.emptyConfig(), indexClasses);
    }

    @Test
    void testAnnotatedMethodOverridesParentSchema() {
        Map<String, TypeResolver> properties = this.getProperties(Cat.class, AbstractAnimal.class, Feline.class, Cat.class);
        TypeResolver resolver = properties.get("type");
        Assertions.assertEquals((Object)AnnotationTarget.Kind.METHOD, (Object)resolver.getAnnotationTarget().kind());
        AnnotationInstance schema = TypeUtil.getSchemaAnnotation((AnnotationTarget)resolver.getAnnotationTarget());
        Assertions.assertEquals((Object)"type", (Object)schema.value("name").asString());
        Assertions.assertEquals((Object)false, (Object)schema.value("required").asBoolean());
        Assertions.assertEquals((Object)"Cat", (Object)schema.value("example").asString());
        Assertions.assertArrayEquals((Object[])new String[]{"age", "type", "name", "extinct"}, (Object[])properties.values().stream().map(TypeResolver::getPropertyName).toArray());
    }

    @Test
    void testAnnotatedFieldsOverridesInterfaceSchema() {
        Map<String, TypeResolver> properties = this.getProperties(Cat.class, AbstractAnimal.class, Feline.class, Cat.class);
        TypeResolver resolver = properties.get("name");
        Assertions.assertEquals((Object)AnnotationTarget.Kind.FIELD, (Object)resolver.getAnnotationTarget().kind());
        AnnotationInstance schema = TypeUtil.getSchemaAnnotation((AnnotationTarget)resolver.getAnnotationTarget());
        Assertions.assertEquals((Object)true, (Object)schema.value("required").asBoolean());
        Assertions.assertEquals((Object)"Felix", (Object)schema.value("example").asString());
    }

    @Test
    void testAnnotatedInterfaceMethodOverridesImplMethod() {
        Map<String, TypeResolver> properties = this.getProperties(Dog.class, AbstractAnimal.class, Canine.class, Dog.class);
        Assertions.assertEquals((int)5, (int)properties.size());
        TypeResolver resolver = properties.get("name");
        Assertions.assertEquals((Object)AnnotationTarget.Kind.METHOD, (Object)resolver.getAnnotationTarget().kind());
        AnnotationInstance schema = TypeUtil.getSchemaAnnotation((AnnotationTarget)resolver.getAnnotationTarget());
        Assertions.assertEquals((Object)"c_name", (Object)schema.value("name").asString());
        Assertions.assertEquals((int)50, (int)schema.value("maxLength").asInt());
        Assertions.assertEquals((Object)"The name of the canine", (Object)schema.value("description").asString());
        Assertions.assertArrayEquals((Object[])new String[]{"age", "type", "c_name", "bark", "extinct"}, (Object[])properties.values().stream().map(TypeResolver::getPropertyName).toArray());
    }

    @Test
    void testAnnotatedInterfaceMethodOverridesStaticField() {
        Map<String, TypeResolver> properties = this.getProperties(Lizard.class, AbstractAnimal.class, Reptile.class, Lizard.class);
        TypeResolver resolver = properties.get("scaleColor");
        Assertions.assertEquals((Object)AnnotationTarget.Kind.METHOD, (Object)resolver.getAnnotationTarget().kind());
        AnnotationInstance schema = TypeUtil.getSchemaAnnotation((AnnotationTarget)resolver.getAnnotationTarget());
        Assertions.assertEquals((Object)"scaleColor", (Object)schema.value("name").asString());
        Assertions.assertNull((Object)schema.value("deprecated"));
        Assertions.assertEquals((Object)"The color of a reptile's scales", (Object)schema.value("description").asString());
        TypeResolver ageResolver = properties.get("age");
        Assertions.assertEquals((Object)Type.Kind.CLASS, (Object)ageResolver.getUnresolvedType().kind());
        Assertions.assertEquals((Object)DotName.createSimple((String)String.class.getName()), (Object)ageResolver.getUnresolvedType().name());
    }

    @Test
    void testBareInterface() {
        Map<String, TypeResolver> properties = this.getProperties(MySchema.class, MySchema.class);
        Assertions.assertEquals((int)3, (int)properties.size());
        Iterator<Map.Entry<String, TypeResolver>> iter = properties.entrySet().iterator();
        Assertions.assertEquals((Object)"field1", (Object)iter.next().getKey());
        Assertions.assertEquals((Object)"field3", (Object)iter.next().getKey());
        Assertions.assertEquals((Object)"field2", (Object)iter.next().getKey());
        TypeResolver field1 = properties.get("field1");
        Assertions.assertEquals((Object)AnnotationTarget.Kind.METHOD, (Object)field1.getAnnotationTarget().kind());
        AnnotationInstance schema1 = TypeUtil.getSchemaAnnotation((AnnotationTarget)field1.getAnnotationTarget());
        Assertions.assertEquals((int)1, (int)schema1.values().size());
        Assertions.assertEquals((Object)true, (Object)schema1.value("required").asBoolean());
        TypeResolver field2 = properties.get("field2");
        Assertions.assertEquals((Object)AnnotationTarget.Kind.METHOD, (Object)field1.getAnnotationTarget().kind());
        AnnotationInstance schema2 = TypeUtil.getSchemaAnnotation((AnnotationTarget)field2.getAnnotationTarget());
        Assertions.assertEquals((int)1, (int)schema2.values().size());
        Assertions.assertEquals((Object)"anotherField", (Object)schema2.value("name").asString());
        TypeResolver field3 = properties.get("field3");
        Assertions.assertEquals((Object)AnnotationTarget.Kind.METHOD, (Object)field3.getAnnotationTarget().kind());
        AnnotationInstance schema3 = TypeUtil.getSchemaAnnotation((AnnotationTarget)field3.getAnnotationTarget());
        Assertions.assertNull((Object)schema3);
    }

    @Test
    void testJacksonPropertyOrderDefault() {
        Map<String, TypeResolver> properties = this.getProperties(JacksonPropertyOrderDefault.class, JacksonPropertyOrderDefault.class);
        Assertions.assertEquals((int)4, (int)properties.size());
        Iterator<Map.Entry<String, TypeResolver>> iter = properties.entrySet().iterator();
        Assertions.assertEquals((Object)"comment", (Object)iter.next().getValue().getPropertyName());
        Assertions.assertEquals((Object)"theName", (Object)iter.next().getValue().getPropertyName());
    }

    @Test
    void testJacksonPropertyOrderCustomName() {
        Map<String, TypeResolver> properties = this.getProperties(JacksonPropertyOrderCustomName.class, JacksonPropertyOrderCustomName.class);
        Assertions.assertEquals((int)4, (int)properties.size());
        Iterator<Map.Entry<String, TypeResolver>> iter = properties.entrySet().iterator();
        Assertions.assertEquals((Object)"theName", (Object)iter.next().getValue().getPropertyName());
        Assertions.assertEquals((Object)"comment2ActuallyFirst", (Object)iter.next().getValue().getPropertyName());
        Assertions.assertEquals((Object)"comment", (Object)iter.next().getValue().getPropertyName());
    }

    @Test
    void testJaxbCustomPropertyOrder() {
        Map<String, TypeResolver> properties = this.getProperties(JaxbCustomPropertyOrder.class, JaxbCustomPropertyOrder.class);
        Assertions.assertEquals((int)4, (int)properties.size());
        Iterator<Map.Entry<String, TypeResolver>> iter = properties.entrySet().iterator();
        Assertions.assertEquals((Object)"comment", (Object)iter.next().getValue().getPropertyName());
        Assertions.assertEquals((Object)"name2", (Object)iter.next().getValue().getPropertyName());
        Assertions.assertEquals((Object)"comment2", (Object)iter.next().getValue().getPropertyName());
        Assertions.assertEquals((Object)"name", (Object)iter.next().getValue().getPropertyName());
    }

    @Test
    void testNonJavaBeansPropertyAccessor() {
        Map<String, TypeResolver> properties = this.getProperties(NonJavaBeanAccessorProperty.class, NonJavaBeanAccessorProperty.class);
        Assertions.assertEquals((int)1, (int)properties.size());
        Iterator<Map.Entry<String, TypeResolver>> iter = properties.entrySet().iterator();
        TypeResolver property = iter.next().getValue();
        Assertions.assertEquals((Object)"name", (Object)property.getPropertyName());
        Assertions.assertEquals((Object)property.getReadMethod(), (Object)property.getAnnotationTarget());
        Assertions.assertEquals((Object)"Name of the property", (Object)TypeUtil.getAnnotationValue((AnnotationTarget)property.getAnnotationTarget(), (DotName)SchemaConstant.DOTNAME_SCHEMA, (String)"title"));
    }

    @Test
    void testNonJavaBeansPropertyMutator() {
        Map<String, TypeResolver> properties = this.getProperties(NonJavaBeanMutatorProperty.class, NonJavaBeanMutatorProperty.class);
        Assertions.assertEquals((int)1, (int)properties.size());
        Iterator<Map.Entry<String, TypeResolver>> iter = properties.entrySet().iterator();
        TypeResolver property = iter.next().getValue();
        Assertions.assertEquals((Object)"name", (Object)property.getPropertyName());
        Assertions.assertEquals((Object)property.getWriteMethod(), (Object)property.getAnnotationTarget());
        Assertions.assertEquals((Object)"Name of the property", (Object)TypeUtil.getAnnotationValue((AnnotationTarget)property.getAnnotationTarget(), (DotName)SchemaConstant.DOTNAME_SCHEMA, (String)"title"));
    }

    @Test
    void testOneSidedPropertiesHidden() {
        Map<String, TypeResolver> properties = this.getProperties(OneSidedProperties.class, OneSidedProperties.class, OneSidedParent.class);
        Assertions.assertEquals((int)5, (int)properties.size());
        Iterator<Map.Entry<String, TypeResolver>> iter = properties.entrySet().iterator();
        TypeResolver parentProp1 = iter.next().getValue();
        Assertions.assertEquals((Object)"parentProp1", (Object)parentProp1.getPropertyName());
        Assertions.assertTrue((boolean)parentProp1.isIgnored());
        TypeResolver parentProp2 = iter.next().getValue();
        Assertions.assertEquals((Object)"parentProp2", (Object)parentProp2.getPropertyName());
        Assertions.assertTrue((boolean)parentProp2.isIgnored());
        TypeResolver prop1 = iter.next().getValue();
        Assertions.assertEquals((Object)"prop1", (Object)prop1.getPropertyName());
        Assertions.assertFalse((boolean)prop1.isIgnored());
        TypeResolver prop2 = iter.next().getValue();
        Assertions.assertEquals((Object)"prop2", (Object)prop2.getPropertyName());
        Assertions.assertFalse((boolean)prop2.isIgnored());
        TypeResolver prop3 = iter.next().getValue();
        Assertions.assertEquals((Object)"prop3", (Object)prop3.getPropertyName());
        Assertions.assertFalse((boolean)prop3.isIgnored());
    }

    @Test
    void testXmlAccessTransientField() {
        Map<String, TypeResolver> properties = this.getProperties(XmlTransientField.class, XmlTransientField.class);
        Assertions.assertEquals((int)2, (int)properties.size());
        Iterator<Map.Entry<String, TypeResolver>> iter = properties.entrySet().iterator();
        TypeResolver property = iter.next().getValue();
        Assertions.assertEquals((Object)"prop1Field", (Object)property.getPropertyName());
        Assertions.assertTrue((boolean)property.isIgnored());
        property = iter.next().getValue();
        Assertions.assertEquals((Object)"prop2Field", (Object)property.getPropertyName());
        Assertions.assertFalse((boolean)property.isIgnored());
    }

    @Test
    void testXmlAccessTransientClass() {
        Map<String, TypeResolver> properties = this.getProperties(XmlTransientClass.class, XmlTransientClass.class);
        Assertions.assertEquals((int)3, (int)properties.size());
        Iterator<Map.Entry<String, TypeResolver>> iter = properties.entrySet().iterator();
        TypeResolver property = iter.next().getValue();
        Assertions.assertEquals((Object)"prop1Field", (Object)property.getPropertyName());
        Assertions.assertTrue((boolean)property.isIgnored());
        property = iter.next().getValue();
        Assertions.assertEquals((Object)"prop2Field", (Object)property.getPropertyName());
        Assertions.assertTrue((boolean)property.isIgnored());
        property = iter.next().getValue();
        Assertions.assertEquals((Object)"prop3Property", (Object)property.getPropertyName());
        Assertions.assertTrue((boolean)property.isIgnored());
    }

    @Test
    void testXmlAccessPublicMember() {
        Map<String, TypeResolver> properties = this.getProperties(XmlAccessTypePublicMember.class, XmlAccessTypePublicMember.class);
        Assertions.assertEquals((int)3, (int)properties.size());
        Iterator<Map.Entry<String, TypeResolver>> iter = properties.entrySet().iterator();
        TypeResolver property = iter.next().getValue();
        Assertions.assertEquals((Object)"prop1Field", (Object)property.getPropertyName());
        Assertions.assertFalse((boolean)property.isIgnored());
        property = iter.next().getValue();
        Assertions.assertEquals((Object)"prop2Field", (Object)property.getPropertyName());
        Assertions.assertTrue((boolean)property.isIgnored());
        property = iter.next().getValue();
        Assertions.assertEquals((Object)"prop3Property", (Object)property.getPropertyName());
        Assertions.assertFalse((boolean)property.isIgnored());
    }

    @Test
    void testXmlAccessTypeFieldOnly() {
        Map<String, TypeResolver> properties = this.getProperties(XmlAccessTypeFieldOnly.class, XmlAccessTypeFieldOnly.class);
        Assertions.assertEquals((int)2, (int)properties.size());
        Iterator<Map.Entry<String, TypeResolver>> iter = properties.entrySet().iterator();
        TypeResolver property = iter.next().getValue();
        Assertions.assertEquals((Object)"prop1Field", (Object)property.getPropertyName());
        Assertions.assertFalse((boolean)property.isIgnored());
        property = iter.next().getValue();
        Assertions.assertEquals((Object)"prop2Property", (Object)property.getPropertyName());
        Assertions.assertTrue((boolean)property.isIgnored());
    }

    @Test
    void testXmlAccessTypePropertyOnly() {
        Map<String, TypeResolver> properties = this.getProperties(XmlAccessTypePropertyOnly.class, XmlAccessTypePropertyOnly.class);
        Assertions.assertEquals((int)2, (int)properties.size());
        Iterator<Map.Entry<String, TypeResolver>> iter = properties.entrySet().iterator();
        TypeResolver property = iter.next().getValue();
        Assertions.assertEquals((Object)"prop2Field", (Object)property.getPropertyName());
        Assertions.assertTrue((boolean)property.isIgnored());
        property = iter.next().getValue();
        Assertions.assertEquals((Object)"prop1Property", (Object)property.getPropertyName());
        Assertions.assertFalse((boolean)property.isIgnored());
    }

    @Test
    void testPrivatePropertyHidden() {
        class Test {
            private String field1;
            public String field2;

            Test() {
            }
        }
        Map<String, TypeResolver> properties = this.getProperties(Test.class, TypeResolverTests.dynamicConfig("mp.openapi.extensions.smallrye.private-properties.enable", false), Test.class);
        Assertions.assertEquals((int)2, (int)properties.size());
        Assertions.assertTrue((boolean)properties.get("field1").isIgnored());
        Assertions.assertFalse((boolean)properties.get("field2").isIgnored());
    }

    @Test
    void testPrivatePropertyExposedWithSchema() {
        class Test {
            @Schema(hidden=false)
            private String field1;
            public String field2;

            Test() {
            }
        }
        Map<String, TypeResolver> properties = this.getProperties(Test.class, TypeResolverTests.dynamicConfig("mp.openapi.extensions.smallrye.private-properties.enable", false), Test.class);
        Assertions.assertEquals((int)2, (int)properties.size());
        Assertions.assertFalse((boolean)properties.get("field1").isIgnored());
        Assertions.assertFalse((boolean)properties.get("field2").isIgnored());
    }

    @Test
    void testPublicPropertyHiddenWithSchema() {
        class Test {
            private String field1;
            @Schema(hidden=true)
            public String field2;

            Test() {
            }
        }
        Map<String, TypeResolver> properties = this.getProperties(Test.class, TypeResolverTests.dynamicConfig("mp.openapi.extensions.smallrye.private-properties.enable", false), Test.class);
        Assertions.assertEquals((int)2, (int)properties.size());
        Assertions.assertTrue((boolean)properties.get("field1").isIgnored());
        Assertions.assertTrue((boolean)properties.get("field2").isIgnored());
    }

    @Test
    void testPrivatePropertyVisibleWithProtectedGetter() {
        class Test {
            private String field1;
            public String field2;

            Test() {
            }

            public String getField1() {
                return this.field1;
            }
        }
        Map<String, TypeResolver> properties = this.getProperties(Test.class, TypeResolverTests.dynamicConfig("mp.openapi.extensions.smallrye.private-properties.enable", false), Test.class);
        Assertions.assertEquals((int)2, (int)properties.size());
        Assertions.assertFalse((boolean)properties.get("field1").isIgnored());
        Assertions.assertFalse((boolean)properties.get("field2").isIgnored());
    }

    @Test
    void testPrivatePropertyHiddenWithPrivateGetter() {
        class Test {
            private String field1;
            private String field2;

            Test() {
            }

            public String getField1() {
                return this.field1;
            }

            private String getField2() {
                return this.field2;
            }
        }
        Map<String, TypeResolver> properties = this.getProperties(Test.class, TypeResolverTests.dynamicConfig("mp.openapi.extensions.smallrye.private-properties.enable", false), Test.class);
        Assertions.assertEquals((int)2, (int)properties.size());
        Assertions.assertFalse((boolean)properties.get("field1").isIgnored());
        Assertions.assertTrue((boolean)properties.get("field2").isIgnored());
    }

    @Test
    void testPrivatePropertyHiddenWithPrivateGetterAndMissingField() {
        class Test {
            private String field1;

            Test() {
            }

            public String getField1() {
                return this.field1;
            }

            private String getField2() {
                return "field2";
            }
        }
        Map<String, TypeResolver> properties = this.getProperties(Test.class, TypeResolverTests.dynamicConfig("mp.openapi.extensions.smallrye.private-properties.enable", false), Test.class);
        Assertions.assertEquals((int)2, (int)properties.size());
        Assertions.assertFalse((boolean)properties.get("field1").isIgnored());
        Assertions.assertTrue((boolean)properties.get("field2").isIgnored());
    }

    @XmlAccessorType(value=XmlAccessType.PROPERTY)
    static class XmlAccessTypePropertyOnly {
        String prop2Field;

        XmlAccessTypePropertyOnly() {
        }

        public String getProp1Property() {
            return null;
        }
    }

    @XmlAccessorType(value=XmlAccessType.FIELD)
    static class XmlAccessTypeFieldOnly {
        String prop1Field;

        XmlAccessTypeFieldOnly() {
        }

        public String getProp2Property() {
            return null;
        }
    }

    @XmlAccessorType(value=XmlAccessType.PUBLIC_MEMBER)
    static class XmlAccessTypePublicMember {
        public String prop1Field;
        private String prop2Field;

        XmlAccessTypePublicMember() {
        }

        public String getProp3Property() {
            return null;
        }
    }

    @XmlTransient
    static class XmlTransientClass {
        String prop1Field;
        String prop2Field;

        XmlTransientClass() {
        }

        public String getProp3Property() {
            return null;
        }
    }

    static class XmlTransientField {
        @XmlTransient
        String prop1Field;
        String prop2Field;

        XmlTransientField() {
        }
    }

    static class OneSidedProperties
    extends OneSidedParent {
        String prop1;
        String prop2;
        String prop3;

        OneSidedProperties() {
        }

        @Schema(hidden=true)
        public String getProp1() {
            return this.prop1;
        }

        public void setProp1(String prop1) {
            this.prop1 = prop1;
        }

        public String getProp2() {
            return this.prop2;
        }

        @Schema(hidden=true)
        public void setProp2(String prop2) {
            this.prop2 = prop2;
        }
    }

    static class OneSidedParent {
        OneSidedParent() {
        }

        @Schema(hidden=true)
        public String getParentProp1() {
            return "";
        }

        @Schema(hidden=true)
        public void setParentProp2(String something) {
        }
    }

    static class NonJavaBeanMutatorProperty {
        String name;

        NonJavaBeanMutatorProperty() {
        }

        String name() {
            return this.name;
        }

        void anotherValue(String value) {
        }

        String get() {
            return this.name;
        }

        String isNotAnAccessor() {
            return null;
        }

        @Schema(title="Name of the property")
        void name(String name) {
            this.name = name;
        }
    }

    static class NonJavaBeanAccessorProperty {
        String name;

        NonJavaBeanAccessorProperty() {
        }

        @Schema(title="Name of the property")
        String name() {
            return this.name;
        }

        String anotherValue() {
            return null;
        }

        String get() {
            return this.name;
        }

        String isNotAnAccessor() {
            return null;
        }

        void name(String name) {
            this.name = name;
        }
    }

    @XmlType(propOrder={"theName", "comment2ActuallyFirst", "comment", "name2"})
    public static class JaxbCustomPropertyOrder {
        @XmlElement(name="theName")
        String name;
        @XmlAttribute
        String name2;
        @XmlElement
        String comment;
        @XmlAttribute(name="comment2ActuallyFirst")
        String comment2;

        public String getComment() {
            return this.comment;
        }

        public String getName() {
            return this.name;
        }

        public String getName2() {
            return this.name2;
        }

        public String getComment2() {
            return this.comment2;
        }
    }

    @JsonPropertyOrder(value={"theName", "comment2ActuallyFirst", "comment"})
    public static class JacksonPropertyOrderCustomName {
        @JsonProperty(value="theName")
        String name;
        String name2;
        String comment;
        @JsonProperty(value="comment2ActuallyFirst")
        String comment2;

        public String getComment() {
            return this.comment;
        }

        public String getName() {
            return this.name;
        }
    }

    @JsonPropertyOrder(value={"comment", "name"})
    public static class JacksonPropertyOrderDefault {
        @JsonProperty(value="theName")
        String name;
        String name2;
        String comment;
        String comment2;

        public String getComment() {
            return this.comment;
        }

        public String getName() {
            return this.name;
        }
    }

    @JsonbPropertyOrder(value={"field1", "field3", "field2"})
    public static interface MySchema {
        @Schema(required=true)
        public String getField1();

        @Schema(name="anotherField")
        public String getField2();

        public String getField3();
    }

    public static class Lizard
    extends AbstractAnimal
    implements Reptile {
        @Schema(deprecated=true)
        static String scaleColor;
        boolean lovesRocks;

        @Override
        public String getScaleColor() {
            return "green";
        }

        @Override
        public void setScaleColor(String scaleColor) {
            Lizard.scaleColor = scaleColor;
        }

        public void setAge(String age) {
            super.setAge(Integer.parseInt(age));
        }
    }

    public static interface Reptile {
        @Schema(name="scaleColor", description="The color of a reptile's scales")
        public String getScaleColor();

        @Schema(name="scaleColor", description="This is how the color is set, but the description comes from getScaleColor")
        public void setScaleColor(String var1);
    }

    @JsonbPropertyOrder(value={"name", "type", "bark"})
    public static class Dog
    extends AbstractAnimal
    implements Canine {
        @JsonbProperty(value="bark")
        String bark;

        @Schema(name="bark")
        public String getBark() {
            return this.bark;
        }

        @Override
        public String getName() {
            return "Fido";
        }

        @Schema(description="This property is not used due to being static")
        public static int getStaticAge() {
            return -1;
        }
    }

    public static interface Canine {
        @Schema(name="c_name", description="The name of the canine", maxLength=50)
        public String getName();
    }

    @XmlType(propOrder={"name", "type"})
    public static class Cat
    extends AbstractAnimal
    implements Feline {
        @Schema(required=true, example="Felix")
        String name;

        public String getName() {
            return this.name;
        }

        @Override
        public void setName(String name) {
            this.name = name;
        }

        @Override
        @Schema(name="type", required=false, example="Cat")
        public String getType() {
            return super.getType();
        }
    }

    public static interface Feline {
        @Schema(name="name", required=false, example="Feline")
        public void setName(String var1);
    }

    @JsonPropertyOrder(value={"age", "type"})
    public static abstract class AbstractAnimal {
        @Schema
        private String type;
        protected Integer age;
        private boolean extinct;

        @Schema(name="pet_type", required=true)
        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }

        public int getAge() {
            return this.age;
        }

        public void setAge(int age) {
            this.age = age;
        }

        @Schema
        public Boolean isExtinct() {
            return this.extinct;
        }

        public void setExtinct(boolean extinct) {
            this.extinct = extinct;
        }
    }
}

