/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.openapi.runtime.scanner.dataobject;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.smallrye.openapi.api.models.media.SchemaImpl;
import io.smallrye.openapi.runtime.scanner.IndexScannerTestBase;
import io.smallrye.openapi.runtime.scanner.dataobject.BeanValidationScanner;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.validation.constraints.DecimalMax;
import javax.validation.constraints.DecimalMin;
import javax.validation.constraints.Digits;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.Negative;
import javax.validation.constraints.NegativeOrZero;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Positive;
import javax.validation.constraints.PositiveOrZero;
import javax.validation.constraints.Size;
import javax.validation.groups.Default;
import org.eclipse.microprofile.openapi.models.media.Schema;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.FieldInfo;
import org.jboss.jandex.Index;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class BeanValidationScannerTest
extends IndexScannerTestBase {
    BeanValidationScanner testTarget;
    Index index;
    Set<String> methodsInvoked = new LinkedHashSet<String>();
    Schema schema;
    ClassInfo targetClass;

    BeanValidationScannerTest() {
    }

    @BeforeEach
    void beforeEach() {
        this.testTarget = BeanValidationScanner.INSTANCE;
        this.index = BeanValidationScannerTest.indexOf(BVTestContainer.class);
        this.methodsInvoked.clear();
        this.schema = new SchemaImpl();
        this.targetClass = this.index.getClassByName(BeanValidationScannerTest.componentize(BVTestContainer.class.getName()));
    }

    Schema proxySchema(final Schema schema, final Set<String> methodsInvoked) {
        Schema schemaProxy = (Schema)Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), new Class[]{Schema.class}, new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                methodsInvoked.add(method.getName());
                return method.invoke((Object)schema, args);
            }
        });
        return schemaProxy;
    }

    @Test
    void testNullSchemaIgnored() {
        BeanValidationScanner.applyConstraints((AnnotationTarget)this.targetClass, (Schema)this.proxySchema(this.schema, this.methodsInvoked), null, null);
        Assertions.assertArrayEquals((Object[])new String[]{"getType"}, (Object[])this.methodsInvoked.toArray(), (String)"Unexpected methods were invoked");
    }

    @Test
    void testRefSchemaIgnored() {
        this.schema.setType(Schema.SchemaType.OBJECT);
        this.schema.setRef("#/components/schemas/Anything");
        BeanValidationScanner.applyConstraints((AnnotationTarget)this.targetClass, (Schema)this.proxySchema(this.schema, this.methodsInvoked), null, null);
        Assertions.assertArrayEquals((Object[])new String[]{"getType", "getRef"}, (Object[])this.methodsInvoked.toArray(), (String)"Unexpected methods were invoked");
    }

    @Test
    void testArrayListNotNullAndNotEmptyAndMaxItems() {
        FieldInfo targetField = this.targetClass.field("arrayListNotNullAndNotEmptyAndMaxItems");
        SchemaImpl parentSchema = new SchemaImpl();
        String propertyKey = "TESTKEY";
        this.testTarget.notNull((AnnotationTarget)targetField, this.schema, propertyKey, (arg_0, arg_1) -> BeanValidationScannerTest.lambda$testArrayListNotNullAndNotEmptyAndMaxItems$0((Schema)parentSchema, arg_0, arg_1));
        this.testTarget.sizeArray((AnnotationTarget)targetField, this.schema);
        this.testTarget.notEmptyArray((AnnotationTarget)targetField, this.schema);
        Assertions.assertEquals((Object)Boolean.FALSE, (Object)this.schema.getNullable());
        Assertions.assertEquals((Integer)1, (Integer)this.schema.getMinItems());
        Assertions.assertEquals((Integer)20, (Integer)this.schema.getMaxItems());
        Assertions.assertEquals(Arrays.asList(propertyKey), (Object)parentSchema.getRequired());
    }

    @Test
    void testArrayListNullableAndMinItemsAndMaxItems() {
        FieldInfo targetField = this.targetClass.field("arrayListNullableAndMinItemsAndMaxItems");
        SchemaImpl parentSchema = new SchemaImpl();
        String propertyKey = "TESTKEY";
        this.testTarget.notNull((AnnotationTarget)targetField, this.schema, propertyKey, (target, name) -> Assertions.fail((String)"Unexpected call to handler"));
        this.testTarget.sizeArray((AnnotationTarget)targetField, this.schema);
        this.testTarget.notEmptyArray((AnnotationTarget)targetField, this.schema);
        Assertions.assertEquals(null, (Object)this.schema.getNullable());
        Assertions.assertEquals((Integer)5, (Integer)this.schema.getMinItems());
        Assertions.assertEquals((Integer)20, (Integer)this.schema.getMaxItems());
        Assertions.assertNull((Object)parentSchema.getRequired());
    }

    @Test
    void testMapObjectNotNullAndNotEmptyAndMaxProperties() {
        this.schema.setAdditionalPropertiesBoolean(Boolean.TRUE);
        FieldInfo targetField = this.targetClass.field("mapObjectNotNullAndNotEmptyAndMaxProperties");
        SchemaImpl parentSchema = new SchemaImpl();
        String propertyKey = "TESTKEY";
        this.testTarget.notNull((AnnotationTarget)targetField, this.schema, propertyKey, (arg_0, arg_1) -> BeanValidationScannerTest.lambda$testMapObjectNotNullAndNotEmptyAndMaxProperties$2((Schema)parentSchema, arg_0, arg_1));
        this.testTarget.sizeObject((AnnotationTarget)targetField, this.schema);
        this.testTarget.notEmptyObject((AnnotationTarget)targetField, this.schema);
        Assertions.assertEquals((Object)Boolean.FALSE, (Object)this.schema.getNullable());
        Assertions.assertEquals((Integer)1, (Integer)this.schema.getMinProperties());
        Assertions.assertEquals((Integer)20, (Integer)this.schema.getMaxProperties());
        Assertions.assertEquals(Arrays.asList(propertyKey), (Object)parentSchema.getRequired());
    }

    @Test
    void testMapObjectNullableAndMinPropertiesAndMaxProperties() {
        this.schema.setAdditionalPropertiesBoolean(Boolean.TRUE);
        FieldInfo targetField = this.targetClass.field("mapObjectNullableAndMinPropertiesAndMaxProperties");
        SchemaImpl parentSchema = new SchemaImpl();
        String propertyKey = "TESTKEY";
        this.testTarget.notNull((AnnotationTarget)targetField, this.schema, propertyKey, (target, name) -> Assertions.fail((String)"Unexpected call to handler"));
        this.testTarget.sizeObject((AnnotationTarget)targetField, this.schema);
        this.testTarget.notEmptyObject((AnnotationTarget)targetField, this.schema);
        Assertions.assertEquals(null, (Object)this.schema.getNullable());
        Assertions.assertEquals((Integer)5, (Integer)this.schema.getMinProperties());
        Assertions.assertEquals((Integer)20, (Integer)this.schema.getMaxProperties());
        Assertions.assertNull((Object)parentSchema.getRequired());
    }

    @Test
    void testMapObjectNullableNoAdditionalProperties() {
        FieldInfo targetField = this.targetClass.field("mapObjectNullableAndMinPropertiesAndMaxProperties");
        SchemaImpl parentSchema = new SchemaImpl();
        String propertyKey = "TESTKEY";
        this.testTarget.notNull((AnnotationTarget)targetField, this.schema, propertyKey, (target, name) -> Assertions.fail((String)"Unexpected call to handler"));
        this.testTarget.sizeObject((AnnotationTarget)targetField, this.schema);
        this.testTarget.notEmptyObject((AnnotationTarget)targetField, this.schema);
        Assertions.assertEquals(null, (Object)this.schema.getNullable());
        Assertions.assertEquals(null, (Integer)this.schema.getMinProperties());
        Assertions.assertEquals(null, (Integer)this.schema.getMaxProperties());
        Assertions.assertNull((Object)parentSchema.getRequired());
    }

    @Test
    void testDecimalMaxPrimaryDigits() {
        FieldInfo targetField = this.targetClass.field("decimalMaxBigDecimalPrimaryDigits");
        this.testTarget.decimalMax((AnnotationTarget)targetField, this.schema);
        this.testTarget.digits((AnnotationTarget)targetField, this.schema);
        Assertions.assertEquals((Object)new BigDecimal("200.00"), (Object)this.schema.getMaximum());
        Assertions.assertEquals(null, (Object)this.schema.getExclusiveMaximum());
        Assertions.assertEquals((Object)"^\\d{1,3}([.]\\d{1,2})?$", (Object)this.schema.getPattern());
    }

    @Test
    void testDecimalMaxNoConstraint() {
        this.testTarget.decimalMax((AnnotationTarget)this.targetClass.field("decimalMaxBigDecimalNoConstraint"), this.schema);
        Assertions.assertEquals(null, (Object)this.schema.getMaximum());
        Assertions.assertEquals(null, (Object)this.schema.getExclusiveMaximum());
    }

    @Test
    void testDecimalMaxInvalidValue() {
        this.testTarget.decimalMax((AnnotationTarget)this.targetClass.field("decimalMaxBigDecimalInvalidValue"), this.schema);
        Assertions.assertEquals(null, (Object)this.schema.getMaximum());
        Assertions.assertEquals(null, (Object)this.schema.getExclusiveMaximum());
    }

    @Test
    void testDecimalMaxExclusiveDigits() {
        FieldInfo targetField = this.targetClass.field("decimalMaxBigDecimalExclusiveDigits");
        this.testTarget.decimalMax((AnnotationTarget)targetField, this.schema);
        this.testTarget.digits((AnnotationTarget)targetField, this.schema);
        Assertions.assertEquals((Object)new BigDecimal("201.0"), (Object)this.schema.getMaximum());
        Assertions.assertEquals((Object)Boolean.TRUE, (Object)this.schema.getExclusiveMaximum());
        Assertions.assertEquals((Object)"^\\d{1,3}([.]\\d)?$", (Object)this.schema.getPattern());
    }

    @Test
    void testDecimalMaxInclusive() {
        this.testTarget.decimalMax((AnnotationTarget)this.targetClass.field("decimalMaxBigDecimalInclusive"), this.schema);
        Assertions.assertEquals((Object)new BigDecimal("201.00"), (Object)this.schema.getMaximum());
        Assertions.assertEquals(null, (Object)this.schema.getExclusiveMaximum());
    }

    @Test
    void testDecimalMinPrimary() {
        this.testTarget.decimalMin((AnnotationTarget)this.targetClass.field("decimalMinBigDecimalPrimary"), this.schema);
        Assertions.assertEquals((Object)new BigDecimal("10.0"), (Object)this.schema.getMinimum());
        Assertions.assertEquals(null, (Object)this.schema.getExclusiveMinimum());
    }

    @Test
    void testDecimalMinNoConstraint() {
        this.testTarget.decimalMin((AnnotationTarget)this.targetClass.field("decimalMinBigDecimalNoConstraint"), this.schema);
        Assertions.assertEquals(null, (Object)this.schema.getMinimum());
        Assertions.assertEquals(null, (Object)this.schema.getExclusiveMinimum());
    }

    @Test
    void testDecimalMinInvalidValue() {
        this.testTarget.decimalMin((AnnotationTarget)this.targetClass.field("decimalMinBigDecimalInvalidValue"), this.schema);
        Assertions.assertEquals(null, (Object)this.schema.getMinimum());
        Assertions.assertEquals(null, (Object)this.schema.getExclusiveMinimum());
    }

    @Test
    void testDecimalMinExclusiveDigits() {
        FieldInfo targetField = this.targetClass.field("decimalMinBigDecimalExclusiveDigits");
        this.testTarget.decimalMin((AnnotationTarget)targetField, this.schema);
        this.testTarget.digits((AnnotationTarget)targetField, this.schema);
        Assertions.assertEquals((Object)new BigDecimal("9.00"), (Object)this.schema.getMinimum());
        Assertions.assertEquals((Object)Boolean.TRUE, (Object)this.schema.getExclusiveMinimum());
        Assertions.assertEquals((Object)"^\\d([.]\\d{1,2})?$", (Object)this.schema.getPattern());
    }

    @Test
    void testDecimalMinInclusive() {
        this.testTarget.decimalMin((AnnotationTarget)this.targetClass.field("decimalMinBigDecimalInclusive"), this.schema);
        Assertions.assertEquals((Object)new BigDecimal("9.00"), (Object)this.schema.getMinimum());
        Assertions.assertEquals(null, (Object)this.schema.getExclusiveMinimum());
    }

    @Test
    void testIntegerPositiveNotZeroMaxValue() {
        FieldInfo targetField = this.targetClass.field("integerPositiveNotZeroMaxValue");
        this.testTarget.max((AnnotationTarget)targetField, this.schema);
        this.testTarget.positive((AnnotationTarget)targetField, this.schema);
        Assertions.assertEquals((Object)new BigDecimal("1"), (Object)this.schema.getMinimum());
        Assertions.assertEquals(null, (Object)this.schema.getExclusiveMinimum());
        Assertions.assertEquals((Object)new BigDecimal("1000"), (Object)this.schema.getMaximum());
        Assertions.assertEquals(null, (Object)this.schema.getExclusiveMaximum());
    }

    @Test
    void testIntegerPositiveNotZeroMaxValueExclusive() {
        FieldInfo targetField = this.targetClass.field("integerPositiveNotZeroMaxValue");
        this.schema.setExclusiveMaximum(Boolean.TRUE);
        this.schema.setExclusiveMinimum(Boolean.TRUE);
        this.testTarget.max((AnnotationTarget)targetField, this.schema);
        this.testTarget.positive((AnnotationTarget)targetField, this.schema);
        Assertions.assertEquals((Object)new BigDecimal("0"), (Object)this.schema.getMinimum());
        Assertions.assertEquals((Object)Boolean.TRUE, (Object)this.schema.getExclusiveMinimum());
        Assertions.assertEquals((Object)new BigDecimal("1000"), (Object)this.schema.getMaximum());
        Assertions.assertEquals((Object)Boolean.TRUE, (Object)this.schema.getExclusiveMaximum());
    }

    @Test
    void testIntegerPositiveOrZeroMaxValue() {
        FieldInfo targetField = this.targetClass.field("integerPositiveOrZeroMaxValue");
        this.testTarget.max((AnnotationTarget)targetField, this.schema);
        this.testTarget.positiveOrZero((AnnotationTarget)targetField, this.schema);
        Assertions.assertEquals((Object)new BigDecimal("0"), (Object)this.schema.getMinimum());
        Assertions.assertEquals(null, (Object)this.schema.getExclusiveMinimum());
        Assertions.assertEquals((Object)new BigDecimal("999"), (Object)this.schema.getMaximum());
        Assertions.assertEquals(null, (Object)this.schema.getExclusiveMaximum());
    }

    @Test
    void testIntegerPositiveOrZeroMaxValueExclusive() {
        FieldInfo targetField = this.targetClass.field("integerPositiveOrZeroMaxValue");
        this.schema.setExclusiveMaximum(Boolean.TRUE);
        this.schema.setExclusiveMinimum(Boolean.TRUE);
        this.testTarget.max((AnnotationTarget)targetField, this.schema);
        this.testTarget.positiveOrZero((AnnotationTarget)targetField, this.schema);
        Assertions.assertEquals((Object)new BigDecimal("-1"), (Object)this.schema.getMinimum());
        Assertions.assertEquals((Object)Boolean.TRUE, (Object)this.schema.getExclusiveMinimum());
        Assertions.assertEquals((Object)new BigDecimal("999"), (Object)this.schema.getMaximum());
        Assertions.assertEquals((Object)Boolean.TRUE, (Object)this.schema.getExclusiveMaximum());
    }

    @Test
    void testIntegerNegativeNotZeroMinValue() {
        FieldInfo targetField = this.targetClass.field("integerNegativeNotZeroMinValue");
        this.testTarget.min((AnnotationTarget)targetField, this.schema);
        this.testTarget.negative((AnnotationTarget)targetField, this.schema);
        Assertions.assertEquals((Object)new BigDecimal("-1"), (Object)this.schema.getMaximum());
        Assertions.assertEquals(null, (Object)this.schema.getExclusiveMaximum());
        Assertions.assertEquals((Object)new BigDecimal("-1000000"), (Object)this.schema.getMinimum());
        Assertions.assertEquals(null, (Object)this.schema.getExclusiveMinimum());
    }

    @Test
    void testIntegerNegativeNotZeroMinValueExclusive() {
        FieldInfo targetField = this.targetClass.field("integerNegativeNotZeroMinValue");
        this.schema.setExclusiveMaximum(Boolean.TRUE);
        this.schema.setExclusiveMinimum(Boolean.TRUE);
        this.testTarget.min((AnnotationTarget)targetField, this.schema);
        this.testTarget.negative((AnnotationTarget)targetField, this.schema);
        Assertions.assertEquals((Object)new BigDecimal("0"), (Object)this.schema.getMaximum());
        Assertions.assertEquals((Object)Boolean.TRUE, (Object)this.schema.getExclusiveMaximum());
        Assertions.assertEquals((Object)new BigDecimal("-1000000"), (Object)this.schema.getMinimum());
        Assertions.assertEquals((Object)Boolean.TRUE, (Object)this.schema.getExclusiveMinimum());
    }

    @Test
    void testIntegerNegativeOrZeroMinValue() {
        FieldInfo targetField = this.targetClass.field("integerNegativeOrZeroMinValue");
        this.testTarget.min((AnnotationTarget)targetField, this.schema);
        this.testTarget.negativeOrZero((AnnotationTarget)targetField, this.schema);
        Assertions.assertEquals((Object)new BigDecimal("0"), (Object)this.schema.getMaximum());
        Assertions.assertEquals(null, (Object)this.schema.getExclusiveMaximum());
        Assertions.assertEquals((Object)new BigDecimal("-999"), (Object)this.schema.getMinimum());
        Assertions.assertEquals(null, (Object)this.schema.getExclusiveMinimum());
    }

    @Test
    void testIntegerNegativeOrZeroMinValueExclusive() {
        FieldInfo targetField = this.targetClass.field("integerNegativeOrZeroMinValue");
        this.schema.setExclusiveMaximum(Boolean.TRUE);
        this.schema.setExclusiveMinimum(Boolean.TRUE);
        this.testTarget.min((AnnotationTarget)targetField, this.schema);
        this.testTarget.negativeOrZero((AnnotationTarget)targetField, this.schema);
        Assertions.assertEquals((Object)new BigDecimal("1"), (Object)this.schema.getMaximum());
        Assertions.assertEquals((Object)Boolean.TRUE, (Object)this.schema.getExclusiveMaximum());
        Assertions.assertEquals((Object)new BigDecimal("-999"), (Object)this.schema.getMinimum());
        Assertions.assertEquals((Object)Boolean.TRUE, (Object)this.schema.getExclusiveMinimum());
    }

    @Test
    void testStringNotBlankNotNull() {
        FieldInfo targetField = this.targetClass.field("stringNotBlankNotNull");
        SchemaImpl parentSchema = new SchemaImpl();
        String propertyKey = "TESTKEY";
        this.testTarget.notBlank((AnnotationTarget)targetField, this.schema);
        this.testTarget.notNull((AnnotationTarget)targetField, this.schema, propertyKey, (arg_0, arg_1) -> BeanValidationScannerTest.lambda$testStringNotBlankNotNull$5((Schema)parentSchema, arg_0, arg_1));
        Assertions.assertEquals((Object)"\\S", (Object)this.schema.getPattern());
        Assertions.assertEquals((Object)Boolean.FALSE, (Object)this.schema.getNullable());
        Assertions.assertEquals(Arrays.asList(propertyKey), (Object)parentSchema.getRequired());
    }

    @Test
    void testStringNotBlankDigits() {
        FieldInfo targetField = this.targetClass.field("stringNotBlankDigits");
        this.testTarget.digits((AnnotationTarget)targetField, this.schema);
        this.testTarget.notBlank((AnnotationTarget)targetField, this.schema);
        Assertions.assertEquals((Object)"^\\d{1,8}([.]\\d{1,10})?$", (Object)this.schema.getPattern());
        Assertions.assertEquals((Object)Boolean.FALSE, (Object)this.schema.getNullable());
    }

    @Test
    void testStringNotEmptyMaxSize() {
        FieldInfo targetField = this.targetClass.field("stringNotEmptyMaxSize");
        this.testTarget.sizeString((AnnotationTarget)targetField, this.schema);
        this.testTarget.notEmptyString((AnnotationTarget)targetField, this.schema);
        Assertions.assertEquals((Integer)1, (Integer)this.schema.getMinLength());
        Assertions.assertEquals((Integer)2000, (Integer)this.schema.getMaxLength());
        Assertions.assertEquals((Object)Boolean.FALSE, (Object)this.schema.getNullable());
    }

    @Test
    void testStringNotEmptySizeRange() {
        FieldInfo targetField = this.targetClass.field("stringNotEmptySizeRange");
        this.testTarget.sizeString((AnnotationTarget)targetField, this.schema);
        this.testTarget.notEmptyString((AnnotationTarget)targetField, this.schema);
        Assertions.assertEquals((Integer)100, (Integer)this.schema.getMinLength());
        Assertions.assertEquals((Integer)2000, (Integer)this.schema.getMaxLength());
        Assertions.assertEquals((Object)Boolean.FALSE, (Object)this.schema.getNullable());
    }

    @Test
    void testJacksonRequiredString() {
        String propertyKey = "jacksonRequiredTrueString";
        FieldInfo targetField = this.targetClass.field(propertyKey);
        SchemaImpl parentSchema = new SchemaImpl();
        this.testTarget.requiredJackson((AnnotationTarget)targetField, propertyKey, (arg_0, arg_1) -> BeanValidationScannerTest.lambda$testJacksonRequiredString$6((Schema)parentSchema, arg_0, arg_1));
        Assertions.assertNull((Object)this.schema.getNullable());
        Assertions.assertEquals(Arrays.asList(propertyKey), (Object)parentSchema.getRequired());
    }

    @Test
    void testJacksonDefaultString() {
        String propertyKey = "jacksonDefaultString";
        FieldInfo targetField = this.targetClass.field(propertyKey);
        SchemaImpl parentSchema = new SchemaImpl();
        this.testTarget.requiredJackson((AnnotationTarget)targetField, propertyKey, (arg_0, arg_1) -> BeanValidationScannerTest.lambda$testJacksonDefaultString$7((Schema)parentSchema, arg_0, arg_1));
        Assertions.assertNull((Object)this.schema.getNullable());
        Assertions.assertNull((Object)parentSchema.getRequired());
    }

    private static /* synthetic */ void lambda$testJacksonDefaultString$7(Schema parentSchema, AnnotationTarget target, String name) {
        parentSchema.addRequired(name);
    }

    private static /* synthetic */ void lambda$testJacksonRequiredString$6(Schema parentSchema, AnnotationTarget target, String name) {
        parentSchema.addRequired(name);
    }

    private static /* synthetic */ void lambda$testStringNotBlankNotNull$5(Schema parentSchema, AnnotationTarget target, String name) {
        parentSchema.addRequired(name);
    }

    private static /* synthetic */ void lambda$testMapObjectNotNullAndNotEmptyAndMaxProperties$2(Schema parentSchema, AnnotationTarget target, String name) {
        parentSchema.addRequired(name);
    }

    private static /* synthetic */ void lambda$testArrayListNotNullAndNotEmptyAndMaxItems$0(Schema parentSchema, AnnotationTarget target, String name) {
        parentSchema.addRequired(name);
    }

    static class BVTestContainer {
        @NotNull
        @NotEmpty
        @Size(max=20)
        @NotNull @NotEmpty @Size(max=20) List<String> arrayListNotNullAndNotEmptyAndMaxItems;
        @NotEmpty
        @Size(min=5, max=20)
        @NotEmpty @Size(min=5, max=20) List<String> arrayListNullableAndMinItemsAndMaxItems;
        @NotNull
        @NotEmpty
        @Size(max=20)
        @NotNull @NotEmpty @Size(max=20) Map<String, String> mapObjectNotNullAndNotEmptyAndMaxProperties;
        @NotEmpty
        @Size(min=5, max=20)
        @NotEmpty @Size(min=5, max=20) Map<String, String> mapObjectNullableAndMinPropertiesAndMaxProperties;
        @DecimalMax(value="200.00")
        @Digits(integer=3, fraction=2)
        private @DecimalMax(value="200.00") @Digits(integer=3, fraction=2) BigDecimal decimalMaxBigDecimalPrimaryDigits;
        private BigDecimal decimalMaxBigDecimalNoConstraint;
        @DecimalMax(value="Invalid BigDecimal value")
        private @DecimalMax(value="Invalid BigDecimal value") BigDecimal decimalMaxBigDecimalInvalidValue;
        @DecimalMax(value="201.0", inclusive=false, groups={})
        @Digits(integer=3, fraction=1)
        private @DecimalMax(value="201.0", inclusive=false, groups={}) @Digits(integer=3, fraction=1) BigDecimal decimalMaxBigDecimalExclusiveDigits;
        @DecimalMax(value="201.00", inclusive=true, groups={Default.class})
        private @DecimalMax(value="201.00", inclusive=true, groups={Default.class}) BigDecimal decimalMaxBigDecimalInclusive;
        @DecimalMin(value="10.0")
        private @DecimalMin(value="10.0") BigDecimal decimalMinBigDecimalPrimary;
        private BigDecimal decimalMinBigDecimalNoConstraint;
        @DecimalMin(value="Invalid BigDecimal value")
        private @DecimalMin(value="Invalid BigDecimal value") BigDecimal decimalMinBigDecimalInvalidValue;
        @DecimalMin(value="9.00", inclusive=false)
        @Digits(integer=1, fraction=2)
        private @DecimalMin(value="9.00", inclusive=false) @Digits(integer=1, fraction=2) BigDecimal decimalMinBigDecimalExclusiveDigits;
        @DecimalMin(value="9.00", inclusive=true)
        private @DecimalMin(value="9.00", inclusive=true) BigDecimal decimalMinBigDecimalInclusive;
        @Positive
        @Max(value=1000L)
        private @Positive @Max(value=1000L) Long integerPositiveNotZeroMaxValue;
        @PositiveOrZero
        @Max(value=999L)
        private @PositiveOrZero @Max(value=999L) Integer integerPositiveOrZeroMaxValue;
        @Negative
        @Min(value=-1000000L)
        private @Negative @Min(value=-1000000L) Long integerNegativeNotZeroMinValue;
        @NegativeOrZero
        @Min(value=-999L)
        private @NegativeOrZero @Min(value=-999L) Integer integerNegativeOrZeroMinValue;
        @NotNull
        @NotBlank
        private String stringNotBlankNotNull;
        @Digits(integer=8, fraction=10)
        @NotBlank
        private @Digits(integer=8, fraction=10) @NotBlank String stringNotBlankDigits;
        @NotEmpty
        @Size(max=2000)
        private @NotEmpty @Size(max=2000) String stringNotEmptyMaxSize;
        @NotEmpty
        @Size(min=100, max=2000)
        private @NotEmpty @Size(min=100, max=2000) String stringNotEmptySizeRange;
        @NotNull
        private boolean booleanNotNull;
        @JsonProperty(required=true)
        private String jacksonRequiredTrueString;
        @JsonProperty
        private String jacksonDefaultString;

        BVTestContainer() {
        }
    }
}

