/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.openapi.runtime.scanner;

import io.smallrye.openapi.api.OpenApiConfig;
import io.smallrye.openapi.api.OpenApiConfigImpl;
import io.smallrye.openapi.api.models.ComponentsImpl;
import io.smallrye.openapi.api.models.OpenAPIImpl;
import io.smallrye.openapi.runtime.io.Format;
import io.smallrye.openapi.runtime.io.OpenApiSerializer;
import io.smallrye.openapi.runtime.scanner.OpenApiAnnotationScanner;
import io.smallrye.openapi.runtime.scanner.SchemaRegistry;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UncheckedIOException;
import java.net.URL;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.io.IOUtils;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.spi.ConfigSource;
import org.eclipse.microprofile.openapi.models.Components;
import org.eclipse.microprofile.openapi.models.OpenAPI;
import org.eclipse.microprofile.openapi.models.media.Schema;
import org.jboss.jandex.DotName;
import org.jboss.jandex.Index;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.Indexer;
import org.jboss.logging.Logger;
import org.json.JSONException;
import org.junit.After;
import org.skyscreamer.jsonassert.JSONAssert;

public class IndexScannerTestBase {
    private static final Logger LOG = Logger.getLogger(IndexScannerTestBase.class);

    @After
    public void removeSchemaRegistry() {
        SchemaRegistry.remove();
    }

    protected static String pathOf(Class<?> clazz) {
        return clazz.getName().replace('.', '/').concat(".class");
    }

    protected static void indexDirectory(Indexer indexer, String baseDir) {
        InputStream directoryStream = IndexScannerTestBase.tcclGetResourceAsStream(baseDir);
        BufferedReader reader = new BufferedReader(new InputStreamReader(directoryStream));
        reader.lines().filter(resName -> resName.endsWith(".class")).map(resName -> Paths.get(baseDir, resName)).forEach(path -> IndexScannerTestBase.index(indexer, path.toString()));
    }

    private static InputStream tcclGetResourceAsStream(String path) {
        return Thread.currentThread().getContextClassLoader().getResourceAsStream(path);
    }

    public static Index indexOf(Class<?> ... classes) {
        Indexer indexer = new Indexer();
        for (Class<?> klazz : classes) {
            IndexScannerTestBase.index(indexer, IndexScannerTestBase.pathOf(klazz));
        }
        return indexer.complete();
    }

    protected static void index(Indexer indexer, String resName) {
        try {
            InputStream stream = IndexScannerTestBase.tcclGetResourceAsStream(resName);
            indexer.index(stream);
        }
        catch (IOException ioe) {
            throw new UncheckedIOException(ioe);
        }
    }

    protected static DotName componentize(String className) {
        boolean innerClass = className.contains("$");
        DotName prefix = null;
        String[] components = className.split("[\\.$]");
        int lastIndex = components.length - 1;
        for (int i = 0; i < components.length; ++i) {
            String localName = components[i];
            prefix = i < lastIndex ? DotName.createComponentized(prefix, (String)localName) : DotName.createComponentized((DotName)prefix, (String)localName, (boolean)innerClass);
        }
        return prefix;
    }

    public static void printToConsole(String entityName, Schema schema) throws IOException {
        LOG.debug((Object)IndexScannerTestBase.schemaToString(entityName, schema));
        System.out.println(IndexScannerTestBase.schemaToString(entityName, schema));
    }

    public static void printToConsole(OpenAPI oai) throws IOException {
        LOG.debug((Object)OpenApiSerializer.serialize((OpenAPI)oai, (Format)Format.JSON));
        System.out.println(OpenApiSerializer.serialize((OpenAPI)oai, (Format)Format.JSON));
    }

    public static String schemaToString(String entityName, Schema schema) throws IOException {
        HashMap<String, Schema> map = new HashMap<String, Schema>();
        map.put(entityName, schema);
        OpenAPIImpl oai = new OpenAPIImpl();
        ComponentsImpl comp = new ComponentsImpl();
        comp.setSchemas(map);
        oai.setComponents((Components)comp);
        return OpenApiSerializer.serialize((OpenAPI)oai, (Format)Format.JSON);
    }

    public static void assertJsonEquals(String entityName, String expectedResource, Schema actual) throws JSONException, IOException {
        URL resourceUrl = IndexScannerTestBase.class.getResource(expectedResource);
        JSONAssert.assertEquals((String)IndexScannerTestBase.loadResource(resourceUrl), (String)IndexScannerTestBase.schemaToString(entityName, actual), (boolean)true);
    }

    public static void assertJsonEquals(String expectedResource, OpenAPI actual) throws JSONException, IOException {
        URL resourceUrl = IndexScannerTestBase.class.getResource(expectedResource);
        JSONAssert.assertEquals((String)IndexScannerTestBase.loadResource(resourceUrl), (String)OpenApiSerializer.serialize((OpenAPI)actual, (Format)Format.JSON), (boolean)true);
    }

    public static void assertJsonEquals(String expectedResource, Class<?> ... classes) throws IOException, JSONException {
        Index index = IndexScannerTestBase.indexOf(classes);
        OpenApiAnnotationScanner scanner = new OpenApiAnnotationScanner(IndexScannerTestBase.nestingSupportConfig(), (IndexView)index);
        OpenAPI result = scanner.scan(new String[0]);
        IndexScannerTestBase.printToConsole(result);
        IndexScannerTestBase.assertJsonEquals(expectedResource, result);
    }

    public static String loadResource(URL testResource) throws IOException {
        return IOUtils.toString((URL)testResource, (String)"UTF-8");
    }

    public static OpenApiConfig emptyConfig() {
        return IndexScannerTestBase.dynamicConfig(Collections.emptyMap());
    }

    public static OpenApiConfig nestingSupportConfig() {
        HashMap<String, Object> config = new HashMap<String, Object>(2);
        config.put("mp.openapi.extensions.smallrye.schema-references.enable", Boolean.TRUE);
        return IndexScannerTestBase.dynamicConfig(config);
    }

    public static OpenApiConfig dynamicConfig(String key, Object value) {
        HashMap<String, Object> config = new HashMap<String, Object>(1);
        config.put(key, value);
        return IndexScannerTestBase.dynamicConfig(config);
    }

    public static OpenApiConfig dynamicConfig(final Map<String, Object> properties) {
        return new OpenApiConfigImpl(new Config(){

            public <T> T getValue(String propertyName, Class<T> propertyType) {
                return (T)properties.get(propertyName);
            }

            public <T> Optional<T> getOptionalValue(String propertyName, Class<T> propertyType) {
                return Optional.ofNullable(properties.getOrDefault(propertyName, null));
            }

            public Iterable<String> getPropertyNames() {
                return properties.keySet();
            }

            public Iterable<ConfigSource> getConfigSources() {
                return Collections.emptyList();
            }
        });
    }
}

