/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.openapi.api.util;

import io.smallrye.openapi.api.util.FilterUtil;
import io.smallrye.openapi.runtime.io.Format;
import io.smallrye.openapi.runtime.io.OpenApiParser;
import io.smallrye.openapi.runtime.io.OpenApiSerializer;
import java.io.IOException;
import java.net.URL;
import org.apache.commons.io.IOUtils;
import org.eclipse.microprofile.openapi.OASFilter;
import org.eclipse.microprofile.openapi.models.OpenAPI;
import org.eclipse.microprofile.openapi.models.Operation;
import org.eclipse.microprofile.openapi.models.PathItem;
import org.eclipse.microprofile.openapi.models.tags.Tag;
import org.json.JSONException;
import org.junit.Test;
import org.skyscreamer.jsonassert.JSONAssert;

public class FilterUtilTest {
    private static String loadResource(URL testResource) throws IOException {
        return IOUtils.toString((URL)testResource, (String)"UTF-8");
    }

    private static void assertJsonEquals(String expected, String actual) throws JSONException {
        JSONAssert.assertEquals((String)expected, (String)actual, (boolean)true);
    }

    @Test
    public void testApplyFilter() throws Exception {
        URL beforeUrl = FilterUtilTest.class.getResource("filter-before.json");
        URL afterUrl = FilterUtilTest.class.getResource("filter-after.json");
        OpenAPI model = OpenApiParser.parse((URL)beforeUrl);
        OASFilter filter = this.filter();
        model = FilterUtil.applyFilter((OASFilter)filter, (OpenAPI)model);
        String actual = OpenApiSerializer.serialize((OpenAPI)model, (Format)Format.JSON);
        String expected = FilterUtilTest.loadResource(afterUrl);
        FilterUtilTest.assertJsonEquals(expected, actual);
    }

    private OASFilter filter() {
        return new OASFilter(){

            public void filterOpenAPI(OpenAPI openAPI) {
                openAPI.getInfo().setLicense(null);
                openAPI.getInfo().setTitle("Updated API Title");
            }

            public Tag filterTag(Tag tag) {
                if (tag.getName().equals("tag-1")) {
                    return null;
                }
                return tag;
            }

            public PathItem filterPathItem(PathItem pathItem) {
                if (pathItem.getRef() != null) {
                    return null;
                }
                return pathItem;
            }

            public Operation filterOperation(Operation operation) {
                if (operation.getTags() != null && operation.getTags().contains("tag-1")) {
                    operation.removeTag("tag-1");
                }
                return operation;
            }
        };
    }
}

