/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.openapi.runtime.io.link;

import com.fasterxml.jackson.databind.JsonNode;
import io.smallrye.openapi.api.models.links.LinkImpl;
import io.smallrye.openapi.runtime.io.IoLogging;
import io.smallrye.openapi.runtime.io.JsonUtil;
import io.smallrye.openapi.runtime.io.extension.ExtensionReader;
import io.smallrye.openapi.runtime.io.server.ServerReader;
import io.smallrye.openapi.runtime.util.JandexUtil;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.microprofile.openapi.models.links.Link;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationValue;

public class LinkReader {
    private LinkReader() {
    }

    public static Map<String, Link> readLinks(AnnotationValue annotationValue) {
        AnnotationInstance[] nestedArray;
        if (annotationValue == null) {
            return null;
        }
        IoLogging.log.annotationsMap("@Link");
        LinkedHashMap<String, Link> links = new LinkedHashMap<String, Link>();
        for (AnnotationInstance nested : nestedArray = annotationValue.asNestedArray()) {
            String name = JandexUtil.stringValue(nested, "name");
            if (name == null && JandexUtil.isRef(nested)) {
                name = JandexUtil.nameFromRef(nested);
            }
            if (name == null) continue;
            links.put(name, LinkReader.readLink(nested));
        }
        return links;
    }

    public static Map<String, Link> readLinks(JsonNode node) {
        if (node == null || !node.isObject()) {
            return null;
        }
        IoLogging.log.jsonNodeMap("Link");
        LinkedHashMap<String, Link> links = new LinkedHashMap<String, Link>();
        Iterator fieldNames = node.fieldNames();
        while (fieldNames.hasNext()) {
            String fieldName = (String)fieldNames.next();
            JsonNode childNode = node.get(fieldName);
            links.put(fieldName, LinkReader.readLink(childNode));
        }
        return links;
    }

    private static Link readLink(AnnotationInstance annotationInstance) {
        if (annotationInstance == null) {
            return null;
        }
        IoLogging.log.singleAnnotation("@Link");
        LinkImpl link = new LinkImpl();
        link.setOperationRef(JandexUtil.stringValue(annotationInstance, "operationRef"));
        link.setOperationId(JandexUtil.stringValue(annotationInstance, "operationId"));
        link.setParameters(LinkReader.readLinkParameters(annotationInstance.value("parameters")));
        link.setDescription(JandexUtil.stringValue(annotationInstance, "description"));
        link.setRequestBody(JandexUtil.stringValue(annotationInstance, "requestBody"));
        link.setServer(ServerReader.readServer(annotationInstance.value("server")));
        link.setRef(JandexUtil.refValue(annotationInstance, JandexUtil.RefType.Link));
        return link;
    }

    private static Link readLink(JsonNode node) {
        if (node == null || !node.isObject()) {
            return null;
        }
        IoLogging.log.singleJsonNode("Link");
        LinkImpl link = new LinkImpl();
        link.setRef(JsonUtil.stringProperty(node, "$ref"));
        link.setOperationRef(JsonUtil.stringProperty(node, "operationRef"));
        link.setOperationId(JsonUtil.stringProperty(node, "operationId"));
        link.setParameters(LinkReader.readLinkParameters(node.get("parameters")));
        link.setRequestBody(JsonUtil.readObject(node.get("requestBody")));
        link.setDescription(JsonUtil.stringProperty(node, "description"));
        link.setServer(ServerReader.readServer(node.get("server")));
        ExtensionReader.readExtensions(node, link);
        return link;
    }

    private static Map<String, Object> readLinkParameters(AnnotationValue annotationValue) {
        if (annotationValue == null) {
            return null;
        }
        AnnotationInstance[] nestedArray = annotationValue.asNestedArray();
        LinkedHashMap<String, Object> linkParams = new LinkedHashMap<String, Object>();
        for (AnnotationInstance annotation : nestedArray) {
            String name = JandexUtil.stringValue(annotation, "name");
            if (name == null) continue;
            String expression = JandexUtil.stringValue(annotation, "expression");
            linkParams.put(name, expression);
        }
        return linkParams;
    }

    private static Map<String, Object> readLinkParameters(JsonNode node) {
        if (node == null || !node.isObject()) {
            return null;
        }
        LinkedHashMap<String, Object> rval = new LinkedHashMap<String, Object>();
        Iterator fieldNames = node.fieldNames();
        while (fieldNames.hasNext()) {
            String fieldName = (String)fieldNames.next();
            Object value = JsonUtil.readObject(node.get(fieldName));
            rval.put(fieldName, value);
        }
        return rval;
    }
}

