/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.openapi.runtime.util;

import io.smallrye.openapi.api.OpenApiConstants;
import io.smallrye.openapi.api.models.ExternalDocumentationImpl;
import io.smallrye.openapi.api.models.media.DiscriminatorImpl;
import io.smallrye.openapi.api.models.media.SchemaImpl;
import io.smallrye.openapi.api.util.MergeUtil;
import io.smallrye.openapi.runtime.scanner.AnnotationScannerExtension;
import io.smallrye.openapi.runtime.scanner.OpenApiDataObjectScanner;
import io.smallrye.openapi.runtime.scanner.SchemaRegistry;
import io.smallrye.openapi.runtime.util.JandexUtil;
import io.smallrye.openapi.runtime.util.ModelUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.microprofile.openapi.models.ExternalDocumentation;
import org.eclipse.microprofile.openapi.models.media.Discriminator;
import org.eclipse.microprofile.openapi.models.media.Schema;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassType;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.ParameterizedType;
import org.jboss.jandex.Type;
import org.jboss.logging.Logger;

public class SchemaFactory {
    private static Logger LOG = Logger.getLogger(SchemaFactory.class);

    private SchemaFactory() {
    }

    public static Schema readSchema(IndexView index, AnnotationValue value) {
        if (value == null) {
            return null;
        }
        return SchemaFactory.readSchema(index, value.asNested());
    }

    public static Schema readSchema(IndexView index, AnnotationInstance annotation) {
        if (annotation == null) {
            return null;
        }
        LOG.debug((Object)"Processing a single @Schema annotation.");
        Boolean isHidden = JandexUtil.booleanValue(annotation, "hidden");
        if (isHidden != null && isHidden == Boolean.TRUE) {
            return null;
        }
        return SchemaFactory.readSchema(index, new SchemaImpl(), annotation, Collections.emptyMap());
    }

    public static Schema readSchema(IndexView index, Schema schema, AnnotationInstance annotation, Map<String, Object> overrides) {
        if (annotation == null) {
            return schema;
        }
        Boolean isHidden = JandexUtil.booleanValue(annotation, "hidden");
        if (isHidden != null && isHidden == Boolean.TRUE) {
            return schema;
        }
        schema.setNot((Schema)overrides.getOrDefault("not", SchemaFactory.readClassSchema(index, annotation.value("not"), true)));
        schema.setOneOf(overrides.getOrDefault("oneOf", SchemaFactory.readClassSchemas(index, annotation.value("oneOf"))));
        schema.setAnyOf(overrides.getOrDefault("anyOf", SchemaFactory.readClassSchemas(index, annotation.value("anyOf"))));
        schema.setAllOf(overrides.getOrDefault("allOf", SchemaFactory.readClassSchemas(index, annotation.value("allOf"))));
        schema.setTitle((String)overrides.getOrDefault("title", JandexUtil.stringValue(annotation, "title")));
        schema.setMultipleOf((BigDecimal)overrides.getOrDefault("multipleOf", JandexUtil.bigDecimalValue(annotation, "multipleOf")));
        schema.setMaximum((BigDecimal)overrides.getOrDefault("maximum", JandexUtil.bigDecimalValue(annotation, "maximum")));
        schema.setExclusiveMaximum((Boolean)overrides.getOrDefault("exclusiveMaximum", JandexUtil.booleanValue(annotation, "exclusiveMaximum")));
        schema.setMinimum((BigDecimal)overrides.getOrDefault("minimum", JandexUtil.bigDecimalValue(annotation, "minimum")));
        schema.setExclusiveMinimum((Boolean)overrides.getOrDefault("exclusiveMinimum", JandexUtil.booleanValue(annotation, "exclusiveMinimum")));
        schema.setMaxLength((Integer)overrides.getOrDefault("maxLength", JandexUtil.intValue(annotation, "maxLength")));
        schema.setMinLength((Integer)overrides.getOrDefault("minLength", JandexUtil.intValue(annotation, "minLength")));
        schema.setPattern((String)overrides.getOrDefault("pattern", JandexUtil.stringValue(annotation, "pattern")));
        schema.setMaxProperties((Integer)overrides.getOrDefault("maxProperties", JandexUtil.intValue(annotation, "maxProperties")));
        schema.setMinProperties((Integer)overrides.getOrDefault("minProperties", JandexUtil.intValue(annotation, "minProperties")));
        schema.setRequired(overrides.getOrDefault("requiredProperties", JandexUtil.stringListValue(annotation, "requiredProperties")));
        schema.setDescription((String)overrides.getOrDefault("description", JandexUtil.stringValue(annotation, "description")));
        schema.setFormat((String)overrides.getOrDefault("format", JandexUtil.stringValue(annotation, "format")));
        schema.setRef((String)overrides.getOrDefault("ref", JandexUtil.stringValue(annotation, "ref")));
        schema.setNullable((Boolean)overrides.getOrDefault("nullable", JandexUtil.booleanValue(annotation, "nullable")));
        schema.setReadOnly((Boolean)overrides.getOrDefault("readOnly", JandexUtil.booleanValue(annotation, "readOnly")));
        schema.setWriteOnly((Boolean)overrides.getOrDefault("writeOnly", JandexUtil.booleanValue(annotation, "writeOnly")));
        schema.setExample(overrides.getOrDefault("example", JandexUtil.stringValue(annotation, "example")));
        schema.setExternalDocs(SchemaFactory.readExternalDocs(annotation.value("externalDocs")));
        schema.setDeprecated((Boolean)overrides.getOrDefault("deprecated", JandexUtil.booleanValue(annotation, "deprecated")));
        schema.setType((Schema.SchemaType)overrides.getOrDefault("type", JandexUtil.enumValue(annotation, "type", Schema.SchemaType.class)));
        schema.setDefaultValue(overrides.getOrDefault("defaultValue", JandexUtil.stringValue(annotation, "defaultValue")));
        schema.setDiscriminator(SchemaFactory.readDiscriminator(index, JandexUtil.stringValue(annotation, "discriminatorProperty"), annotation.value("discriminatorMapping")));
        schema.setMaxItems((Integer)overrides.getOrDefault("maxItems", JandexUtil.intValue(annotation, "maxItems")));
        schema.setMinItems((Integer)overrides.getOrDefault("minItems", JandexUtil.intValue(annotation, "minItems")));
        schema.setUniqueItems((Boolean)overrides.getOrDefault("uniqueItems", JandexUtil.booleanValue(annotation, "uniqueItems")));
        List<String> enumeration = overrides.getOrDefault("enumeration", JandexUtil.stringListValue(annotation, "enumeration"));
        if (enumeration != null && !enumeration.isEmpty()) {
            schema.setEnumeration(enumeration);
        }
        if (schema instanceof SchemaImpl) {
            ((SchemaImpl)schema).setName((String)overrides.getOrDefault("name", JandexUtil.stringValue(annotation, "name")));
        }
        if (JandexUtil.isSimpleClassSchema(annotation)) {
            Schema implSchema = SchemaFactory.readClassSchema(index, annotation.value("implementation"), true);
            schema = MergeUtil.mergeObjects(implSchema, schema);
        } else if (JandexUtil.isSimpleArraySchema(annotation)) {
            Schema implSchema = SchemaFactory.readClassSchema(index, annotation.value("implementation"), true);
            schema.setItems(implSchema);
        } else {
            Schema implSchema = SchemaFactory.readClassSchema(index, annotation.value("implementation"), false);
            if (schema.getType() == Schema.SchemaType.ARRAY && implSchema != null) {
                schema.setItems(implSchema);
            } else if (implSchema != null) {
                schema = MergeUtil.mergeObjects(implSchema, schema);
            }
        }
        return schema;
    }

    public static Schema readClassSchema(IndexView index, AnnotationValue value, boolean schemaReferenceSupported) {
        if (value == null) {
            return null;
        }
        ClassType ctype = (ClassType)value.asClass();
        return SchemaFactory.introspectClassToSchema(index, ctype, schemaReferenceSupported);
    }

    public static Schema typeToSchema(IndexView index, Type type, List<AnnotationScannerExtension> extensions) {
        Schema schema = null;
        if (type.kind() == Type.Kind.CLASS) {
            schema = SchemaFactory.introspectClassToSchema(index, type.asClassType(), true);
        } else if (type.kind() == Type.Kind.PRIMITIVE) {
            schema = OpenApiDataObjectScanner.process(type.asPrimitiveType());
        } else {
            Type asyncType = SchemaFactory.resolveAsyncType(type, extensions);
            schema = OpenApiDataObjectScanner.process(index, asyncType);
        }
        return schema;
    }

    private static Schema introspectClassToSchema(IndexView index, ClassType ctype, boolean schemaReferenceSupported) {
        if (ctype.name().equals((Object)OpenApiConstants.DOTNAME_RESPONSE)) {
            return null;
        }
        SchemaRegistry schemaRegistry = SchemaRegistry.currentInstance();
        if (schemaReferenceSupported && schemaRegistry.has((Type)ctype)) {
            return schemaRegistry.lookupRef((Type)ctype);
        }
        Schema schema = OpenApiDataObjectScanner.process(index, (Type)ctype);
        if (schemaReferenceSupported && schema != null && index.getClassByName(ctype.name()) != null) {
            return schemaRegistry.register((Type)ctype, schema);
        }
        return schema;
    }

    private static List<Schema> readClassSchemas(IndexView index, AnnotationValue value) {
        if (value == null) {
            return null;
        }
        LOG.debug((Object)"Processing a list of schema Class annotations.");
        Type[] classArray = value.asClassArray();
        ArrayList<Schema> schemas = new ArrayList<Schema>(classArray.length);
        for (Type type : classArray) {
            ClassType ctype = (ClassType)type;
            Schema schema = SchemaFactory.introspectClassToSchema(index, ctype, true);
            schemas.add(schema);
        }
        return schemas;
    }

    private static Type resolveAsyncType(Type type, List<AnnotationScannerExtension> extensions) {
        ParameterizedType pType;
        if (type.kind() == Type.Kind.PARAMETERIZED_TYPE && (pType = type.asParameterizedType()).name().equals((Object)OpenApiConstants.COMPLETION_STAGE_NAME) && pType.arguments().size() == 1) {
            return (Type)pType.arguments().get(0);
        }
        for (AnnotationScannerExtension extension : extensions) {
            Type asyncType = extension.resolveAsyncType(type);
            if (asyncType == null) continue;
            return asyncType;
        }
        return type;
    }

    private static Discriminator readDiscriminator(IndexView index, String propertyName, AnnotationValue annotation) {
        if (propertyName == null && annotation == null) {
            return null;
        }
        DiscriminatorImpl discriminator = new DiscriminatorImpl();
        if (propertyName != null) {
            discriminator.setPropertyName(propertyName);
        }
        if (annotation != null) {
            LOG.debug((Object)"Processing a list of @DiscriminatorMapping annotations.");
            for (AnnotationInstance nested : annotation.asNestedArray()) {
                String schemaRef;
                String propertyValue = JandexUtil.stringValue(nested, "value");
                AnnotationValue schemaValue = nested.value("schema");
                if (schemaValue != null) {
                    ClassType schemaType = schemaValue.asClass().asClassType();
                    Schema schema = SchemaFactory.introspectClassToSchema(index, schemaType, true);
                    schemaRef = schema.getRef();
                } else {
                    schemaRef = null;
                }
                if (propertyValue == null && schemaRef != null) {
                    propertyValue = ModelUtil.nameFromRef(schemaRef);
                }
                discriminator.addMapping(propertyValue, schemaRef);
            }
        }
        return discriminator;
    }

    private static ExternalDocumentation readExternalDocs(AnnotationValue externalDocAnno) {
        if (externalDocAnno == null) {
            return null;
        }
        AnnotationInstance nested = externalDocAnno.asNested();
        ExternalDocumentationImpl externalDoc = new ExternalDocumentationImpl();
        externalDoc.setDescription(JandexUtil.stringValue(nested, "description"));
        externalDoc.setUrl(JandexUtil.stringValue(nested, "url"));
        return externalDoc;
    }
}

