/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.openapi.runtime.scanner;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.smallrye.openapi.api.OpenApiConfig;
import io.smallrye.openapi.api.OpenApiConstants;
import io.smallrye.openapi.api.models.ComponentsImpl;
import io.smallrye.openapi.api.models.ExternalDocumentationImpl;
import io.smallrye.openapi.api.models.OpenAPIImpl;
import io.smallrye.openapi.api.models.OperationImpl;
import io.smallrye.openapi.api.models.PathItemImpl;
import io.smallrye.openapi.api.models.PathsImpl;
import io.smallrye.openapi.api.models.callbacks.CallbackImpl;
import io.smallrye.openapi.api.models.examples.ExampleImpl;
import io.smallrye.openapi.api.models.headers.HeaderImpl;
import io.smallrye.openapi.api.models.info.ContactImpl;
import io.smallrye.openapi.api.models.info.InfoImpl;
import io.smallrye.openapi.api.models.info.LicenseImpl;
import io.smallrye.openapi.api.models.links.LinkImpl;
import io.smallrye.openapi.api.models.media.ContentImpl;
import io.smallrye.openapi.api.models.media.EncodingImpl;
import io.smallrye.openapi.api.models.media.MediaTypeImpl;
import io.smallrye.openapi.api.models.parameters.ParameterImpl;
import io.smallrye.openapi.api.models.parameters.RequestBodyImpl;
import io.smallrye.openapi.api.models.responses.APIResponseImpl;
import io.smallrye.openapi.api.models.responses.APIResponsesImpl;
import io.smallrye.openapi.api.models.security.OAuthFlowImpl;
import io.smallrye.openapi.api.models.security.OAuthFlowsImpl;
import io.smallrye.openapi.api.models.security.ScopesImpl;
import io.smallrye.openapi.api.models.security.SecurityRequirementImpl;
import io.smallrye.openapi.api.models.security.SecuritySchemeImpl;
import io.smallrye.openapi.api.models.servers.ServerImpl;
import io.smallrye.openapi.api.models.servers.ServerVariableImpl;
import io.smallrye.openapi.api.models.servers.ServerVariablesImpl;
import io.smallrye.openapi.api.models.tags.TagImpl;
import io.smallrye.openapi.api.util.MergeUtil;
import io.smallrye.openapi.runtime.scanner.AnnotationScannerExtension;
import io.smallrye.openapi.runtime.scanner.CustomSchemaRegistry;
import io.smallrye.openapi.runtime.scanner.SchemaRegistry;
import io.smallrye.openapi.runtime.util.JandexUtil;
import io.smallrye.openapi.runtime.util.ModelUtil;
import io.smallrye.openapi.runtime.util.SchemaFactory;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.ws.rs.core.Application;
import org.apache.commons.beanutils.PropertyUtils;
import org.eclipse.microprofile.openapi.annotations.enums.Explode;
import org.eclipse.microprofile.openapi.models.Components;
import org.eclipse.microprofile.openapi.models.ExternalDocumentation;
import org.eclipse.microprofile.openapi.models.Operation;
import org.eclipse.microprofile.openapi.models.PathItem;
import org.eclipse.microprofile.openapi.models.Paths;
import org.eclipse.microprofile.openapi.models.callbacks.Callback;
import org.eclipse.microprofile.openapi.models.examples.Example;
import org.eclipse.microprofile.openapi.models.headers.Header;
import org.eclipse.microprofile.openapi.models.info.Contact;
import org.eclipse.microprofile.openapi.models.info.Info;
import org.eclipse.microprofile.openapi.models.info.License;
import org.eclipse.microprofile.openapi.models.links.Link;
import org.eclipse.microprofile.openapi.models.media.Content;
import org.eclipse.microprofile.openapi.models.media.Encoding;
import org.eclipse.microprofile.openapi.models.media.MediaType;
import org.eclipse.microprofile.openapi.models.media.Schema;
import org.eclipse.microprofile.openapi.models.parameters.Parameter;
import org.eclipse.microprofile.openapi.models.parameters.RequestBody;
import org.eclipse.microprofile.openapi.models.responses.APIResponse;
import org.eclipse.microprofile.openapi.models.responses.APIResponses;
import org.eclipse.microprofile.openapi.models.security.OAuthFlow;
import org.eclipse.microprofile.openapi.models.security.OAuthFlows;
import org.eclipse.microprofile.openapi.models.security.Scopes;
import org.eclipse.microprofile.openapi.models.security.SecurityRequirement;
import org.eclipse.microprofile.openapi.models.security.SecurityScheme;
import org.eclipse.microprofile.openapi.models.servers.Server;
import org.eclipse.microprofile.openapi.models.servers.ServerVariable;
import org.eclipse.microprofile.openapi.models.servers.ServerVariables;
import org.eclipse.microprofile.openapi.models.tags.Tag;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.MethodParameterInfo;
import org.jboss.jandex.Type;
import org.jboss.logging.Logger;

public class OpenApiAnnotationScanner {
    private static Logger LOG = Logger.getLogger(OpenApiAnnotationScanner.class);
    private static ObjectMapper MAPPER = new ObjectMapper();
    private final OpenApiConfig config;
    private final IndexView index;
    private OpenAPIImpl oai;
    private String currentAppPath = "";
    private String currentResourcePath = "";
    private String[] currentConsumes;
    private String[] currentProduces;
    private List<AnnotationScannerExtension> extensions;

    public OpenApiAnnotationScanner(OpenApiConfig config, IndexView index) {
        this(config, index, Collections.emptyList());
    }

    public OpenApiAnnotationScanner(OpenApiConfig config, IndexView index, List<AnnotationScannerExtension> extensions) {
        this.config = config;
        this.index = index;
        this.extensions = extensions;
    }

    public OpenAPIImpl scan() {
        Paths paths;
        LOG.debug((Object)"Scanning deployment for OpenAPI and JAX-RS Annotations.");
        this.oai = new OpenAPIImpl();
        this.oai.setOpenapi("3.0.1");
        SchemaRegistry schemaRegistry = SchemaRegistry.newInstance(this.config, this.oai, this.index);
        this.getCustomSchemaRegistry().registerCustomSchemas(schemaRegistry);
        Collection applications = this.index.getAllKnownSubclasses(DotName.createSimple((String)Application.class.getName()));
        for (ClassInfo classInfo : applications) {
            this.oai = MergeUtil.merge(this.oai, this.jaxRsApplicationToOpenApi(classInfo));
        }
        for (AnnotationScannerExtension annotationScannerExtension : this.extensions) {
            annotationScannerExtension.processJaxRsApplications(this, applications);
        }
        Collection<ClassInfo> resourceClasses = JandexUtil.getJaxRsResourceClasses(this.index);
        for (ClassInfo resourceClass : resourceClasses) {
            this.processJaxRsResourceClass(this.oai, resourceClass);
        }
        if (this.oai != null && (paths = this.oai.getPaths()) != null) {
            PathsImpl sortedPaths = new PathsImpl();
            TreeSet sortedKeys = new TreeSet(paths.keySet());
            for (String pathKey : sortedKeys) {
                PathItem pathItem = paths.getPathItem(pathKey);
                sortedPaths.addPathItem(pathKey, pathItem);
            }
            sortedPaths.setExtensions(paths.getExtensions());
            this.oai.setPaths(sortedPaths);
        }
        return this.oai;
    }

    private OpenAPIImpl jaxRsApplicationToOpenApi(ClassInfo applicationClass) {
        OpenAPIImpl oai = new OpenAPIImpl();
        oai.setOpenapi("3.0.1");
        AnnotationInstance appPathAnno = JandexUtil.getClassAnnotation(applicationClass, OpenApiConstants.DOTNAME_APPLICATION_PATH);
        if (appPathAnno == null) {
            appPathAnno = JandexUtil.getClassAnnotation(applicationClass, OpenApiConstants.DOTNAME_PATH);
        }
        this.currentAppPath = appPathAnno != null ? appPathAnno.value().asString() : "/";
        AnnotationInstance openApiDefAnno = JandexUtil.getClassAnnotation(applicationClass, OpenApiConstants.DOTNAME_OPEN_API_DEFINITION);
        if (openApiDefAnno != null) {
            this.processDefinition(oai, openApiDefAnno);
        }
        List<AnnotationInstance> securitySchemeAnnotations = JandexUtil.getRepeatableAnnotation(applicationClass, OpenApiConstants.DOTNAME_SECURITY_SCHEME, OpenApiConstants.DOTNAME_SECURITY_SCHEMES);
        for (AnnotationInstance annotation : securitySchemeAnnotations) {
            String name = JandexUtil.stringValue(annotation, "securitySchemeName");
            if (name == null && JandexUtil.isRef(annotation)) {
                name = JandexUtil.nameFromRef(annotation);
            }
            if (name == null) continue;
            SecurityScheme securityScheme = this.readSecurityScheme(annotation);
            Components components = ModelUtil.components(oai);
            components.addSecurityScheme(name, securityScheme);
        }
        List<AnnotationInstance> serverAnnotations = JandexUtil.getRepeatableAnnotation(applicationClass, OpenApiConstants.DOTNAME_SERVER, OpenApiConstants.DOTNAME_SERVERS);
        for (AnnotationInstance annotation : serverAnnotations) {
            Server server = this.readServer(annotation);
            oai.addServer(server);
        }
        return oai;
    }

    private void processJaxRsResourceClass(OpenAPIImpl openApi, ClassInfo resourceClass) {
        AnnotationInstance tagsAnno;
        LOG.debug((Object)("Processing a JAX-RS resource class: " + resourceClass.simpleName()));
        AnnotationInstance pathAnno = JandexUtil.getClassAnnotation(resourceClass, OpenApiConstants.DOTNAME_PATH);
        this.currentResourcePath = pathAnno.value().asString();
        List<AnnotationInstance> securitySchemeAnnotations = JandexUtil.getRepeatableAnnotation(resourceClass, OpenApiConstants.DOTNAME_SECURITY_SCHEME, OpenApiConstants.DOTNAME_SECURITY_SCHEMES);
        for (AnnotationInstance annotation : securitySchemeAnnotations) {
            String name = JandexUtil.stringValue(annotation, "securitySchemeName");
            if (name == null && JandexUtil.isRef(annotation)) {
                name = JandexUtil.nameFromRef(annotation);
            }
            if (name == null) continue;
            SecurityScheme securityScheme = this.readSecurityScheme(annotation);
            Components components = ModelUtil.components(openApi);
            components.addSecurityScheme(name, securityScheme);
        }
        HashSet<String> tagRefs = new HashSet<String>();
        AnnotationInstance tagAnno = JandexUtil.getClassAnnotation(resourceClass, OpenApiConstants.DOTNAME_TAG);
        if (tagAnno != null) {
            if (JandexUtil.isRef(tagAnno)) {
                String tagRef = JandexUtil.stringValue(tagAnno, "ref");
                tagRefs.add(tagRef);
            } else {
                Tag tag = this.readTag(tagAnno);
                if (tag.getName() != null) {
                    openApi.addTag(tag);
                    tagRefs.add(tag.getName());
                }
            }
        }
        if ((tagsAnno = JandexUtil.getClassAnnotation(resourceClass, OpenApiConstants.DOTNAME_TAGS)) != null) {
            List<String> listValue;
            AnnotationValue tagsArrayVal = tagsAnno.value();
            if (tagsArrayVal != null) {
                AnnotationInstance[] tagsArray;
                for (AnnotationInstance ta : tagsArray = tagsArrayVal.asNestedArray()) {
                    if (JandexUtil.isRef(ta)) {
                        String tagRef = JandexUtil.stringValue(ta, "ref");
                        tagRefs.add(tagRef);
                        continue;
                    }
                    Tag tag = this.readTag(ta);
                    if (tag.getName() == null) continue;
                    openApi.addTag(tag);
                    tagRefs.add(tag.getName());
                }
            }
            if ((listValue = JandexUtil.stringListValue(tagsAnno, "refs")) != null) {
                tagRefs.addAll(listValue);
            }
        }
        for (MethodInfo methodInfo : resourceClass.methods()) {
            AnnotationInstance patch;
            AnnotationInstance options;
            AnnotationInstance head;
            AnnotationInstance delete;
            AnnotationInstance post;
            AnnotationInstance put;
            AnnotationInstance get = methodInfo.annotation(OpenApiConstants.DOTNAME_GET);
            if (get != null) {
                this.processJaxRsMethod(openApi, resourceClass, methodInfo, get, PathItem.HttpMethod.GET, tagRefs);
            }
            if ((put = methodInfo.annotation(OpenApiConstants.DOTNAME_PUT)) != null) {
                this.processJaxRsMethod(openApi, resourceClass, methodInfo, put, PathItem.HttpMethod.PUT, tagRefs);
            }
            if ((post = methodInfo.annotation(OpenApiConstants.DOTNAME_POST)) != null) {
                this.processJaxRsMethod(openApi, resourceClass, methodInfo, post, PathItem.HttpMethod.POST, tagRefs);
            }
            if ((delete = methodInfo.annotation(OpenApiConstants.DOTNAME_DELETE)) != null) {
                this.processJaxRsMethod(openApi, resourceClass, methodInfo, delete, PathItem.HttpMethod.DELETE, tagRefs);
            }
            if ((head = methodInfo.annotation(OpenApiConstants.DOTNAME_HEAD)) != null) {
                this.processJaxRsMethod(openApi, resourceClass, methodInfo, head, PathItem.HttpMethod.HEAD, tagRefs);
            }
            if ((options = methodInfo.annotation(OpenApiConstants.DOTNAME_OPTIONS)) != null) {
                this.processJaxRsMethod(openApi, resourceClass, methodInfo, options, PathItem.HttpMethod.OPTIONS, tagRefs);
            }
            if ((patch = methodInfo.annotation(OpenApiConstants.DOTNAME_PATCH)) == null) continue;
            this.processJaxRsMethod(openApi, resourceClass, methodInfo, patch, PathItem.HttpMethod.PATCH, tagRefs);
        }
    }

    private void processJaxRsMethod(OpenAPIImpl openApi, ClassInfo resource, MethodInfo method, AnnotationInstance methodAnno, PathItem.HttpMethod methodType, Set<String> resourceTags) {
        Schema schema;
        Type requestBodyType;
        AnnotationValue annotationValue;
        AnnotationInstance producesAnno;
        String path;
        OperationImpl operation;
        LOG.debugf("Processing jax-rs method: {0}", (Object)method.toString());
        if (method.hasAnnotation(OpenApiConstants.DOTNAME_OPERATION)) {
            AnnotationInstance operationAnno = method.annotation(OpenApiConstants.DOTNAME_OPERATION);
            if (operationAnno.value("hidden") != null && operationAnno.value("hidden").asBoolean()) {
                return;
            }
            operation = new OperationImpl();
            operation.setSummary(JandexUtil.stringValue(operationAnno, "summary"));
            operation.setDescription(JandexUtil.stringValue(operationAnno, "description"));
            operation.setOperationId(JandexUtil.stringValue(operationAnno, "operationId"));
            operation.setDeprecated(JandexUtil.booleanValue(operationAnno, "deprecated"));
        } else {
            operation = new OperationImpl();
        }
        if (method.hasAnnotation(OpenApiConstants.DOTNAME_PATH)) {
            AnnotationInstance pathAnno = method.annotation(OpenApiConstants.DOTNAME_PATH);
            String methodPath = pathAnno.value().asString();
            path = OpenApiAnnotationScanner.makePath(this.currentAppPath, this.currentResourcePath, methodPath);
        } else {
            path = OpenApiAnnotationScanner.makePath(this.currentAppPath, this.currentResourcePath);
        }
        PathItem pathItem = ModelUtil.paths(openApi).getPathItem(path);
        if (pathItem == null) {
            pathItem = new PathItemImpl();
            ModelUtil.paths(openApi).addPathItem(path, pathItem);
        }
        this.currentConsumes = null;
        this.currentProduces = null;
        AnnotationInstance consumesAnno = method.annotation(OpenApiConstants.DOTNAME_CONSUMES);
        if (consumesAnno == null) {
            consumesAnno = JandexUtil.getClassAnnotation(method.declaringClass(), OpenApiConstants.DOTNAME_CONSUMES);
        }
        if ((producesAnno = method.annotation(OpenApiConstants.DOTNAME_PRODUCES)) == null) {
            producesAnno = JandexUtil.getClassAnnotation(method.declaringClass(), OpenApiConstants.DOTNAME_PRODUCES);
        }
        if (consumesAnno != null) {
            annotationValue = consumesAnno.value();
            this.currentConsumes = annotationValue != null ? annotationValue.asStringArray() : OpenApiConstants.DEFAULT_CONSUMES;
        }
        if (producesAnno != null) {
            annotationValue = producesAnno.value();
            this.currentProduces = annotationValue != null ? annotationValue.asStringArray() : OpenApiConstants.DEFAULT_PRODUCES;
        }
        boolean hasOpTags = false;
        HashSet<String> tags = new HashSet<String>();
        if (method.hasAnnotation(OpenApiConstants.DOTNAME_TAG)) {
            Tag tag;
            hasOpTags = true;
            AnnotationInstance tagAnno = method.annotation(OpenApiConstants.DOTNAME_TAG);
            if (JandexUtil.isRef(tagAnno)) {
                String tagRef = JandexUtil.stringValue(tagAnno, "ref");
                tags.add(tagRef);
            } else if (!JandexUtil.isEmpty(tagAnno) && (tag = this.readTag(tagAnno)).getName() != null) {
                openApi.addTag(tag);
                tags.add(tag.getName());
            }
        }
        if (method.hasAnnotation(OpenApiConstants.DOTNAME_TAGS)) {
            Object listValue;
            hasOpTags = true;
            AnnotationInstance tagsAnno = method.annotation(OpenApiConstants.DOTNAME_TAGS);
            AnnotationValue tagsArrayVal = tagsAnno.value();
            if (tagsArrayVal != null) {
                AnnotationInstance[] tagsArray;
                for (AnnotationInstance annotationInstance : tagsArray = tagsArrayVal.asNestedArray()) {
                    if (JandexUtil.isRef(annotationInstance)) {
                        String tagRef = JandexUtil.stringValue(annotationInstance, "ref");
                        tags.add(tagRef);
                        continue;
                    }
                    Tag tag = this.readTag(annotationInstance);
                    if (tag.getName() == null) continue;
                    openApi.addTag(tag);
                    tags.add(tag.getName());
                }
            }
            if ((listValue = JandexUtil.stringListValue(tagsAnno, "refs")) != null) {
                tags.addAll((Collection<String>)listValue);
            }
        }
        if (!hasOpTags) {
            tags.addAll(resourceTags);
        }
        if (!tags.isEmpty()) {
            operation.setTags(new ArrayList(tags));
        }
        List<AnnotationInstance> parameterAnnotations = JandexUtil.getRepeatableAnnotation(method, OpenApiConstants.DOTNAME_PARAMETER, OpenApiConstants.DOTNAME_PARAMETERS);
        HashMap<String, String> parameterNameOverrides = new HashMap<String, String>();
        for (AnnotationInstance annotation : parameterAnnotations) {
            Parameter parameter = this.readParameter(annotation);
            if (parameter == null) continue;
            AnnotationTarget target = annotation.target();
            if (target != null && target.kind() == AnnotationTarget.Kind.METHOD_PARAMETER) {
                MethodParameterInfo methodParameterInfo = target.asMethodParameter();
                JandexUtil.JaxRsParameterInfo jaxRsParamInfo = JandexUtil.getMethodParameterJaxRsInfo(method, methodParameterInfo.position());
                if (jaxRsParamInfo != null) {
                    parameter.setIn(jaxRsParamInfo.in);
                    if (parameter.getName() == null) {
                        parameter.setName(jaxRsParamInfo.name);
                    } else {
                        parameterNameOverrides.put(jaxRsParamInfo.name, parameter.getName());
                    }
                } else {
                    parameter.setIn(this.parameterIn(target.asMethodParameter()));
                }
                if (parameter.getIn() == Parameter.In.PATH) {
                    parameter.setRequired(Boolean.valueOf(true));
                }
                if (!ModelUtil.parameterHasSchema(parameter)) {
                    Type paramType = JandexUtil.getMethodParameterType(method, methodParameterInfo.position());
                    Schema schema2 = SchemaFactory.typeToSchema(this.index, paramType, this.extensions);
                    ModelUtil.setParameterSchema(parameter, schema2);
                }
            }
            operation.addParameter(parameter);
        }
        List parameters = method.parameters();
        for (int idx = 0; idx < parameters.size(); ++idx) {
            JandexUtil.JaxRsParameterInfo paramInfo = JandexUtil.getMethodParameterJaxRsInfo(method, idx);
            if (paramInfo == null) {
                AnnotationScannerExtension annotationScannerExtension;
                Iterator<AnnotationScannerExtension> target = this.extensions.iterator();
                while (target.hasNext() && (paramInfo = (annotationScannerExtension = target.next()).getMethodParameterJaxRsInfo(method, idx)) == null) {
                }
            }
            if (paramInfo == null || ModelUtil.operationHasParameter(operation, parameterNameOverrides.getOrDefault(paramInfo.name, paramInfo.name))) continue;
            Type paramType = (Type)parameters.get(idx);
            ParameterImpl parameterImpl = new ParameterImpl();
            parameterImpl.setName(paramInfo.name);
            parameterImpl.setIn(paramInfo.in);
            if (paramInfo.in == Parameter.In.PATH) {
                parameterImpl.setRequired(true);
            }
            Schema schema3 = SchemaFactory.typeToSchema(this.index, paramType, this.extensions);
            parameterImpl.setSchema(schema3);
            operation.addParameter(parameterImpl);
        }
        List<AnnotationInstance> requestBodyAnnotations = JandexUtil.getRepeatableAnnotation(method, OpenApiConstants.DOTNAME_REQUEST_BODY, null);
        for (AnnotationInstance annotation : requestBodyAnnotations) {
            RequestBody requestBody = this.readRequestBody(annotation);
            if (requestBody.getRef() == null && !ModelUtil.requestBodyHasSchema(requestBody)) {
                Type requestBodyType2 = null;
                if (annotation.target().kind() == AnnotationTarget.Kind.METHOD_PARAMETER) {
                    requestBodyType2 = JandexUtil.getMethodParameterType(method, annotation.target().asMethodParameter().position());
                } else if (annotation.target().kind() == AnnotationTarget.Kind.METHOD) {
                    requestBodyType2 = JandexUtil.getRequestBodyParameterClassType(method, this.extensions);
                }
                if (requestBodyType2 != null) {
                    Schema schema4 = SchemaFactory.typeToSchema(this.index, requestBodyType2, this.extensions);
                    ModelUtil.setRequestBodySchema(requestBody, schema4, this.currentConsumes);
                }
            }
            operation.setRequestBody(requestBody);
        }
        if (operation.getRequestBody() == null && this.currentConsumes != null && (requestBodyType = JandexUtil.getRequestBodyParameterClassType(method, this.extensions)) != null && (schema = SchemaFactory.typeToSchema(this.index, requestBodyType, this.extensions)) != null) {
            RequestBodyImpl requestBodyImpl = new RequestBodyImpl();
            ModelUtil.setRequestBodySchema(requestBodyImpl, schema, this.currentConsumes);
            operation.setRequestBody(requestBodyImpl);
        }
        List<AnnotationInstance> apiResponseAnnotations = JandexUtil.getRepeatableAnnotation(method, OpenApiConstants.DOTNAME_API_RESPONSE, OpenApiConstants.DOTNAME_API_RESPONSES);
        for (AnnotationInstance annotationInstance : apiResponseAnnotations) {
            String responseCode = JandexUtil.stringValue(annotationInstance, "responseCode");
            if (responseCode == null) {
                responseCode = "default";
            }
            APIResponse response = this.readResponse(annotationInstance);
            APIResponses aPIResponses = ModelUtil.responses(operation);
            aPIResponses.addAPIResponse(responseCode, response);
        }
        if (operation.getResponses() == null || operation.getResponses().isEmpty()) {
            this.createResponseFromJaxRsMethod(method, operation);
        }
        List<AnnotationInstance> securityRequirementAnnotations = JandexUtil.getRepeatableAnnotation(method, OpenApiConstants.DOTNAME_SECURITY_REQUIREMENT, OpenApiConstants.DOTNAME_SECURITY_REQUIREMENTS);
        securityRequirementAnnotations.addAll(JandexUtil.getRepeatableAnnotation(resource, OpenApiConstants.DOTNAME_SECURITY_REQUIREMENT, OpenApiConstants.DOTNAME_SECURITY_REQUIREMENTS));
        for (AnnotationInstance annotation : securityRequirementAnnotations) {
            SecurityRequirement requirement = this.readSecurityRequirement(annotation);
            if (requirement == null) continue;
            operation.addSecurityRequirement(requirement);
        }
        List<AnnotationInstance> list = JandexUtil.getRepeatableAnnotation(method, OpenApiConstants.DOTNAME_CALLBACK, OpenApiConstants.DOTNAME_CALLBACKS);
        LinkedHashMap<String, Callback> callbacks = new LinkedHashMap<String, Callback>();
        for (AnnotationInstance annotationInstance : list) {
            String name = JandexUtil.stringValue(annotationInstance, "name");
            if (name == null && JandexUtil.isRef(annotationInstance)) {
                name = JandexUtil.nameFromRef(annotationInstance);
            }
            if (name != null) {
                callbacks.put(name, this.readCallback(annotationInstance));
            }
            if (callbacks.isEmpty()) continue;
            operation.setCallbacks(callbacks);
        }
        List<AnnotationInstance> serverAnnotations = JandexUtil.getRepeatableAnnotation(method, OpenApiConstants.DOTNAME_SERVER, OpenApiConstants.DOTNAME_SERVERS);
        if (serverAnnotations.isEmpty()) {
            serverAnnotations.addAll(JandexUtil.getRepeatableAnnotation(method.declaringClass(), OpenApiConstants.DOTNAME_SERVER, OpenApiConstants.DOTNAME_SERVERS));
        }
        for (AnnotationInstance annotation : serverAnnotations) {
            Server server = this.readServer(annotation);
            operation.addServer(server);
        }
        List<AnnotationInstance> list2 = JandexUtil.getRepeatableAnnotation(method, OpenApiConstants.DOTNAME_EXTENSION, OpenApiConstants.DOTNAME_EXTENSIONS);
        if (list2.isEmpty()) {
            list2.addAll(JandexUtil.getRepeatableAnnotation(method.declaringClass(), OpenApiConstants.DOTNAME_EXTENSION, OpenApiConstants.DOTNAME_EXTENSIONS));
        }
        for (AnnotationInstance annotation : list2) {
            String name = JandexUtil.stringValue(annotation, "name");
            String value = JandexUtil.stringValue(annotation, "value");
            boolean parseValue = JandexUtil.booleanValueWithDefault(annotation, "parseValue");
            Object parsedValue = value;
            if (parseValue) {
                parsedValue = this.parseExtensionValue(value);
            }
            operation.addExtension(name, parsedValue);
        }
        switch (methodType) {
            case DELETE: {
                pathItem.setDELETE((Operation)operation);
                break;
            }
            case GET: {
                pathItem.setGET((Operation)operation);
                break;
            }
            case HEAD: {
                pathItem.setHEAD((Operation)operation);
                break;
            }
            case OPTIONS: {
                pathItem.setOPTIONS((Operation)operation);
                break;
            }
            case PATCH: {
                pathItem.setPATCH((Operation)operation);
                break;
            }
            case POST: {
                pathItem.setPOST((Operation)operation);
                break;
            }
            case PUT: {
                pathItem.setPUT((Operation)operation);
                break;
            }
            case TRACE: {
                pathItem.setTRACE((Operation)operation);
                break;
            }
        }
    }

    private void createResponseFromJaxRsMethod(MethodInfo method, Operation operation) {
        Type returnType = method.returnType();
        if (returnType.kind() == Type.Kind.VOID) {
            String code = "204";
            String description = "No Content";
            if (method.hasAnnotation(OpenApiConstants.DOTNAME_POST)) {
                code = "201";
                description = "Created";
            }
            APIResponses responses = ModelUtil.responses(operation);
            APIResponse response = new APIResponseImpl().description(description);
            responses.addAPIResponse(code, response);
        } else {
            Schema schema = SchemaFactory.typeToSchema(this.index, returnType, this.extensions);
            APIResponses responses = ModelUtil.responses(operation);
            APIResponse response = new APIResponseImpl().description("OK");
            ContentImpl content = new ContentImpl();
            String[] produces = this.currentProduces;
            if (produces == null || produces.length == 0) {
                produces = OpenApiConstants.DEFAULT_PRODUCES;
            }
            for (String producesType : produces) {
                MediaTypeImpl mt = new MediaTypeImpl();
                mt.setSchema(schema);
                content.addMediaType(producesType, mt);
            }
            response.setContent((Content)content);
            responses.addAPIResponse("200", response);
        }
    }

    private Parameter.In parameterIn(MethodParameterInfo paramInfo) {
        MethodInfo method = paramInfo.method();
        short paramPosition = paramInfo.position();
        List<AnnotationInstance> annotations = JandexUtil.getParameterAnnotations(method, paramPosition);
        for (AnnotationInstance annotation : annotations) {
            if (annotation.name().equals((Object)OpenApiConstants.DOTNAME_QUERY_PARAM)) {
                return Parameter.In.QUERY;
            }
            if (annotation.name().equals((Object)OpenApiConstants.DOTNAME_PATH_PARAM)) {
                return Parameter.In.PATH;
            }
            if (annotation.name().equals((Object)OpenApiConstants.DOTNAME_HEADER_PARAM)) {
                return Parameter.In.HEADER;
            }
            if (!annotation.name().equals((Object)OpenApiConstants.DOTNAME_COOKIE_PARAM)) continue;
            return Parameter.In.COOKIE;
        }
        for (AnnotationScannerExtension extension : this.extensions) {
            Parameter.In ret = extension.parameterIn(paramInfo);
            if (ret == null) continue;
            return ret;
        }
        return null;
    }

    protected static String makePath(String ... segments) {
        StringBuilder builder = new StringBuilder();
        for (String segment : segments) {
            if (segment.startsWith("/")) {
                segment = segment.substring(1);
            }
            if (segment.endsWith("/")) {
                segment = segment.substring(0, segment.length() - 1);
            }
            if (segment.isEmpty()) continue;
            builder.append("/");
            builder.append(segment);
        }
        String rval = builder.toString();
        if (rval.isEmpty()) {
            return "/";
        }
        return rval;
    }

    protected void processDefinition(OpenAPIImpl openApi, AnnotationInstance definitionAnno) {
        LOG.debug((Object)"Processing an @OpenAPIDefinition annotation.");
        openApi.setInfo(this.readInfo(definitionAnno.value("info")));
        openApi.setTags(this.readTags(definitionAnno.value("tags")));
        openApi.setServers(this.readServers(definitionAnno.value("servers")));
        openApi.setSecurity(this.readSecurity(definitionAnno.value("security")));
        openApi.setExternalDocs(this.readExternalDocs(definitionAnno.value("externalDocs")));
        openApi.setComponents(this.readComponents(definitionAnno.value("components")));
    }

    private Info readInfo(AnnotationValue infoAnno) {
        if (infoAnno == null) {
            return null;
        }
        LOG.debug((Object)"Processing an @Info annotation.");
        AnnotationInstance nested = infoAnno.asNested();
        InfoImpl info = new InfoImpl();
        info.setTitle(JandexUtil.stringValue(nested, "title"));
        info.setDescription(JandexUtil.stringValue(nested, "description"));
        info.setTermsOfService(JandexUtil.stringValue(nested, "termsOfService"));
        info.setContact(this.readContact(nested.value("contact")));
        info.setLicense(this.readLicense(nested.value("license")));
        info.setVersion(JandexUtil.stringValue(nested, "version"));
        return info;
    }

    private Contact readContact(AnnotationValue contactAnno) {
        if (contactAnno == null) {
            return null;
        }
        LOG.debug((Object)"Processing an @Contact annotation.");
        AnnotationInstance nested = contactAnno.asNested();
        ContactImpl contact = new ContactImpl();
        contact.setName(JandexUtil.stringValue(nested, "name"));
        contact.setUrl(JandexUtil.stringValue(nested, "url"));
        contact.setEmail(JandexUtil.stringValue(nested, "email"));
        return contact;
    }

    private License readLicense(AnnotationValue licenseAnno) {
        if (licenseAnno == null) {
            return null;
        }
        LOG.debug((Object)"Processing an @License annotation.");
        AnnotationInstance nested = licenseAnno.asNested();
        LicenseImpl license = new LicenseImpl();
        license.setName(JandexUtil.stringValue(nested, "name"));
        license.setUrl(JandexUtil.stringValue(nested, "url"));
        return license;
    }

    private List<Tag> readTags(AnnotationValue tagAnnos) {
        if (tagAnnos == null) {
            return null;
        }
        LOG.debug((Object)"Processing an array of @Tag annotations.");
        AnnotationInstance[] nestedArray = tagAnnos.asNestedArray();
        ArrayList<Tag> tags = new ArrayList<Tag>();
        for (AnnotationInstance tagAnno : nestedArray) {
            if (JandexUtil.isRef(tagAnno)) continue;
            tags.add(this.readTag(tagAnno));
        }
        return tags;
    }

    private Tag readTag(AnnotationInstance tagAnno) {
        if (tagAnno == null) {
            return null;
        }
        LOG.debug((Object)"Processing a single @Tag annotation.");
        TagImpl tag = new TagImpl();
        tag.setName(JandexUtil.stringValue(tagAnno, "name"));
        tag.setDescription(JandexUtil.stringValue(tagAnno, "description"));
        tag.setExternalDocs(this.readExternalDocs(tagAnno.value("externalDocs")));
        return tag;
    }

    private List<Server> readServers(AnnotationValue serverAnnos) {
        if (serverAnnos == null) {
            return null;
        }
        LOG.debug((Object)"Processing an array of @Server annotations.");
        AnnotationInstance[] nestedArray = serverAnnos.asNestedArray();
        ArrayList<Server> servers = new ArrayList<Server>();
        for (AnnotationInstance serverAnno : nestedArray) {
            servers.add(this.readServer(serverAnno));
        }
        return servers;
    }

    private Server readServer(AnnotationValue value) {
        if (value == null) {
            return null;
        }
        return this.readServer(value.asNested());
    }

    private Server readServer(AnnotationInstance serverAnno) {
        if (serverAnno == null) {
            return null;
        }
        LOG.debug((Object)"Processing a single @Server annotation.");
        ServerImpl server = new ServerImpl();
        server.setUrl(JandexUtil.stringValue(serverAnno, "url"));
        server.setDescription(JandexUtil.stringValue(serverAnno, "description"));
        server.setVariables(this.readServerVariables(serverAnno.value("variables")));
        return server;
    }

    private ServerVariables readServerVariables(AnnotationValue serverVariableAnnos) {
        if (serverVariableAnnos == null) {
            return null;
        }
        LOG.debug((Object)"Processing an array of @ServerVariable annotations.");
        AnnotationInstance[] nestedArray = serverVariableAnnos.asNestedArray();
        ServerVariablesImpl variables = new ServerVariablesImpl();
        for (AnnotationInstance serverVariableAnno : nestedArray) {
            String name = JandexUtil.stringValue(serverVariableAnno, "name");
            if (name == null) continue;
            variables.addServerVariable(name, this.readServerVariable(serverVariableAnno));
        }
        return variables;
    }

    private ServerVariable readServerVariable(AnnotationInstance serverVariableAnno) {
        if (serverVariableAnno == null) {
            return null;
        }
        LOG.debug((Object)"Processing a single @ServerVariable annotation.");
        ServerVariableImpl variable = new ServerVariableImpl();
        variable.setDescription(JandexUtil.stringValue(serverVariableAnno, "description"));
        variable.setEnumeration(JandexUtil.stringListValue(serverVariableAnno, "enumeration"));
        variable.setDefaultValue(JandexUtil.stringValue(serverVariableAnno, "defaultValue"));
        return variable;
    }

    private List<SecurityRequirement> readSecurity(AnnotationValue securityRequirementAnnos) {
        if (securityRequirementAnnos == null) {
            return null;
        }
        LOG.debug((Object)"Processing an array of @SecurityRequirement annotations.");
        AnnotationInstance[] nestedArray = securityRequirementAnnos.asNestedArray();
        ArrayList<SecurityRequirement> requirements = new ArrayList<SecurityRequirement>();
        for (AnnotationInstance requirementAnno : nestedArray) {
            SecurityRequirement requirement = this.readSecurityRequirement(requirementAnno);
            if (requirement == null) continue;
            requirements.add(requirement);
        }
        return requirements;
    }

    private SecurityRequirement readSecurityRequirement(AnnotationInstance annotation) {
        String name = JandexUtil.stringValue(annotation, "name");
        if (name != null) {
            List<String> scopes = JandexUtil.stringListValue(annotation, "scopes");
            SecurityRequirementImpl requirement = new SecurityRequirementImpl();
            if (scopes == null) {
                requirement.addScheme(name);
            } else {
                requirement.addScheme(name, scopes);
            }
            return requirement;
        }
        return null;
    }

    private ExternalDocumentation readExternalDocs(AnnotationValue externalDocAnno) {
        if (externalDocAnno == null) {
            return null;
        }
        LOG.debug((Object)"Processing an @ExternalDocumentation annotation.");
        AnnotationInstance nested = externalDocAnno.asNested();
        ExternalDocumentationImpl externalDoc = new ExternalDocumentationImpl();
        externalDoc.setDescription(JandexUtil.stringValue(nested, "description"));
        externalDoc.setUrl(JandexUtil.stringValue(nested, "url"));
        return externalDoc;
    }

    private Components readComponents(AnnotationValue componentsAnno) {
        if (componentsAnno == null) {
            return null;
        }
        LOG.debug((Object)"Processing an @Components annotation.");
        AnnotationInstance nested = componentsAnno.asNested();
        ComponentsImpl components = new ComponentsImpl();
        components.setCallbacks(this.readCallbacks(nested.value("callbacks")));
        components.setExamples(this.readExamples(nested.value("examples")));
        components.setHeaders(this.readHeaders(nested.value("headers")));
        components.setLinks(this.readLinks(nested.value("links")));
        components.setParameters(this.readParameters(nested.value("parameters")));
        components.setRequestBodies(this.readRequestBodies(nested.value("requestBodies")));
        components.setResponses(this.readResponses(nested.value("responses")));
        components.setSchemas(this.readSchemas(nested.value("schemas")));
        components.setSecuritySchemes(this.readSecuritySchemes(nested.value("securitySchemes")));
        return components;
    }

    private Map<String, Callback> readCallbacks(AnnotationValue value) {
        AnnotationInstance[] nestedArray;
        if (value == null) {
            return null;
        }
        LOG.debug((Object)"Processing a map of @Callback annotations.");
        LinkedHashMap<String, Callback> map = new LinkedHashMap<String, Callback>();
        for (AnnotationInstance nested : nestedArray = value.asNestedArray()) {
            String name = JandexUtil.stringValue(nested, "name");
            if (name == null && JandexUtil.isRef(nested)) {
                name = JandexUtil.nameFromRef(nested);
            }
            if (name == null) continue;
            map.put(name, this.readCallback(nested));
        }
        return map;
    }

    private Callback readCallback(AnnotationInstance annotation) {
        if (annotation == null) {
            return null;
        }
        LOG.debug((Object)"Processing a single @Callback annotation.");
        CallbackImpl callback = new CallbackImpl();
        callback.setRef(JandexUtil.refValue(annotation, JandexUtil.RefType.Callback));
        String expression = JandexUtil.stringValue(annotation, "callbackUrlExpression");
        callback.addPathItem(expression, this.readCallbackOperations(annotation.value("operations")));
        return callback;
    }

    private PathItem readCallbackOperations(AnnotationValue value) {
        if (value == null) {
            return null;
        }
        LOG.debug((Object)"Processing an array of @CallbackOperation annotations.");
        AnnotationInstance[] nestedArray = value.asNestedArray();
        PathItemImpl pathItem = new PathItemImpl();
        for (AnnotationInstance operationAnno : nestedArray) {
            String method = JandexUtil.stringValue(operationAnno, "method");
            Operation operation = this.readCallbackOperation(operationAnno);
            if (method == null) continue;
            try {
                PropertyDescriptor descriptor = new PropertyDescriptor(method.toUpperCase(), pathItem.getClass());
                Method mutator = PropertyUtils.getWriteMethod((PropertyDescriptor)descriptor);
                mutator.invoke((Object)pathItem, operation);
            }
            catch (Exception e) {
                LOG.error((Object)"Error reading a CallbackOperation annotation.", (Throwable)e);
            }
        }
        return pathItem;
    }

    private Operation readCallbackOperation(AnnotationInstance annotation) {
        if (annotation == null) {
            return null;
        }
        LOG.debug((Object)"Processing a single @CallbackOperation annotation.");
        OperationImpl operation = new OperationImpl();
        operation.setSummary(JandexUtil.stringValue(annotation, "summary"));
        operation.setDescription(JandexUtil.stringValue(annotation, "description"));
        operation.setExternalDocs(this.readExternalDocs(annotation.value("externalDocs")));
        operation.setParameters(this.readCallbackOperationParameters(annotation.value("parameters")));
        operation.setRequestBody(this.readRequestBody(annotation.value("requestBody")));
        operation.setResponses(this.readCallbackOperationResponses(annotation.value("responses")));
        operation.setSecurity(this.readSecurity(annotation.value("security")));
        operation.setExtensions(this.readExtensions(annotation.value("extensions")));
        return operation;
    }

    private List<Parameter> readCallbackOperationParameters(AnnotationValue value) {
        AnnotationInstance[] nestedArray;
        if (value == null) {
            return null;
        }
        LOG.debug((Object)"Processing a list of @Parameter annotations.");
        ArrayList<Parameter> parameters = new ArrayList<Parameter>();
        for (AnnotationInstance nested : nestedArray = value.asNestedArray()) {
            parameters.add(this.readParameter(nested));
        }
        return parameters;
    }

    private APIResponses readCallbackOperationResponses(AnnotationValue value) {
        AnnotationInstance[] nestedArray;
        if (value == null) {
            return null;
        }
        LOG.debug((Object)"Processing a list of @APIResponse annotations into an APIResponses model.");
        APIResponsesImpl responses = new APIResponsesImpl();
        for (AnnotationInstance nested : nestedArray = value.asNestedArray()) {
            String responseCode = JandexUtil.stringValue(nested, "responseCode");
            if (responseCode == null) continue;
            responses.addAPIResponse(responseCode, this.readResponse(nested));
        }
        return responses;
    }

    private Map<String, Example> readExamples(AnnotationValue value) {
        AnnotationInstance[] nestedArray;
        if (value == null) {
            return null;
        }
        LOG.debug((Object)"Processing a map of @ExampleObject annotations.");
        LinkedHashMap<String, Example> map = new LinkedHashMap<String, Example>();
        for (AnnotationInstance nested : nestedArray = value.asNestedArray()) {
            String name = JandexUtil.stringValue(nested, "name");
            if (name == null && JandexUtil.isRef(nested)) {
                name = JandexUtil.nameFromRef(nested);
            }
            if (name == null) continue;
            map.put(name, this.readExample(nested));
        }
        return map;
    }

    private Example readExample(AnnotationInstance annotation) {
        if (annotation == null) {
            return null;
        }
        LOG.debug((Object)"Processing a single @ExampleObject annotation.");
        ExampleImpl example = new ExampleImpl();
        example.setSummary(JandexUtil.stringValue(annotation, "summary"));
        example.setDescription(JandexUtil.stringValue(annotation, "description"));
        example.setValue(JandexUtil.stringValue(annotation, "value"));
        example.setExternalValue(JandexUtil.stringValue(annotation, "externalValue"));
        example.setRef(JandexUtil.refValue(annotation, JandexUtil.RefType.Example));
        return example;
    }

    private Map<String, Header> readHeaders(AnnotationValue value) {
        AnnotationInstance[] nestedArray;
        if (value == null) {
            return null;
        }
        LOG.debug((Object)"Processing a map of @Header annotations.");
        LinkedHashMap<String, Header> map = new LinkedHashMap<String, Header>();
        for (AnnotationInstance nested : nestedArray = value.asNestedArray()) {
            String name = JandexUtil.stringValue(nested, "name");
            if (name == null && JandexUtil.isRef(nested)) {
                name = JandexUtil.nameFromRef(nested);
            }
            if (name == null) continue;
            map.put(name, this.readHeader(nested));
        }
        return map;
    }

    private Header readHeader(AnnotationInstance annotation) {
        if (annotation == null) {
            return null;
        }
        LOG.debug((Object)"Processing a single @Header annotation.");
        HeaderImpl header = new HeaderImpl();
        header.setDescription(JandexUtil.stringValue(annotation, "description"));
        header.setSchema(SchemaFactory.readSchema(this.index, annotation.value("schema")));
        header.setRequired(JandexUtil.booleanValue(annotation, "required"));
        header.setDeprecated(JandexUtil.booleanValue(annotation, "deprecated"));
        header.setAllowEmptyValue(JandexUtil.booleanValue(annotation, "allowEmptyValue"));
        header.setRef(JandexUtil.refValue(annotation, JandexUtil.RefType.Header));
        return header;
    }

    private Map<String, Link> readLinks(AnnotationValue value) {
        AnnotationInstance[] nestedArray;
        if (value == null) {
            return null;
        }
        LOG.debug((Object)"Processing a map of @Link annotations.");
        LinkedHashMap<String, Link> map = new LinkedHashMap<String, Link>();
        for (AnnotationInstance nested : nestedArray = value.asNestedArray()) {
            String name = JandexUtil.stringValue(nested, "name");
            if (name == null && JandexUtil.isRef(nested)) {
                name = JandexUtil.nameFromRef(nested);
            }
            if (name == null) continue;
            map.put(name, this.readLink(nested));
        }
        return map;
    }

    private Link readLink(AnnotationInstance annotation) {
        if (annotation == null) {
            return null;
        }
        LOG.debug((Object)"Processing a single @Link annotation.");
        LinkImpl link = new LinkImpl();
        link.setOperationRef(JandexUtil.stringValue(annotation, "operationRef"));
        link.setOperationId(JandexUtil.stringValue(annotation, "operationId"));
        link.setParameters(this.readLinkParameters(annotation.value("parameters")));
        link.setDescription(JandexUtil.stringValue(annotation, "description"));
        link.setRequestBody(JandexUtil.stringValue(annotation, "requestBody"));
        link.setServer(this.readServer(annotation.value("server")));
        link.setRef(JandexUtil.refValue(annotation, JandexUtil.RefType.Link));
        return link;
    }

    private Map<String, Object> readLinkParameters(AnnotationValue value) {
        if (value == null) {
            return null;
        }
        AnnotationInstance[] nestedArray = value.asNestedArray();
        LinkedHashMap<String, Object> linkParams = new LinkedHashMap<String, Object>();
        for (AnnotationInstance annotation : nestedArray) {
            String name = JandexUtil.stringValue(annotation, "name");
            if (name == null) continue;
            String expression = JandexUtil.stringValue(annotation, "expression");
            linkParams.put(name, expression);
        }
        return linkParams;
    }

    private Map<String, Parameter> readParameters(AnnotationValue value) {
        AnnotationInstance[] nestedArray;
        if (value == null) {
            return null;
        }
        LOG.debug((Object)"Processing a map of @Parameter annotations.");
        LinkedHashMap<String, Parameter> map = new LinkedHashMap<String, Parameter>();
        for (AnnotationInstance nested : nestedArray = value.asNestedArray()) {
            Parameter parameter;
            String name = JandexUtil.stringValue(nested, "name");
            if (name == null && JandexUtil.isRef(nested)) {
                name = JandexUtil.nameFromRef(nested);
            }
            if (name == null || (parameter = this.readParameter(nested)) == null) continue;
            map.put(name, parameter);
        }
        return map;
    }

    private Parameter readParameter(AnnotationInstance annotation) {
        if (annotation == null) {
            return null;
        }
        LOG.debug((Object)"Processing a single @Link annotation.");
        Boolean isHidden = JandexUtil.booleanValue(annotation, "hidden");
        if (isHidden != null && isHidden == Boolean.TRUE) {
            return null;
        }
        ParameterImpl parameter = new ParameterImpl();
        parameter.setName(JandexUtil.stringValue(annotation, "name"));
        parameter.setIn(JandexUtil.enumValue(annotation, "in", Parameter.In.class));
        parameter.setDescription(JandexUtil.stringValue(annotation, "description"));
        parameter.setRequired(JandexUtil.booleanValue(annotation, "required"));
        parameter.setDeprecated(JandexUtil.booleanValue(annotation, "deprecated"));
        parameter.setAllowEmptyValue(JandexUtil.booleanValue(annotation, "allowEmptyValue"));
        parameter.setStyle(JandexUtil.enumValue(annotation, "style", Parameter.Style.class));
        parameter.setExplode(this.readExplode(JandexUtil.enumValue(annotation, "explode", Explode.class)));
        parameter.setAllowReserved(JandexUtil.booleanValue(annotation, "allowReserved"));
        parameter.setSchema(SchemaFactory.readSchema(this.index, annotation.value("schema")));
        parameter.setContent(this.readContent(annotation.value("content"), ContentDirection.Parameter));
        parameter.setExamples(this.readExamples(annotation.value("examples")));
        parameter.setExample(JandexUtil.stringValue(annotation, "example"));
        parameter.setRef(JandexUtil.refValue(annotation, JandexUtil.RefType.Parameter));
        return parameter;
    }

    private Boolean readExplode(Explode enumValue) {
        if (enumValue == Explode.TRUE) {
            return Boolean.TRUE;
        }
        if (enumValue == Explode.FALSE) {
            return Boolean.FALSE;
        }
        return null;
    }

    private Content readContent(AnnotationValue value, ContentDirection direction) {
        AnnotationInstance[] nestedArray;
        if (value == null) {
            return null;
        }
        LOG.debug((Object)"Processing a single @Content annotation.");
        ContentImpl content = new ContentImpl();
        for (AnnotationInstance nested : nestedArray = value.asNestedArray()) {
            String contentType = JandexUtil.stringValue(nested, "mediaType");
            MediaType mediaTypeModel = this.readMediaType(nested);
            if (contentType == null) {
                String[] mimeTypes = new String[]{};
                if (direction == ContentDirection.Input && this.currentConsumes != null) {
                    mimeTypes = this.currentConsumes;
                }
                if (direction == ContentDirection.Output && this.currentProduces != null) {
                    mimeTypes = this.currentProduces;
                }
                if (direction == ContentDirection.Parameter) {
                    mimeTypes = OpenApiConstants.DEFAULT_PARAMETER_MEDIA_TYPES;
                }
                for (String mimeType : mimeTypes) {
                    content.addMediaType(mimeType, mediaTypeModel);
                }
                continue;
            }
            content.addMediaType(contentType, mediaTypeModel);
        }
        return content;
    }

    private MediaType readMediaType(AnnotationInstance annotation) {
        if (annotation == null) {
            return null;
        }
        LOG.debug((Object)"Processing a single @Content annotation as a MediaType.");
        MediaTypeImpl mediaType = new MediaTypeImpl();
        mediaType.setExamples(this.readExamples(annotation.value("examples")));
        mediaType.setExample(JandexUtil.stringValue(annotation, "example"));
        mediaType.setSchema(SchemaFactory.readSchema(this.index, annotation.value("schema")));
        mediaType.setEncoding(this.readEncodings(annotation.value("encoding")));
        return mediaType;
    }

    private Map<String, Encoding> readEncodings(AnnotationValue value) {
        AnnotationInstance[] nestedArray;
        if (value == null) {
            return null;
        }
        LOG.debug((Object)"Processing a map of @Encoding annotations.");
        LinkedHashMap<String, Encoding> map = new LinkedHashMap<String, Encoding>();
        for (AnnotationInstance annotation : nestedArray = value.asNestedArray()) {
            String name = JandexUtil.stringValue(annotation, "name");
            if (name == null) continue;
            map.put(name, this.readEncoding(annotation));
        }
        return map;
    }

    private Encoding readEncoding(AnnotationInstance annotation) {
        if (annotation == null) {
            return null;
        }
        LOG.debug((Object)"Processing a single @Encoding annotation.");
        EncodingImpl encoding = new EncodingImpl();
        encoding.setContentType(JandexUtil.stringValue(annotation, "contentType"));
        encoding.setStyle(JandexUtil.enumValue(annotation, "style", Encoding.Style.class));
        encoding.setExplode(JandexUtil.booleanValue(annotation, "explode"));
        encoding.setAllowReserved(JandexUtil.booleanValue(annotation, "allowReserved"));
        encoding.setHeaders(this.readHeaders(annotation.value("headers")));
        return encoding;
    }

    private Map<String, RequestBody> readRequestBodies(AnnotationValue value) {
        AnnotationInstance[] nestedArray;
        if (value == null) {
            return null;
        }
        LOG.debug((Object)"Processing a map of @RequestBody annotations.");
        LinkedHashMap<String, RequestBody> map = new LinkedHashMap<String, RequestBody>();
        for (AnnotationInstance nested : nestedArray = value.asNestedArray()) {
            String name = JandexUtil.stringValue(nested, "name");
            if (name == null && JandexUtil.isRef(nested)) {
                name = JandexUtil.nameFromRef(nested);
            }
            if (name == null) continue;
            map.put(name, this.readRequestBody(nested));
        }
        return map;
    }

    private RequestBody readRequestBody(AnnotationValue value) {
        if (value == null) {
            return null;
        }
        return this.readRequestBody(value.asNested());
    }

    private RequestBody readRequestBody(AnnotationInstance annotation) {
        if (annotation == null) {
            return null;
        }
        LOG.debug((Object)"Processing a single @RequestBody annotation.");
        RequestBodyImpl requestBody = new RequestBodyImpl();
        requestBody.setDescription(JandexUtil.stringValue(annotation, "description"));
        requestBody.setContent(this.readContent(annotation.value("content"), ContentDirection.Input));
        requestBody.setRequired(JandexUtil.booleanValue(annotation, "required"));
        requestBody.setRef(JandexUtil.refValue(annotation, JandexUtil.RefType.RequestBody));
        return requestBody;
    }

    private Map<String, APIResponse> readResponses(AnnotationValue value) {
        AnnotationInstance[] nestedArray;
        if (value == null) {
            return null;
        }
        LOG.debug((Object)"Processing a map of @APIResponse annotations.");
        LinkedHashMap<String, APIResponse> map = new LinkedHashMap<String, APIResponse>();
        for (AnnotationInstance nested : nestedArray = value.asNestedArray()) {
            String name = JandexUtil.stringValue(nested, "name");
            if (name == null && JandexUtil.isRef(nested)) {
                name = JandexUtil.nameFromRef(nested);
            }
            if (name == null) continue;
            map.put(name, this.readResponse(nested));
        }
        return map;
    }

    private APIResponse readResponse(AnnotationInstance annotation) {
        if (annotation == null) {
            return null;
        }
        LOG.debug((Object)"Processing a single @Response annotation.");
        APIResponseImpl response = new APIResponseImpl();
        response.setDescription(JandexUtil.stringValue(annotation, "description"));
        response.setHeaders(this.readHeaders(annotation.value("headers")));
        response.setLinks(this.readLinks(annotation.value("links")));
        response.setContent(this.readContent(annotation.value("content"), ContentDirection.Output));
        response.setRef(JandexUtil.refValue(annotation, JandexUtil.RefType.Response));
        return response;
    }

    private Map<String, Schema> readSchemas(AnnotationValue value) {
        AnnotationInstance[] nestedArray;
        if (value == null) {
            return null;
        }
        LOG.debug((Object)"Processing a map of @Schema annotations.");
        LinkedHashMap<String, Schema> map = new LinkedHashMap<String, Schema>();
        for (AnnotationInstance nested : nestedArray = value.asNestedArray()) {
            String name = JandexUtil.stringValue(nested, "name");
            if (name == null && JandexUtil.isRef(nested)) {
                name = JandexUtil.nameFromRef(nested);
            }
            if (name == null) continue;
            map.put(name, SchemaFactory.readSchema(this.index, nested));
        }
        return map;
    }

    private Map<String, SecurityScheme> readSecuritySchemes(AnnotationValue value) {
        AnnotationInstance[] nestedArray;
        if (value == null) {
            return null;
        }
        LOG.debug((Object)"Processing a map of @SecurityScheme annotations.");
        LinkedHashMap<String, SecurityScheme> map = new LinkedHashMap<String, SecurityScheme>();
        for (AnnotationInstance nested : nestedArray = value.asNestedArray()) {
            String name = JandexUtil.stringValue(nested, "securitySchemeName");
            if (name == null && JandexUtil.isRef(nested)) {
                name = JandexUtil.nameFromRef(nested);
            }
            if (name == null) continue;
            map.put(name, this.readSecurityScheme(nested));
        }
        return map;
    }

    private SecurityScheme readSecurityScheme(AnnotationInstance annotation) {
        if (annotation == null) {
            return null;
        }
        LOG.debug((Object)"Processing a single @SecurityScheme annotation.");
        SecuritySchemeImpl securityScheme = new SecuritySchemeImpl();
        securityScheme.setType(JandexUtil.enumValue(annotation, "type", SecurityScheme.Type.class));
        securityScheme.setDescription(JandexUtil.stringValue(annotation, "description"));
        securityScheme.setName(JandexUtil.stringValue(annotation, "apiKeyName"));
        securityScheme.setIn(JandexUtil.enumValue(annotation, "in", SecurityScheme.In.class));
        securityScheme.setScheme(JandexUtil.stringValue(annotation, "scheme"));
        securityScheme.setBearerFormat(JandexUtil.stringValue(annotation, "bearerFormat"));
        securityScheme.setFlows(this.readOAuthFlows(annotation.value("flows")));
        securityScheme.setOpenIdConnectUrl(JandexUtil.stringValue(annotation, "openIdConnectUrl"));
        securityScheme.setRef(JandexUtil.refValue(annotation, JandexUtil.RefType.SecurityScheme));
        return securityScheme;
    }

    private OAuthFlows readOAuthFlows(AnnotationValue value) {
        if (value == null) {
            return null;
        }
        LOG.debug((Object)"Processing a single @OAuthFlows annotation.");
        AnnotationInstance annotation = value.asNested();
        OAuthFlowsImpl flows = new OAuthFlowsImpl();
        flows.setImplicit(this.readOAuthFlow(annotation.value("implicit")));
        flows.setPassword(this.readOAuthFlow(annotation.value("password")));
        flows.setClientCredentials(this.readOAuthFlow(annotation.value("clientCredentials")));
        flows.setAuthorizationCode(this.readOAuthFlow(annotation.value("authorizationCode")));
        return flows;
    }

    private OAuthFlow readOAuthFlow(AnnotationValue value) {
        if (value == null) {
            return null;
        }
        LOG.debug((Object)"Processing a single @OAuthFlow annotation.");
        AnnotationInstance annotation = value.asNested();
        OAuthFlowImpl flow = new OAuthFlowImpl();
        flow.setAuthorizationUrl(JandexUtil.stringValue(annotation, "authorizationUrl"));
        flow.setTokenUrl(JandexUtil.stringValue(annotation, "tokenUrl"));
        flow.setRefreshUrl(JandexUtil.stringValue(annotation, "refreshUrl"));
        flow.setScopes(this.readOAuthScopes(annotation.value("scopes")));
        return flow;
    }

    private Scopes readOAuthScopes(AnnotationValue value) {
        if (value == null) {
            return null;
        }
        LOG.debug((Object)"Processing a list of @OAuthScope annotations.");
        AnnotationInstance[] nestedArray = value.asNestedArray();
        ScopesImpl scopes = new ScopesImpl();
        for (AnnotationInstance nested : nestedArray) {
            String name = JandexUtil.stringValue(nested, "name");
            if (name == null) continue;
            String description = JandexUtil.stringValue(nested, "description");
            scopes.addScope(name, description);
        }
        return scopes;
    }

    private Map<String, Object> readExtensions(AnnotationValue value) {
        AnnotationInstance[] nestedArray;
        if (value == null) {
            return null;
        }
        LinkedHashMap<String, Object> extensions = new LinkedHashMap<String, Object>();
        for (AnnotationInstance annotation : nestedArray = value.asNestedArray()) {
            String extName = JandexUtil.stringValue(annotation, "name");
            String extValue = JandexUtil.stringValue(annotation, "value");
            extensions.put(extName, extValue);
        }
        return extensions;
    }

    private Object parseExtensionValue(String value) {
        if (value == null) {
            return null;
        }
        if ("true".equals(value)) {
            return Boolean.TRUE;
        }
        if ("false".equals(value)) {
            return Boolean.FALSE;
        }
        if (value.trim().startsWith("{")) {
            try {
                return MAPPER.readTree(value.trim());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (value.trim().startsWith("[")) {
            try {
                return MAPPER.readTree(value.trim());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (Character.isDigit(value.charAt(0)) || value.charAt(0) == '-' || value.charAt(0) == '+') {
            try {
                return Integer.parseInt(value);
            }
            catch (Exception exception) {
                try {
                    return Float.valueOf(Float.parseFloat(value));
                }
                catch (Exception exception2) {
                    try {
                        return Double.parseDouble(value);
                    }
                    catch (Exception exception3) {
                        // empty catch block
                    }
                }
            }
        }
        return value;
    }

    private CustomSchemaRegistry getCustomSchemaRegistry() {
        if (this.config == null || this.config.customSchemaRegistryClass() == null) {
            return type -> {};
        }
        try {
            return (CustomSchemaRegistry)Class.forName(this.config.customSchemaRegistryClass(), true, OpenApiAnnotationScanner.getContextClassLoader()).newInstance();
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException ex) {
            throw new RuntimeException("Failed to create instance of custom schema registry: " + this.config.customSchemaRegistryClass(), ex);
        }
    }

    private static ClassLoader getContextClassLoader() {
        if (System.getSecurityManager() == null) {
            return Thread.currentThread().getContextClassLoader();
        }
        return AccessController.doPrivileged(() -> Thread.currentThread().getContextClassLoader());
    }

    public void setCurrentAppPath(String path) {
        this.currentAppPath = path;
    }

    private static enum ContentDirection {
        Input,
        Output,
        Parameter;

    }
}

