/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.graphql.entry.http;

import graphql.schema.GraphQLSchema;
import io.smallrye.graphql.cdi.producer.GraphQLProducer;
import io.smallrye.graphql.entry.http.IndexInitializer;
import io.smallrye.graphql.entry.http.SmallRyeGraphQLServletLogging;
import io.smallrye.graphql.schema.SchemaBuilder;
import io.smallrye.graphql.schema.model.Schema;
import jakarta.inject.Inject;
import jakarta.servlet.ServletContextEvent;
import jakarta.servlet.ServletContextListener;
import jakarta.servlet.annotation.WebListener;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jboss.jandex.IndexView;

@WebListener
public class StartupListener
implements ServletContextListener {
    @Inject
    private GraphQLProducer graphQLProducer;
    private final IndexInitializer indexInitializer = new IndexInitializer();

    public void contextInitialized(ServletContextEvent sce) {
        try {
            HashSet<URL> warURLs = new HashSet<URL>();
            String warClasses = sce.getServletContext().getRealPath("WEB-INF/classes");
            warURLs.add(Paths.get(warClasses, new String[0]).toUri().toURL());
            String libs = sce.getServletContext().getRealPath("WEB-INF/lib");
            List<Path> jarsInLib = this.getJarsInLib(Paths.get(libs, new String[0]));
            warURLs.addAll(this.toURLs(jarsInLib));
            IndexView index = this.indexInitializer.createIndex(warURLs);
            Schema schema = SchemaBuilder.build((IndexView)index);
            GraphQLSchema graphQLSchema = this.graphQLProducer.initialize(schema, true);
            sce.getServletContext().setAttribute("io.smallrye.graphql.servlet.bootstrap", (Object)graphQLSchema);
            SmallRyeGraphQLServletLogging.log.initialized();
        }
        catch (MalformedURLException ex) {
            throw new RuntimeException(ex);
        }
    }

    public void contextDestroyed(ServletContextEvent sce) {
        SmallRyeGraphQLServletLogging.log.destroyed();
    }

    private List<URL> toURLs(List<Path> paths) throws MalformedURLException {
        ArrayList<URL> urls = new ArrayList<URL>();
        for (Path path : paths) {
            urls.add(path.toUri().toURL());
        }
        return urls;
    }

    private List<Path> getJarsInLib(Path libFolder) {
        ArrayList<Path> jars = new ArrayList<Path>();
        if (libFolder != null && Files.isDirectory(libFolder, new LinkOption[0])) {
            try (Stream<Path> libFolderStream = Files.walk(libFolder, new FileVisitOption[0]);){
                jars.addAll(libFolderStream.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).collect(Collectors.toList()));
            }
            catch (IOException ex) {
                SmallRyeGraphQLServletLogging.log.ioException(ex);
            }
        }
        return jars;
    }
}

