/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.graphql.entry.http;

import io.smallrye.graphql.api.Deprecated;
import io.smallrye.graphql.api.Entry;
import io.smallrye.graphql.api.OneOf;
import io.smallrye.graphql.api.federation.Authenticated;
import io.smallrye.graphql.api.federation.ComposeDirective;
import io.smallrye.graphql.api.federation.Extends;
import io.smallrye.graphql.api.federation.External;
import io.smallrye.graphql.api.federation.FieldSet;
import io.smallrye.graphql.api.federation.Inaccessible;
import io.smallrye.graphql.api.federation.InterfaceObject;
import io.smallrye.graphql.api.federation.Key;
import io.smallrye.graphql.api.federation.Override;
import io.smallrye.graphql.api.federation.Provides;
import io.smallrye.graphql.api.federation.Requires;
import io.smallrye.graphql.api.federation.Shareable;
import io.smallrye.graphql.api.federation.Tag;
import io.smallrye.graphql.api.federation.link.Import;
import io.smallrye.graphql.api.federation.link.Link;
import io.smallrye.graphql.api.federation.link.Purpose;
import io.smallrye.graphql.api.federation.policy.Policy;
import io.smallrye.graphql.api.federation.policy.PolicyGroup;
import io.smallrye.graphql.api.federation.policy.PolicyItem;
import io.smallrye.graphql.api.federation.requiresscopes.RequiresScopes;
import io.smallrye.graphql.api.federation.requiresscopes.ScopeGroup;
import io.smallrye.graphql.api.federation.requiresscopes.ScopeItem;
import io.smallrye.graphql.entry.http.SmallRyeGraphQLServletLogging;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Repeatable;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.jboss.jandex.CompositeIndex;
import org.jboss.jandex.Index;
import org.jboss.jandex.IndexReader;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.Indexer;

public class IndexInitializer {
    private static final String DOT_JAR = ".jar";
    private static final String DOT_WAR = ".war";
    private static final String DOT_CLASS = ".class";
    private static final String JAVA_CLASS_PATH = "java.class.path";
    private static final String PATH_SEPARATOR = "path.separator";
    private static final String JANDEX_IDX = "META-INF/jandex.idx";

    public IndexView createIndex(Set<URL> urls) {
        ArrayList<IndexView> indexes = new ArrayList<IndexView>();
        try (InputStream stream = this.getClass().getClassLoader().getResourceAsStream(JANDEX_IDX);){
            IndexReader reader = new IndexReader(stream);
            Index i = reader.read();
            SmallRyeGraphQLServletLogging.log.loadedIndexFrom(JANDEX_IDX);
            indexes.add((IndexView)i);
        }
        catch (IOException ex) {
            SmallRyeGraphQLServletLogging.log.generatingIndex();
        }
        IndexView artifact = this.createIndexView(urls);
        indexes.add(artifact);
        IndexView custom = this.createCustomIndex();
        indexes.add(custom);
        return this.merge(indexes);
    }

    public IndexView createIndex() {
        Set<URL> urls = this.getUrlFromClassPath();
        return this.createIndexView(urls);
    }

    private IndexView createCustomIndex() {
        Indexer indexer = new Indexer();
        try {
            indexer.index(this.convertClassToInputStream(Map.class));
            indexer.index(this.convertClassToInputStream(Entry.class));
            indexer.index(this.convertClassToInputStream(Repeatable.class));
            indexer.index(this.convertClassToInputStream(Authenticated.class));
            indexer.index(this.convertClassToInputStream(ComposeDirective.class));
            indexer.index(this.convertClassToInputStream(Deprecated.class));
            indexer.index(this.convertClassToInputStream(java.lang.Deprecated.class));
            indexer.index(this.convertClassToInputStream(Extends.class));
            indexer.index(this.convertClassToInputStream(External.class));
            indexer.index(this.convertClassToInputStream(FieldSet.class));
            indexer.index(this.convertClassToInputStream(Import.class));
            indexer.index(this.convertClassToInputStream(Inaccessible.class));
            indexer.index(this.convertClassToInputStream(InterfaceObject.class));
            indexer.index(this.convertClassToInputStream(Key.class));
            indexer.index(this.convertClassToInputStream(Link.class));
            indexer.index(this.convertClassToInputStream(OneOf.class));
            indexer.index(this.convertClassToInputStream(Override.class));
            indexer.index(this.convertClassToInputStream(Policy.class));
            indexer.index(this.convertClassToInputStream(PolicyGroup.class));
            indexer.index(this.convertClassToInputStream(PolicyItem.class));
            indexer.index(this.convertClassToInputStream(Provides.class));
            indexer.index(this.convertClassToInputStream(Purpose.class));
            indexer.index(this.convertClassToInputStream(Requires.class));
            indexer.index(this.convertClassToInputStream(RequiresScopes.class));
            indexer.index(this.convertClassToInputStream(ScopeGroup.class));
            indexer.index(this.convertClassToInputStream(ScopeItem.class));
            indexer.index(this.convertClassToInputStream(Shareable.class));
            indexer.index(this.convertClassToInputStream(Tag.class));
            indexer.index(this.convertClassToInputStream(OneOf.class));
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        return indexer.complete();
    }

    private InputStream convertClassToInputStream(Class<?> clazz) {
        String resourceName = "/" + clazz.getName().replace('.', '/') + DOT_CLASS;
        return clazz.getResourceAsStream(resourceName);
    }

    private IndexView createIndexView(Set<URL> urls) {
        Indexer indexer = new Indexer();
        for (URL url : urls) {
            try {
                if (url.toString().endsWith(DOT_JAR) || url.toString().endsWith(DOT_WAR)) {
                    SmallRyeGraphQLServletLogging.log.processingFile(url.toString());
                    this.processJar(url.openStream(), indexer);
                    continue;
                }
                this.processFolder(url, indexer);
            }
            catch (IOException ex) {
                SmallRyeGraphQLServletLogging.log.cannotProcessFile(url.toString(), ex);
            }
        }
        return indexer.complete();
    }

    private Set<URL> collectURLsFromClassPath() {
        HashSet<URL> urls = new HashSet<URL>();
        for (String s : System.getProperty(JAVA_CLASS_PATH).split(System.getProperty(PATH_SEPARATOR))) {
            try {
                urls.add(Paths.get(s, new String[0]).toUri().toURL());
            }
            catch (MalformedURLException e) {
                SmallRyeGraphQLServletLogging.log.cannotCreateUrl(e);
            }
        }
        return urls;
    }

    private void processFolder(URL url, Indexer indexer) throws IOException {
        block10: {
            try {
                Path folderPath = Paths.get(url.toURI());
                if (Files.isDirectory(folderPath, new LinkOption[0])) {
                    try (Stream<Path> walk = Files.walk(folderPath, new FileVisitOption[0]);){
                        List collected = walk.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).collect(Collectors.toList());
                        for (Path c : collected) {
                            String entryName = c.getFileName().toString();
                            this.processFile(entryName, Files.newInputStream(c, new OpenOption[0]), indexer);
                        }
                        break block10;
                    }
                }
                SmallRyeGraphQLServletLogging.log.ignoringUrl(url);
            }
            catch (URISyntaxException ex) {
                SmallRyeGraphQLServletLogging.log.couldNotProcessUrl(url, ex);
            }
        }
    }

    private void processJar(InputStream inputStream, Indexer indexer) throws IOException {
        ZipEntry ze;
        ZipInputStream zis = new ZipInputStream(inputStream, StandardCharsets.UTF_8);
        while ((ze = zis.getNextEntry()) != null) {
            String entryName = ze.getName();
            this.processFile(entryName, zis, indexer);
        }
    }

    private void processFile(String fileName, InputStream is, Indexer indexer) throws IOException {
        if (fileName.endsWith(DOT_CLASS)) {
            SmallRyeGraphQLServletLogging.log.processingFile(fileName);
            indexer.index(is);
        } else if (fileName.endsWith(DOT_WAR) || fileName.endsWith(DOT_JAR)) {
            this.processJar(is, indexer);
        }
    }

    private IndexView merge(Collection<IndexView> indexes) {
        return CompositeIndex.create(indexes);
    }

    private Set<URL> getUrlFromClassPath() {
        HashSet<URL> urls = new HashSet<URL>();
        ClassLoader cl = ClassLoader.getSystemClassLoader();
        if (cl instanceof URLClassLoader) {
            urls.addAll(Arrays.asList(((URLClassLoader)cl).getURLs()));
        } else {
            urls.addAll(this.collectURLsFromClassPath());
        }
        return urls;
    }
}

