/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.graphql.entry.http;

import io.smallrye.graphql.execution.ExecutionResponse;
import io.smallrye.graphql.execution.ExecutionResponseWriter;
import jakarta.json.Json;
import jakarta.json.JsonWriter;
import jakarta.json.JsonWriterFactory;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.OutputStream;

public class HttpServletResponseWriter
implements ExecutionResponseWriter {
    private static final String APPLICATION_JSON_UTF8 = "application/json;charset=UTF-8";
    private static final JsonWriterFactory jsonWriterFactory = Json.createWriterFactory(null);
    private final HttpServletResponse response;

    public HttpServletResponseWriter(HttpServletResponse response) {
        this.response = response;
    }

    public void write(ExecutionResponse executionResponse) {
        if (executionResponse != null) {
            try (JsonWriter jsonWriter = jsonWriterFactory.createWriter((OutputStream)this.response.getOutputStream());){
                this.response.setContentType(APPLICATION_JSON_UTF8);
                jsonWriter.writeObject(executionResponse.getExecutionResultAsJsonObject());
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        }
    }
}

