/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.graphql.entry.http;

import graphql.schema.GraphQLSchema;
import io.smallrye.graphql.entry.http.SmallRyeGraphQLServletLogging;
import io.smallrye.graphql.execution.SchemaPrinter;
import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

@WebServlet(name="SmallRyeGraphQLSchemaServlet", urlPatterns={"/graphql/schema.graphql"}, loadOnStartup=2)
public class SchemaServlet
extends HttpServlet {
    public static final String SCHEMA_PROP = "io.smallrye.graphql.servlet.bootstrap";
    private final SchemaPrinter schemaPrinter = new SchemaPrinter();
    private static final String CONTENT_TYPE = "text/plain";

    protected void doGet(HttpServletRequest request, HttpServletResponse response) {
        response.setContentType(CONTENT_TYPE);
        try (PrintWriter out = response.getWriter();){
            GraphQLSchema schema = (GraphQLSchema)request.getServletContext().getAttribute(SCHEMA_PROP);
            out.print(this.schemaPrinter.print(schema));
            out.flush();
        }
        catch (IOException ex) {
            SmallRyeGraphQLServletLogging.log.ioException(ex);
        }
    }
}

