/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.graphql.entry.http;

import io.smallrye.graphql.entry.http.HttpServletResponseWriter;
import io.smallrye.graphql.entry.http.SmallRyeGraphQLServletLogging;
import io.smallrye.graphql.execution.ExecutionResponseWriter;
import io.smallrye.graphql.execution.ExecutionService;
import io.smallrye.graphql.spi.config.Config;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.json.Json;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonReader;
import javax.json.JsonReaderFactory;
import javax.json.JsonValue;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

@WebServlet(name="SmallRyeGraphQLExecutionServlet", urlPatterns={"/graphql/*"}, loadOnStartup=1)
public class ExecutionServlet
extends HttpServlet {
    private static final long serialVersionUID = -2859915918802356120L;
    private static final JsonReaderFactory jsonReaderFactory = Json.createReaderFactory(null);
    @Inject
    ExecutionService executionService;
    private Config config = Config.get();
    private static final String QUERY = "query";
    private static final String OPERATION_NAME = "operationName";
    private static final String VARIABLES = "variables";
    private static final String EXTENSIONS = "extensions";
    private static final String APPLICATION_GRAPHQL = "application/graphql";

    public ExecutionServlet() {
    }

    public ExecutionServlet(ExecutionService executionService) {
        this.executionService = executionService;
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException {
        try {
            if (this.config.isAllowGet()) {
                JsonObject jsonObject = this.getJsonObjectFromQueryParameters(request);
                this.executionService.executeSync(jsonObject, (ExecutionResponseWriter)new HttpServletResponseWriter(response));
            } else {
                response.sendError(405, "GET Queries is not enabled");
            }
        }
        catch (IOException ex) {
            SmallRyeGraphQLServletLogging.log.ioException(ex);
            throw ex;
        }
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException {
        try {
            JsonObject jsonObjectFromBody = this.getJsonObjectFromBody(request);
            if (request.getQueryString() != null && !request.getQueryString().isEmpty() && this.config.isAllowPostWithQueryParameters()) {
                JsonObject jsonObjectFromQueryParameters = this.getJsonObjectFromQueryParameters(request);
                JsonObject mergedJsonObject = Json.createMergePatch((JsonValue)jsonObjectFromQueryParameters).apply((JsonValue)jsonObjectFromBody).asJsonObject();
                this.executionService.executeSync(mergedJsonObject, (ExecutionResponseWriter)new HttpServletResponseWriter(response));
            } else {
                this.executionService.executeSync(jsonObjectFromBody, (ExecutionResponseWriter)new HttpServletResponseWriter(response));
            }
        }
        catch (IOException ex) {
            SmallRyeGraphQLServletLogging.log.ioException(ex);
            throw ex;
        }
    }

    private JsonObject getJsonObjectFromQueryParameters(HttpServletRequest request) throws UnsupportedEncodingException {
        String extensions;
        String variables;
        String operationName;
        JsonObjectBuilder input = Json.createObjectBuilder();
        String query = request.getParameter(QUERY);
        if (query != null && !query.isEmpty()) {
            input.add(QUERY, URLDecoder.decode(query, "UTF8"));
        }
        if ((operationName = request.getParameter(OPERATION_NAME)) != null && !operationName.isEmpty()) {
            input.add(OPERATION_NAME, URLDecoder.decode(query, "UTF8"));
        }
        if ((variables = request.getParameter(VARIABLES)) != null && !variables.isEmpty()) {
            JsonObject jsonObject = ExecutionServlet.toJsonObject(URLDecoder.decode(variables, "UTF8"));
            input.add(VARIABLES, (JsonValue)jsonObject);
        }
        if ((extensions = request.getParameter(EXTENSIONS)) != null && !extensions.isEmpty()) {
            JsonObject jsonObject = ExecutionServlet.toJsonObject(URLDecoder.decode(extensions, "UTF8"));
            input.add(EXTENSIONS, (JsonValue)jsonObject);
        }
        return input.build();
    }

    private JsonObject getJsonObjectFromBody(HttpServletRequest request) throws IOException {
        String contentType = request.getContentType();
        try (BufferedReader bufferedReader = request.getReader();){
            JsonObject jsonObject;
            block14: {
                if (contentType != null && contentType.startsWith(APPLICATION_GRAPHQL)) {
                    String query = bufferedReader.lines().collect(Collectors.joining("\n"));
                    JsonObjectBuilder input = Json.createObjectBuilder();
                    input.add(QUERY, query);
                    JsonObject jsonObject2 = input.build();
                    return jsonObject2;
                }
                JsonReader jsonReader = jsonReaderFactory.createReader((Reader)bufferedReader);
                try {
                    jsonObject = jsonReader.readObject();
                    if (jsonReader == null) break block14;
                }
                catch (Throwable throwable) {
                    if (jsonReader != null) {
                        try {
                            jsonReader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                jsonReader.close();
            }
            return jsonObject;
        }
    }

    private static JsonObject toJsonObject(String jsonString) {
        if (jsonString == null || jsonString.isEmpty()) {
            return null;
        }
        try (JsonReader jsonReader = Json.createReader((Reader)new StringReader(jsonString));){
            JsonObject jsonObject = jsonReader.readObject();
            return jsonObject;
        }
    }
}

