/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.graphql.entry.http;

import io.smallrye.graphql.execution.ExecutionService;
import io.smallrye.graphql.websocket.GraphQLWebSocketSession;
import io.smallrye.graphql.websocket.GraphQLWebsocketHandler;
import io.smallrye.graphql.websocket.graphqltransportws.GraphQLTransportWSSubprotocolHandler;
import io.smallrye.graphql.websocket.graphqlws.GraphQLWSSubprotocolHandler;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.inject.Inject;
import javax.websocket.CloseReason;
import javax.websocket.OnClose;
import javax.websocket.OnError;
import javax.websocket.OnMessage;
import javax.websocket.OnOpen;
import javax.websocket.Session;
import javax.websocket.server.ServerEndpoint;
import org.jboss.logging.Logger;

@ServerEndpoint(value="/graphql", subprotocols={"graphql-transport-ws", "graphql-ws"})
public class GraphQLServerWebSocket {
    private final Logger log = Logger.getLogger((String)GraphQLServerWebSocket.class.getName());
    private Map<Session, GraphQLWebsocketHandler> sessionsToHandlers = new ConcurrentHashMap<Session, GraphQLWebsocketHandler>();
    @Inject
    ExecutionService executionService;

    @OnOpen
    public void onOpen(Session session) {
        String subprotocol;
        GraphQLTransportWSSubprotocolHandler handler = null;
        switch (subprotocol = session.getNegotiatedSubprotocol()) {
            case "graphql-transport-ws": {
                handler = new GraphQLTransportWSSubprotocolHandler((GraphQLWebSocketSession)new SmallRyeWebSocketSession(session), this.executionService);
                break;
            }
            case "graphql-ws": {
                handler = new GraphQLWSSubprotocolHandler((GraphQLWebSocketSession)new SmallRyeWebSocketSession(session), this.executionService);
                break;
            }
            default: {
                this.log.warn((Object)("Unknown subprotocol: " + subprotocol));
                try {
                    session.close(new CloseReason((CloseReason.CloseCode)CloseReason.CloseCodes.PROTOCOL_ERROR, "Unknown subprotocol: " + subprotocol));
                }
                catch (IOException e) {
                    this.log.warn((Object)e);
                }
                return;
            }
        }
        this.sessionsToHandlers.put(session, (GraphQLWebsocketHandler)handler);
        this.log.debug((Object)("Opened graphql-over-websocket session on " + session + " with subprotocol=" + subprotocol));
    }

    @OnClose
    public void onClose(Session session) {
        this.log.debug((Object)("Closing session " + session));
        GraphQLWebsocketHandler handler = this.sessionsToHandlers.remove(session);
        if (handler != null) {
            handler.onClose();
        }
    }

    @OnError
    public void onError(Session session, Throwable throwable) {
        GraphQLWebsocketHandler handler = this.sessionsToHandlers.remove(session);
        if (handler != null) {
            handler.onThrowable(throwable);
        }
    }

    @OnMessage
    public void handleMessage(Session session, String message) {
        GraphQLWebsocketHandler handler = this.sessionsToHandlers.get(session);
        if (handler != null) {
            handler.onMessage(message);
        } else {
            this.log.error((Object)("Unknown session: " + session));
        }
    }

    private class SmallRyeWebSocketSession
    implements GraphQLWebSocketSession {
        private final Session session;

        public SmallRyeWebSocketSession(Session session) {
            this.session = session;
        }

        public void sendMessage(String message) throws IOException {
            if (GraphQLServerWebSocket.this.log.isTraceEnabled()) {
                GraphQLServerWebSocket.this.log.trace((Object)(">>> " + message));
            }
            this.session.getBasicRemote().sendText(message);
        }

        public void close(short statusCode, String reason) {
            try {
                this.session.close(new CloseReason(CloseReason.CloseCodes.getCloseCode((int)statusCode), reason));
            }
            catch (IOException e) {
                GraphQLServerWebSocket.this.log.warn((Object)e);
            }
        }

        public boolean isClosed() {
            return !this.session.isOpen();
        }
    }
}

