package io.smallrye.graphql.entry.http;

import java.util.Locale;
import java.io.Serializable;
import java.io.Reader;
import java.lang.String;
import org.jboss.logging.Logger;
import java.lang.Exception;
import java.net.URL;


import static org.jboss.logging.Logger.Level.ERROR;
import static org.jboss.logging.Logger.Level.INFO;
import static org.jboss.logging.Logger.Level.DEBUG;
import static org.jboss.logging.Logger.Level.WARN;

/**
 * Warning this class consists of generated code.
 */
public class SmallRyeGraphQLServletLogging_$logger implements SmallRyeGraphQLServletLogging, Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = SmallRyeGraphQLServletLogging_$logger.class.getName();
    public SmallRyeGraphQLServletLogging_$logger(final Logger log) {
        this.log = log;
    }
    protected final Logger log;
    private static final Locale LOCALE = Locale.ROOT;
    protected Locale getLoggingLocale() {
        return LOCALE;
    }
    @Override
    public final void loadedIndexFrom(final String path) {
        log.logf(FQCN, INFO, null, loadedIndexFrom$str(), path);
    }
    protected String loadedIndexFrom$str() {
        return "SRGQL020000: Loaded index from [%s]";
    }
    @Override
    public final void generatingIndex() {
        log.logf(FQCN, INFO, null, generatingIndex$str());
    }
    protected String generatingIndex$str() {
        return "SRGQL020001: No jandex index available, let's generate one...";
    }
    @Override
    public final void processingFile(final String path) {
        log.logf(FQCN, DEBUG, null, processingFile$str(), path);
    }
    protected String processingFile$str() {
        return "SRGQL020002: Processing file [%s]";
    }
    @Override
    public final void cannotProcessFile(final String path, final Exception cause) {
        log.logf(FQCN, DEBUG, cause, cannotProcessFile$str(), path);
    }
    protected String cannotProcessFile$str() {
        return "SRGQL020003: Cannot process file [%s]";
    }
    @Override
    public final void cannotCreateUrl(final Exception e) {
        log.logf(FQCN, WARN, e, cannotCreateUrl$str());
    }
    protected String cannotCreateUrl$str() {
        return "SRGQL020004: Cannot create URL from a JAR/WAR file included in the classpath";
    }
    @Override
    public final void ignoringUrl(final URL url) {
        log.logf(FQCN, WARN, null, ignoringUrl$str(), url);
    }
    protected String ignoringUrl$str() {
        return "SRGQL020005: Ignoring url [%s] as it's not a jar, war or folder";
    }
    @Override
    public final void couldNotProcessUrl(final URL url, final Exception e) {
        log.logf(FQCN, WARN, e, couldNotProcessUrl$str(), url);
    }
    protected String couldNotProcessUrl$str() {
        return "SRGQL020006: Could not process url [%s] while indexing files";
    }
    @Override
    public final void initialized() {
        log.logf(FQCN, INFO, null, initialized$str());
    }
    protected String initialized$str() {
        return "SRGQL020007: SmallRye GraphQL initialized";
    }
    @Override
    public final void destroyed() {
        log.logf(FQCN, INFO, null, destroyed$str());
    }
    protected String destroyed$str() {
        return "SRGQL020008: SmallRye GraphQL destroyed";
    }
    @Override
    public final void ioException(final Exception ex) {
        log.logf(FQCN, ERROR, ex, ioException$str());
    }
    protected String ioException$str() {
        return "SRGQL021000: IO Exception occurred";
    }
    @Override
    public final void jsonInput(final String input) {
        log.logf(FQCN, DEBUG, null, jsonInput$str(), input);
    }
    protected String jsonInput$str() {
        return "SRGQL021001: JSON input: %s";
    }
    @Override
    public final void unableToLogReader(final Reader reader) {
        log.logf(FQCN, DEBUG, null, unableToLogReader$str(), reader);
    }
    protected String unableToLogReader$str() {
        return "SRGQL021002: Unable to log reader %s";
    }
}
