/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.graphql.entry.http;

import graphql.ExecutionResult;
import graphql.schema.GraphQLSchema;
import io.smallrye.graphql.bootstrap.Config;
import io.smallrye.graphql.cdi.config.GraphQLConfig;
import io.smallrye.graphql.execution.ExecutionResponse;
import io.smallrye.graphql.execution.ExecutionService;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.concurrent.atomic.AtomicReference;
import javax.inject.Inject;
import javax.json.Json;
import javax.json.JsonObject;
import javax.json.JsonReader;
import javax.json.JsonReaderFactory;
import javax.json.bind.Jsonb;
import javax.json.bind.JsonbBuilder;
import javax.json.bind.JsonbConfig;
import javax.websocket.OnClose;
import javax.websocket.OnError;
import javax.websocket.OnMessage;
import javax.websocket.Session;
import javax.websocket.server.ServerEndpoint;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

@ServerEndpoint(value="/graphql")
public class SubscriptionWebSocket {
    private static final JsonReaderFactory jsonReaderFactory = Json.createReaderFactory(null);
    private final AtomicReference<Subscription> subscriptionRef = new AtomicReference();
    @Inject
    ExecutionService executionService;
    @Inject
    GraphQLSchema graphQLSchema;
    @Inject
    GraphQLConfig config;
    private static final Jsonb JSONB = JsonbBuilder.create((JsonbConfig)new JsonbConfig().withNullValues(Boolean.valueOf(true)));

    @OnClose
    public void onClose(Session session) throws IOException {
        this.subscriptionRef.set(null);
    }

    @OnError
    public void onError(Session session, Throwable throwable) throws IOException {
        session.getBasicRemote().sendText(throwable.getMessage());
    }

    @OnMessage
    public void handleMessage(final Session session, String message) {
        try (JsonReader jsonReader = jsonReaderFactory.createReader((Reader)new StringReader(message));){
            JsonObject jsonInput = jsonReader.readObject();
            ExecutionResponse executionResponse = this.executionService.execute(jsonInput);
            Publisher stream = (Publisher)executionResponse.getExecutionResult().getData();
            if (stream != null) {
                stream.subscribe((Subscriber)new Subscriber<ExecutionResult>(){

                    public void onSubscribe(Subscription s) {
                        SubscriptionWebSocket.this.subscriptionRef.set(s);
                        SubscriptionWebSocket.this.request(1, session);
                    }

                    public void onNext(ExecutionResult er) {
                        try {
                            if (session.isOpen()) {
                                ExecutionResponse executionResponse = new ExecutionResponse(er, (Config)SubscriptionWebSocket.this.config);
                                session.getBasicRemote().sendText(executionResponse.getExecutionResultAsString());
                            }
                        }
                        catch (IOException ex) {
                            throw new RuntimeException(ex);
                        }
                        SubscriptionWebSocket.this.request(1, session);
                    }

                    public void onError(Throwable t) {
                        try {
                            session.getBasicRemote().sendText(t.getMessage());
                        }
                        catch (IOException ex) {
                            throw new RuntimeException(ex);
                        }
                    }

                    public void onComplete() {
                        try {
                            session.close();
                        }
                        catch (IOException ex) {
                            throw new RuntimeException(ex);
                        }
                    }
                });
            }
        }
    }

    private void request(int n, Session session) {
        Subscription subscription = this.subscriptionRef.get();
        if (subscription != null && session.isOpen()) {
            subscription.request((long)n);
        }
    }
}

