/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.graphql.servlet;

import io.smallrye.graphql.servlet.SmallRyeGraphQLServletLogging;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.jboss.jandex.CompositeIndex;
import org.jboss.jandex.Index;
import org.jboss.jandex.IndexReader;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.Indexer;

public class IndexInitializer {
    private static final String DOT_JAR = ".jar";
    private static final String DOT_WAR = ".war";
    private static final String DOT_CLASS = ".class";
    private static final String JAVA_CLASS_PATH = "java.class.path";
    private static final String PATH_SEPARATOR = "path.separator";
    private static final String JANDEX_IDX = "META-INF/jandex.idx";

    public IndexView createIndex(Set<URL> urls) {
        ArrayList<IndexView> indexes = new ArrayList<IndexView>();
        try (InputStream stream = this.getClass().getClassLoader().getResourceAsStream(JANDEX_IDX);){
            IndexReader reader = new IndexReader(stream);
            Index i = reader.read();
            SmallRyeGraphQLServletLogging.log.loadedIndexFrom(JANDEX_IDX);
            indexes.add((IndexView)i);
        }
        catch (IOException ex) {
            SmallRyeGraphQLServletLogging.log.generatingIndex();
        }
        IndexView i = this.createIndexView(urls);
        indexes.add(i);
        return this.merge(indexes);
    }

    public IndexView createIndex() {
        Set<URL> urls = this.getUrlFromClassPath();
        return this.createIndexView(urls);
    }

    private IndexView createIndexView(Set<URL> urls) {
        Indexer indexer = new Indexer();
        for (URL url : urls) {
            try {
                if (url.toString().endsWith(DOT_JAR) || url.toString().endsWith(DOT_WAR)) {
                    SmallRyeGraphQLServletLogging.log.processingFile(url.toString());
                    this.processJar(url.openStream(), indexer);
                    continue;
                }
                this.processFolder(url, indexer);
            }
            catch (IOException ex) {
                SmallRyeGraphQLServletLogging.log.cannotProcessFile(url.toString(), ex);
            }
        }
        return indexer.complete();
    }

    private Set<URL> collectURLsFromClassPath() {
        HashSet<URL> urls = new HashSet<URL>();
        for (String s : System.getProperty(JAVA_CLASS_PATH).split(System.getProperty(PATH_SEPARATOR))) {
            try {
                urls.add(Paths.get(s, new String[0]).toUri().toURL());
            }
            catch (MalformedURLException e) {
                SmallRyeGraphQLServletLogging.log.cannotCreateUrl(e);
            }
        }
        return urls;
    }

    private void processFolder(URL url, Indexer indexer) throws IOException {
        block16: {
            try {
                Path folderPath = Paths.get(url.toURI());
                if (Files.isDirectory(folderPath, new LinkOption[0])) {
                    try (Stream<Path> walk = Files.walk(folderPath, new FileVisitOption[0]);){
                        List collected = walk.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).collect(Collectors.toList());
                        for (Path c : collected) {
                            String entryName = c.getFileName().toString();
                            this.processFile(entryName, Files.newInputStream(c, new OpenOption[0]), indexer);
                        }
                        break block16;
                    }
                }
                SmallRyeGraphQLServletLogging.log.ignoringUrl(url);
            }
            catch (URISyntaxException ex) {
                SmallRyeGraphQLServletLogging.log.couldNotProcessUrl(url, ex);
            }
        }
    }

    private void processJar(InputStream inputStream, Indexer indexer) throws IOException {
        ZipEntry ze;
        ZipInputStream zis = new ZipInputStream(inputStream, StandardCharsets.UTF_8);
        while ((ze = zis.getNextEntry()) != null) {
            String entryName = ze.getName();
            this.processFile(entryName, zis, indexer);
        }
    }

    private void processFile(String fileName, InputStream is, Indexer indexer) throws IOException {
        if (fileName.endsWith(DOT_CLASS)) {
            SmallRyeGraphQLServletLogging.log.processingFile(fileName);
            indexer.index(is);
        } else if (fileName.endsWith(DOT_WAR)) {
            this.processJar(is, indexer);
        }
    }

    private IndexView merge(Collection<IndexView> indexes) {
        return CompositeIndex.create(indexes);
    }

    private Set<URL> getUrlFromClassPath() {
        HashSet<URL> urls = new HashSet<URL>();
        ClassLoader cl = ClassLoader.getSystemClassLoader();
        if (cl instanceof URLClassLoader) {
            urls.addAll(Arrays.asList(((URLClassLoader)cl).getURLs()));
        } else {
            urls.addAll(this.collectURLsFromClassPath());
        }
        return urls;
    }
}

