/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.graphql.servlet;

import io.smallrye.graphql.schema.SchemaBuilder;
import io.smallrye.graphql.schema.model.Schema;
import io.smallrye.graphql.servlet.GraphQLConfig;
import io.smallrye.graphql.servlet.GraphQLProducer;
import io.smallrye.graphql.servlet.IndexInitializer;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Paths;
import javax.inject.Inject;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.servlet.annotation.WebListener;
import org.jboss.jandex.IndexView;
import org.jboss.logging.Logger;

@WebListener
public class StartupListener
implements ServletContextListener {
    private static final Logger LOG = Logger.getLogger((String)StartupListener.class.getName());
    @Inject
    private GraphQLProducer graphQLProducer;
    @Inject
    private GraphQLConfig config;
    private final IndexInitializer indexInitializer = new IndexInitializer();

    public void contextInitialized(ServletContextEvent sce) {
        try {
            String realPath = sce.getServletContext().getRealPath("WEB-INF/classes");
            URL url = Paths.get(realPath, new String[0]).toUri().toURL();
            IndexView index = this.indexInitializer.createIndex(url);
            Schema schema = SchemaBuilder.build((IndexView)index);
            this.graphQLProducer.initializeGraphQL(this.config, schema);
            sce.getServletContext().setAttribute("io.smallrye.graphql.servlet.bootstrap", (Object)this.graphQLProducer.getGraphQLSchema());
            LOG.info((Object)"SmallRye GraphQL initialized");
        }
        catch (MalformedURLException ex) {
            throw new RuntimeException(ex);
        }
    }

    public void contextDestroyed(ServletContextEvent sce) {
        LOG.info((Object)"SmallRye GraphQL destroyed");
    }
}

