/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.graphql.servlet;

import io.smallrye.graphql.bootstrap.Config;
import java.util.Collections;
import java.util.List;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.eclipse.microprofile.config.inject.ConfigProperty;

@ApplicationScoped
public class GraphQLConfig
implements Config {
    private static final String SUPPOSED_EMPTY_STRING = "**empty**";
    private static final List<String> SUPPOSED_EMPTY_LIST = Collections.singletonList("**empty**");
    @Inject
    @ConfigProperty(name="mp.graphql.exceptionsBlackList", defaultValue="**empty**")
    private List<String> blackList;
    @Inject
    @ConfigProperty(name="mp.graphql.exceptionsWhiteList", defaultValue="**empty**")
    private List<String> whiteList;
    @Inject
    @ConfigProperty(name="mp.graphql.defaultErrorMessage", defaultValue="Server Error")
    private String defaultErrorMessage;
    @Inject
    @ConfigProperty(name="mp.graphql.printDataFetcherException", defaultValue="false")
    private boolean printDataFetcherException;
    @Inject
    @ConfigProperty(name="mp.graphql.allowGet", defaultValue="false")
    private boolean allowGet;
    @Inject
    @ConfigProperty(name="smallrye.graphql.metrics.enabled", defaultValue="false")
    private boolean metricsEnabled;

    public String getDefaultErrorMessage() {
        return this.defaultErrorMessage;
    }

    public boolean isPrintDataFetcherException() {
        return this.printDataFetcherException;
    }

    public List<String> getBlackList() {
        if (SUPPOSED_EMPTY_LIST.equals(this.blackList)) {
            this.blackList = Collections.emptyList();
        }
        return this.blackList;
    }

    public List<String> getWhiteList() {
        if (SUPPOSED_EMPTY_LIST.equals(this.whiteList)) {
            this.whiteList = Collections.emptyList();
        }
        return this.whiteList;
    }

    public boolean isAllowGet() {
        return this.allowGet;
    }

    public boolean isMetricsEnabled() {
        return this.metricsEnabled;
    }
}

