/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.graphql.servlet;

import io.smallrye.graphql.execution.ExecutionService;
import io.smallrye.graphql.servlet.GraphQLConfig;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import javax.inject.Inject;
import javax.json.Json;
import javax.json.JsonObject;
import javax.json.JsonReader;
import javax.json.JsonWriter;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jboss.logging.Logger;

@WebServlet(name="SmallRyeGraphQLExecutionServlet", urlPatterns={"/graphql/*"}, loadOnStartup=1)
public class ExecutionServlet
extends HttpServlet {
    private static final Logger LOG = Logger.getLogger((String)ExecutionServlet.class.getName());
    @Inject
    ExecutionService executionService;
    @Inject
    GraphQLConfig config;
    private static final String APPLICATION_JSON_UTF8 = "application/json;charset=UTF-8";
    private static final String QUERY = "query";

    public ExecutionServlet() {
    }

    public ExecutionServlet(ExecutionService executionService, GraphQLConfig config) {
        this.executionService = executionService;
        this.config = config;
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) {
        if (this.config.isAllowGet()) {
            try (StringReader reader = new StringReader(request.getParameter(QUERY));){
                this.handleInput(reader, response);
            }
        }
        try {
            response.sendError(405, "GET Queries is not enabled");
        }
        catch (IOException ex) {
            LOG.log(Logger.Level.ERROR, null, (Throwable)ex);
        }
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) {
        try (BufferedReader reader = request.getReader();){
            this.handleInput(reader, response);
        }
        catch (IOException ex) {
            LOG.log(Logger.Level.ERROR, null, (Throwable)ex);
        }
    }

    private void handleInput(Reader inputReader, HttpServletResponse response) {
        block27: {
            if (LOG.isDebugEnabled()) {
                inputReader = ExecutionServlet.logInputReader(inputReader);
            }
            try (JsonReader jsonReader = Json.createReader((Reader)inputReader);){
                JsonObject jsonInput = jsonReader.readObject();
                JsonObject outputJson = this.executionService.execute(jsonInput);
                if (outputJson == null) break block27;
                PrintWriter out = response.getWriter();
                response.setContentType(APPLICATION_JSON_UTF8);
                try (JsonWriter jsonWriter = Json.createWriter((Writer)out);){
                    jsonWriter.writeObject(outputJson);
                    out.flush();
                }
            }
            catch (IOException ex) {
                LOG.log(Logger.Level.ERROR, null, (Throwable)ex);
            }
        }
    }

    private static Reader logInputReader(Reader inputReader) {
        try {
            int len;
            StringBuilder sb = new StringBuilder();
            char[] buf = new char[4096];
            while ((len = inputReader.read(buf)) > -1) {
                sb.append(buf, 0, len);
            }
            String jsonInput = sb.toString();
            LOG.debugf("JSON input: {0}", (Object)jsonInput);
            inputReader = new StringReader(jsonInput);
        }
        catch (Throwable t) {
            LOG.warnf("Unable to log reader, {0}", (Object)inputReader);
        }
        return inputReader;
    }
}

