/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.graphql.schema.model;

import io.smallrye.graphql.schema.model.DirectiveType;
import io.smallrye.graphql.schema.model.EnumType;
import io.smallrye.graphql.schema.model.ErrorInfo;
import io.smallrye.graphql.schema.model.Group;
import io.smallrye.graphql.schema.model.InputType;
import io.smallrye.graphql.schema.model.Operation;
import io.smallrye.graphql.schema.model.Type;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class Schema
implements Serializable {
    private Set<Operation> queries = new HashSet<Operation>();
    private Set<Operation> mutations = new HashSet<Operation>();
    private Set<Operation> subscriptions = new HashSet<Operation>();
    private Map<Group, Set<Operation>> groupedQueries = new HashMap<Group, Set<Operation>>();
    private Map<Group, Set<Operation>> groupedMutations = new HashMap<Group, Set<Operation>>();
    private Map<Group, Set<Operation>> groupedSubscriptions = new HashMap<Group, Set<Operation>>();
    private List<DirectiveType> directiveTypes = new ArrayList<DirectiveType>();
    private Map<String, InputType> inputs = new HashMap<String, InputType>();
    private Map<String, Type> types = new HashMap<String, Type>();
    private Map<String, Type> interfaces = new HashMap<String, Type>();
    private Map<String, EnumType> enums = new HashMap<String, EnumType>();
    private Map<String, ErrorInfo> errors = new HashMap<String, ErrorInfo>();

    public Set<Operation> getQueries() {
        return this.queries;
    }

    public void setQueries(Set<Operation> queries) {
        this.queries = queries;
    }

    public void addQuery(Operation query) {
        this.queries.add(query);
    }

    public boolean hasOperations() {
        return this.hasQueries() || this.hasGroupedQueries() || this.hasMutations() || this.hasGroupedMutations();
    }

    public boolean hasQueries() {
        return !this.queries.isEmpty();
    }

    public Set<Operation> getMutations() {
        return this.mutations;
    }

    public void setMutations(Set<Operation> mutations) {
        this.mutations = mutations;
    }

    public void addMutation(Operation mutation) {
        this.mutations.add(mutation);
    }

    public boolean hasMutations() {
        return !this.mutations.isEmpty();
    }

    public Set<Operation> getSubscriptions() {
        return this.subscriptions;
    }

    public void setSubscriptions(Set<Operation> subscriptions) {
        this.subscriptions = subscriptions;
    }

    public void addSubscription(Operation subscription) {
        this.subscriptions.add(subscription);
    }

    public boolean hasSubscriptions() {
        return !this.subscriptions.isEmpty();
    }

    public Map<Group, Set<Operation>> getGroupedQueries() {
        return this.groupedQueries;
    }

    public void setGroupedQueries(Map<Group, Set<Operation>> groupedQueries) {
        this.groupedQueries = groupedQueries;
    }

    public void addGroupedQuery(Group group, Operation query) {
        this.addToOperationMap(this.groupedQueries, group, query);
    }

    public boolean hasGroupedQueries() {
        return !this.groupedQueries.isEmpty();
    }

    public Map<Group, Set<Operation>> getGroupedMutations() {
        return this.groupedMutations;
    }

    public void setGroupedMutations(Map<Group, Set<Operation>> groupedMutations) {
        this.groupedMutations = groupedMutations;
    }

    public void addGroupedMutation(Group group, Operation mutation) {
        this.addToOperationMap(this.groupedMutations, group, mutation);
    }

    public boolean hasGroupedMutations() {
        return !this.groupedMutations.isEmpty();
    }

    public Map<Group, Set<Operation>> getGroupedSubscriptions() {
        return this.groupedSubscriptions;
    }

    public void setGroupedSubscriptions(Map<Group, Set<Operation>> groupedSubscriptions) {
        this.groupedSubscriptions = groupedSubscriptions;
    }

    public void addGroupedSubscription(Group group, Operation subscription) {
        this.addToOperationMap(this.groupedSubscriptions, group, subscription);
    }

    public boolean hasGroupedSubscriptions() {
        return !this.groupedSubscriptions.isEmpty();
    }

    public Map<String, InputType> getInputs() {
        return this.inputs;
    }

    public void setInputs(Map<String, InputType> inputs) {
        this.inputs = inputs;
    }

    public void addInput(InputType input) {
        this.inputs.put(input.getName(), input);
    }

    public boolean containsInput(String name) {
        return this.inputs.containsKey(name);
    }

    public boolean hasInputs() {
        return !this.inputs.isEmpty();
    }

    public Map<String, Type> getTypes() {
        return this.types;
    }

    public void setTypes(Map<String, Type> types) {
        this.types = types;
    }

    public void addType(Type type) {
        this.types.put(type.getName(), type);
    }

    public boolean containsType(String name) {
        return this.types.containsKey(name);
    }

    public boolean hasTypes() {
        return !this.types.isEmpty();
    }

    public Map<String, Type> getInterfaces() {
        return this.interfaces;
    }

    public void setInterfaces(Map<String, Type> interfaces) {
        this.interfaces = interfaces;
    }

    public void addInterface(Type interfaceType) {
        if (interfaceType.getFields() != null && !interfaceType.getFields().isEmpty()) {
            this.interfaces.put(interfaceType.getName(), interfaceType);
        }
    }

    public boolean containsInterface(String name) {
        return this.interfaces.containsKey(name);
    }

    public boolean hasInterfaces() {
        return !this.interfaces.isEmpty();
    }

    public Map<String, EnumType> getEnums() {
        return this.enums;
    }

    public void setEnums(Map<String, EnumType> enums) {
        this.enums = enums;
    }

    public void addEnum(EnumType enumType) {
        this.enums.put(enumType.getName(), enumType);
    }

    public boolean containsEnum(String name) {
        return this.enums.containsKey(name);
    }

    public boolean hasEnums() {
        return !this.enums.isEmpty();
    }

    public Map<String, ErrorInfo> getErrors() {
        return this.errors;
    }

    public void setErrors(Map<String, ErrorInfo> errors) {
        this.errors = errors;
    }

    public void addError(ErrorInfo error) {
        this.errors.put(error.getClassName(), error);
    }

    public boolean containsError(String classname) {
        return this.errors.containsKey(classname);
    }

    public boolean hasErrors() {
        return !this.errors.isEmpty();
    }

    public List<Operation> getBatchOperations() {
        ArrayList<Operation> batchOperations = new ArrayList<Operation>();
        if (this.hasTypes()) {
            for (Type type : this.types.values()) {
                if (!type.hasBatchOperations()) continue;
                batchOperations.addAll(type.getBatchOperations().values());
            }
        }
        return batchOperations;
    }

    private void addToOperationMap(Map<Group, Set<Operation>> map, Group group, Operation query) {
        Set<Object> set = map.containsKey(group) ? map.get(group) : new HashSet();
        set.add(query);
        map.put(group, set);
    }

    public List<DirectiveType> getDirectiveTypes() {
        return this.directiveTypes;
    }

    public void setDirectiveTypes(List<DirectiveType> directiveTypes) {
        this.directiveTypes = directiveTypes;
    }

    public void addDirectiveType(DirectiveType directiveType) {
        this.directiveTypes.add(directiveType);
    }

    public boolean hasDirectiveTypes() {
        return !this.directiveTypes.isEmpty();
    }

    public String toString() {
        return "Schema{queries=" + this.queries + ", mutations=" + this.mutations + ", subscriptions=" + this.subscriptions + ", groupedQueries=" + this.groupedQueries + ", groupedMutations=" + this.groupedMutations + ", groupedSubscriptions=" + this.groupedSubscriptions + ", directiveTypes=" + this.directiveTypes + ", inputs=" + this.inputs + ", types=" + this.types + ", interfaces=" + this.interfaces + ", enums=" + this.enums + ", errors=" + this.errors + '}';
    }
}

