/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.graphql.schema.model;

import io.smallrye.graphql.schema.model.Argument;
import io.smallrye.graphql.schema.model.Field;
import io.smallrye.graphql.schema.model.OperationType;
import io.smallrye.graphql.schema.model.Reference;
import java.util.LinkedList;
import java.util.List;

public final class Operation
extends Field {
    private String className;
    private List<Argument> arguments = new LinkedList<Argument>();
    private OperationType operationType;
    private Reference sourceFieldOn = null;

    public Operation() {
    }

    public Operation(String className, String methodName, String propertyName, String name, Reference reference, OperationType operationType) {
        super(methodName, propertyName, name, reference);
        this.className = className;
        this.operationType = operationType;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public String getClassName() {
        return this.className;
    }

    public List<Argument> getArguments() {
        return this.arguments;
    }

    public void setArguments(List<Argument> arguments) {
        this.arguments = arguments;
    }

    public void addArgument(Argument argument) {
        this.arguments.add(argument);
    }

    public boolean hasArguments() {
        return !this.arguments.isEmpty();
    }

    public void setOperationType(OperationType operationType) {
        this.operationType = operationType;
    }

    public OperationType getOperationType() {
        return this.operationType;
    }

    public Reference getSourceFieldOn() {
        return this.sourceFieldOn;
    }

    public void setSourceFieldOn(Reference sourceFieldOn) {
        this.sourceFieldOn = sourceFieldOn;
    }

    public boolean isSourceField() {
        return this.sourceFieldOn != null;
    }

    @Override
    public String toString() {
        return "Operation{className=" + this.className + ", arguments=" + this.arguments + ", operationType=" + (Object)((Object)this.operationType) + ", sourceFieldOn=" + this.sourceFieldOn + '}';
    }
}

