/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.graphql.schema.model;

import io.smallrye.graphql.schema.model.Reference;
import io.smallrye.graphql.schema.model.ReferenceType;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.net.URL;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.Period;
import java.time.ZonedDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

public class Scalars {
    private static final Map<String, Reference> scalarMap = new HashMap<String, Reference>();
    private static final Map<String, Reference> scalarNameMap = new HashMap<String, Reference>();
    private static final Map<String, Reference> formattedScalarMap = new HashMap<String, Reference>();
    private static final String STRING = "String";
    private static final String BOOLEAN = "Boolean";
    private static final String INTEGER = "Int";
    private static final String FLOAT = "Float";
    private static final String BIGINTEGER = "BigInteger";
    private static final String BIGDECIMAL = "BigDecimal";
    private static final String DATE = "Date";
    private static final String TIME = "Time";
    private static final String DATETIME = "DateTime";
    private static final String ID = "ID";
    private static final String PERIOD = "Period";
    private static final String DURATION = "Duration";

    private Scalars() {
    }

    public static boolean isScalar(String className) {
        return scalarMap.containsKey(className);
    }

    public static Reference getScalar(String identifier) {
        if (scalarMap.containsKey(identifier)) {
            return scalarMap.get(identifier);
        }
        return scalarNameMap.get(identifier);
    }

    public static Reference getFormattedScalar(String className) {
        return formattedScalarMap.get(className);
    }

    public static Reference getIDScalar(String className) {
        return new Reference(className, ID, ReferenceType.SCALAR);
    }

    private static void populateScalar(String className, String scalarName) {
        Scalars.populateScalar(className, scalarName, className);
    }

    private static void populateScalar(String className, String scalarName, String externalClassName) {
        Reference reference = new Reference(className, scalarName, ReferenceType.SCALAR, externalClassName);
        scalarMap.put(className, reference);
        scalarNameMap.putIfAbsent(scalarName, reference);
        formattedScalarMap.put(className, new Reference(className, STRING, ReferenceType.SCALAR, String.class.getName()));
    }

    static {
        Scalars.populateScalar(String.class.getName(), STRING, String.class.getName());
        Scalars.populateScalar(Character.TYPE.getName(), STRING, String.class.getName());
        Scalars.populateScalar(Character.class.getName(), STRING, String.class.getName());
        Scalars.populateScalar(UUID.class.getName(), STRING, String.class.getName());
        Scalars.populateScalar(URL.class.getName(), STRING, String.class.getName());
        Scalars.populateScalar(URI.class.getName(), STRING, String.class.getName());
        Scalars.populateScalar("javax.json.JsonObject", STRING, String.class.getName());
        Scalars.populateScalar("javax.json.JsonArray", STRING, String.class.getName());
        Scalars.populateScalar(Boolean.class.getName(), BOOLEAN);
        Scalars.populateScalar(Boolean.TYPE.getName(), BOOLEAN);
        Scalars.populateScalar(AtomicBoolean.class.getName(), BOOLEAN);
        Scalars.populateScalar(Integer.class.getName(), INTEGER, Integer.class.getName());
        Scalars.populateScalar(Integer.TYPE.getName(), INTEGER, Integer.class.getName());
        Scalars.populateScalar(Short.class.getName(), INTEGER, Integer.class.getName());
        Scalars.populateScalar(Short.TYPE.getName(), INTEGER, Integer.class.getName());
        Scalars.populateScalar(Byte.class.getName(), INTEGER, Integer.class.getName());
        Scalars.populateScalar(Byte.TYPE.getName(), INTEGER, Integer.class.getName());
        Scalars.populateScalar(OptionalInt.class.getName(), INTEGER, Integer.class.getName());
        Scalars.populateScalar(AtomicInteger.class.getName(), INTEGER, Integer.class.getName());
        Scalars.populateScalar(Float.class.getName(), FLOAT, Float.class.getName());
        Scalars.populateScalar(Float.TYPE.getName(), FLOAT, Float.class.getName());
        Scalars.populateScalar(Double.class.getName(), FLOAT, Float.class.getName());
        Scalars.populateScalar(Double.TYPE.getName(), FLOAT, Float.class.getName());
        Scalars.populateScalar(OptionalDouble.class.getName(), FLOAT, Float.class.getName());
        Scalars.populateScalar(BigInteger.class.getName(), BIGINTEGER, BigInteger.class.getName());
        Scalars.populateScalar(Long.class.getName(), BIGINTEGER, BigInteger.class.getName());
        Scalars.populateScalar(Long.TYPE.getName(), BIGINTEGER, BigInteger.class.getName());
        Scalars.populateScalar(OptionalLong.class.getName(), BIGINTEGER, BigInteger.class.getName());
        Scalars.populateScalar(AtomicLong.class.getName(), BIGINTEGER, BigInteger.class.getName());
        Scalars.populateScalar(BigDecimal.class.getName(), BIGDECIMAL, BigDecimal.class.getName());
        Scalars.populateScalar(LocalDate.class.getName(), DATE, String.class.getName());
        Scalars.populateScalar(Date.class.getName(), DATE, String.class.getName());
        Scalars.populateScalar(LocalTime.class.getName(), TIME, String.class.getName());
        Scalars.populateScalar(Time.class.getName(), TIME, String.class.getName());
        Scalars.populateScalar(OffsetTime.class.getName(), TIME, String.class.getName());
        Scalars.populateScalar(LocalDateTime.class.getName(), DATETIME, String.class.getName());
        Scalars.populateScalar(java.util.Date.class.getName(), DATETIME, String.class.getName());
        Scalars.populateScalar(Timestamp.class.getName(), DATETIME, String.class.getName());
        Scalars.populateScalar(ZonedDateTime.class.getName(), DATETIME, String.class.getName());
        Scalars.populateScalar(OffsetDateTime.class.getName(), DATETIME, String.class.getName());
        Scalars.populateScalar(Duration.class.getName(), DURATION, String.class.getName());
        Scalars.populateScalar(Period.class.getName(), PERIOD, String.class.getName());
    }
}

