/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.graphql.schema.helper;

import io.smallrye.graphql.schema.Annotations;
import io.smallrye.graphql.schema.model.DirectiveInstance;
import io.smallrye.graphql.schema.model.DirectiveType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.DotName;
import org.jboss.logging.Logger;

public class Directives {
    private final Map<DotName, DirectiveType> directiveTypes = new HashMap<DotName, DirectiveType>();
    private final List<DirectiveType> directiveTypesOther = new ArrayList<DirectiveType>();
    private static final Logger LOG = Logger.getLogger((String)Directives.class.getName());

    public Directives(List<DirectiveType> directiveTypes) {
        for (DirectiveType directiveType : directiveTypes) {
            if (directiveType.getClassName() != null) {
                this.directiveTypes.put(DotName.createSimple((String)directiveType.getClassName()), directiveType);
                continue;
            }
            this.directiveTypesOther.add(directiveType);
        }
    }

    public List<DirectiveInstance> buildDirectiveInstances(Annotations annotations, String directiveLocation, String referenceName) {
        return this.directiveTypes.keySet().stream().flatMap(annotations::resolve).map(this::toDirectiveInstance).filter(directiveInstance -> {
            if (!directiveInstance.getType().getLocations().contains(directiveLocation)) {
                LOG.warnf("Directive instance: '%s' assigned to '%s' cannot be applied. The directive is allowed on locations '%s' but on '%s'", new Object[]{directiveInstance.getType().getClassName(), referenceName, directiveInstance.getType().getLocations(), directiveLocation});
                return false;
            }
            return true;
        }).collect(Collectors.toList());
    }

    private DirectiveInstance toDirectiveInstance(AnnotationInstance annotationInstance) {
        DirectiveInstance directiveInstance = new DirectiveInstance();
        directiveInstance.setType(this.directiveTypes.get(annotationInstance.name()));
        for (AnnotationValue annotationValue : annotationInstance.values()) {
            directiveInstance.setValue(annotationValue.name(), this.valueObject(annotationValue));
        }
        return directiveInstance;
    }

    private Object valueObject(AnnotationValue annotationValue) {
        if (annotationValue.kind() == AnnotationValue.Kind.ARRAY) {
            AnnotationValue[] values = (AnnotationValue[])annotationValue.value();
            Object[] objects = new Object[values.length];
            for (int i = 0; i < values.length; ++i) {
                objects[i] = this.valueObject(values[i]);
            }
            return objects;
        }
        return annotationValue.value();
    }

    public Map<DotName, DirectiveType> getDirectiveTypes() {
        return this.directiveTypes;
    }
}

