/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.graphql.schema.creator;

import io.smallrye.graphql.schema.Annotations;
import io.smallrye.graphql.schema.Classes;
import io.smallrye.graphql.schema.SchemaBuilderException;
import io.smallrye.graphql.schema.creator.ModelCreator;
import io.smallrye.graphql.schema.creator.ReferenceCreator;
import io.smallrye.graphql.schema.helper.BeanValidationDirectivesHelper;
import io.smallrye.graphql.schema.helper.DeprecatedDirectivesHelper;
import io.smallrye.graphql.schema.helper.Direction;
import io.smallrye.graphql.schema.helper.IgnoreHelper;
import io.smallrye.graphql.schema.helper.MethodHelper;
import io.smallrye.graphql.schema.model.DirectiveInstance;
import io.smallrye.graphql.schema.model.Field;
import io.smallrye.graphql.schema.model.Reference;
import java.lang.reflect.Modifier;
import java.util.List;
import java.util.Optional;
import org.jboss.jandex.DotName;
import org.jboss.jandex.FieldInfo;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.Type;
import org.jboss.logging.Logger;

public class FieldCreator
extends ModelCreator {
    private final Logger logger = Logger.getLogger((String)FieldCreator.class.getName());
    private final BeanValidationDirectivesHelper validationHelper = new BeanValidationDirectivesHelper();
    private final DeprecatedDirectivesHelper deprecatedHelper = new DeprecatedDirectivesHelper();

    public FieldCreator(ReferenceCreator referenceCreator) {
        super(referenceCreator);
    }

    public Optional<Field> createFieldForInterface(MethodInfo methodInfo, Reference parentObjectReference) {
        Annotations annotationsForMethod = Annotations.getAnnotationsForInterfaceField(methodInfo);
        if (!FieldCreator.isGraphQlField(Direction.OUT, null, methodInfo)) {
            return Optional.empty();
        }
        Type returnType = FieldCreator.getReturnType(methodInfo);
        String name = FieldCreator.getFieldName(Direction.OUT, annotationsForMethod, methodInfo.name());
        FieldCreator.validateFieldType(Direction.OUT, methodInfo);
        Reference reference = this.referenceCreator.createReferenceForInterfaceField(returnType, annotationsForMethod, parentObjectReference);
        Field field = new Field(methodInfo.name(), MethodHelper.getPropertyName(Direction.OUT, methodInfo.name()), name, reference);
        this.populateField(Direction.OUT, field, returnType, annotationsForMethod);
        return Optional.of(field);
    }

    public Optional<Field> createFieldForPojo(Direction direction, FieldInfo fieldInfo, MethodInfo methodInfo, Reference parentObjectReference) {
        Annotations annotationsForPojo = Annotations.getAnnotationsForPojo(direction, fieldInfo, methodInfo);
        if (FieldCreator.isGraphQlField(direction, fieldInfo, methodInfo)) {
            Type methodType = FieldCreator.getMethodType(methodInfo, direction);
            String name = FieldCreator.getFieldName(direction, annotationsForPojo, methodInfo.name());
            FieldCreator.validateFieldType(direction, methodInfo);
            Type fieldType = FieldCreator.getFieldType(fieldInfo, methodType);
            Reference reference = this.referenceCreator.createReferenceForPojoField(fieldType, methodType, annotationsForPojo, direction, parentObjectReference);
            Field field = new Field(methodInfo.name(), MethodHelper.getPropertyName(direction, methodInfo.name()), name, reference);
            if (direction == Direction.IN) {
                this.addDirectivesForBeanValidationConstraints(annotationsForPojo, field, parentObjectReference);
                this.addDirectivesForDeprecated(annotationsForPojo, field, parentObjectReference);
            }
            this.populateField(direction, field, fieldType, methodType, annotationsForPojo);
            return Optional.of(field);
        }
        return Optional.empty();
    }

    public Optional<Field> createFieldForParameter(MethodInfo method, short position, FieldInfo fieldInfo, Reference parentObjectReference) {
        Annotations annotationsForPojo = Annotations.getAnnotationsForInputCreator(method, position, fieldInfo);
        String name = FieldCreator.getFieldName(Direction.IN, annotationsForPojo, method.parameterName((int)position));
        Type fieldType = FieldCreator.getFieldType(fieldInfo, method.parameterType((int)position));
        Reference reference = this.referenceCreator.createReferenceForPojoField(fieldType, method.parameterType((int)position), annotationsForPojo, Direction.IN, parentObjectReference);
        String fieldName = fieldInfo != null ? fieldInfo.name() : null;
        Field field = new Field(null, fieldName, name, reference);
        this.addDirectivesForBeanValidationConstraints(annotationsForPojo, field, parentObjectReference);
        this.addDirectivesForDeprecated(annotationsForPojo, field, parentObjectReference);
        this.populateField(Direction.IN, field, fieldType, method.parameterType((int)position), annotationsForPojo);
        return Optional.of(field);
    }

    public Optional<Field> createFieldForPojo(Direction direction, FieldInfo fieldInfo, Reference parentObjectReference) {
        if (FieldCreator.isGraphQlField(direction, fieldInfo, null)) {
            Annotations annotationsForPojo = Annotations.getAnnotationsForPojo(direction, fieldInfo);
            String name = FieldCreator.getFieldName(direction, annotationsForPojo, fieldInfo.name());
            Type fieldType = FieldCreator.getFieldType(fieldInfo);
            Reference reference = this.referenceCreator.createReferenceForPojoField(fieldType, fieldType, annotationsForPojo, direction, parentObjectReference);
            Field field = new Field(null, fieldInfo.name(), name, reference);
            if (direction == Direction.IN) {
                this.addDirectivesForBeanValidationConstraints(annotationsForPojo, field, parentObjectReference);
                this.addDirectivesForDeprecated(annotationsForPojo, field, parentObjectReference);
            }
            this.populateField(direction, field, fieldType, annotationsForPojo);
            return Optional.of(field);
        }
        return Optional.empty();
    }

    private void addDirectivesForBeanValidationConstraints(Annotations annotationsForPojo, Field field, Reference parentObjectReference) {
        List<DirectiveInstance> constraintDirectives;
        if (this.validationHelper != null && !(constraintDirectives = this.validationHelper.transformBeanValidationConstraintsToDirectives(annotationsForPojo)).isEmpty()) {
            this.logger.debug((Object)("Adding constraint directives " + constraintDirectives + " to field '" + field.getName() + "' of parent type '" + parentObjectReference.getName() + "'"));
            field.addDirectiveInstances(constraintDirectives);
        }
    }

    private void addDirectivesForDeprecated(Annotations annotationsForPojo, Field field, Reference parentObjectReference) {
        List<DirectiveInstance> deprecatedDirectives;
        if (this.deprecatedHelper != null && this.directives != null && !(deprecatedDirectives = this.deprecatedHelper.transformDeprecatedToDirectives(annotationsForPojo, this.directives.getDirectiveTypes().get(DotName.createSimple((String)"io.smallrye.graphql.api.Deprecated")))).isEmpty()) {
            this.logger.debug((Object)("Adding deprecated directives " + deprecatedDirectives + " to field '" + field.getName() + "' of parent type '" + parentObjectReference.getName() + "'"));
            field.addDirectiveInstances(deprecatedDirectives);
        }
    }

    protected static boolean isGraphQlField(Direction direction, FieldInfo fieldInfo, MethodInfo methodInfo) {
        boolean methodAccessible = FieldCreator.isPossibleField(methodInfo);
        boolean fieldAccessible = FieldCreator.isPossibleField(direction, fieldInfo);
        if (!methodAccessible && !fieldAccessible) {
            return false;
        }
        Annotations annotationsForPojo = Annotations.getAnnotationsForPojo(direction, fieldInfo, methodInfo);
        return !IgnoreHelper.shouldIgnore(annotationsForPojo, fieldInfo);
    }

    private static boolean isPossibleField(MethodInfo methodInfo) {
        return methodInfo != null && Modifier.isPublic(methodInfo.flags()) && !Modifier.isStatic(methodInfo.flags());
    }

    private static boolean isPossibleField(Direction direction, FieldInfo fieldInfo) {
        return fieldInfo != null && (direction != Direction.IN || !Modifier.isFinal(fieldInfo.flags())) && Modifier.isPublic(fieldInfo.flags()) && !Modifier.isStatic(fieldInfo.flags());
    }

    private static void validateFieldType(Direction direction, MethodInfo methodInfo) {
        Type returnType = methodInfo.returnType();
        if (direction.equals((Object)Direction.OUT) && returnType.kind().equals((Object)Type.Kind.VOID)) {
            throw new SchemaBuilderException("Can not have a void return method [" + methodInfo.name() + "] in class [" + methodInfo.declaringClass().name() + "]");
        }
    }

    private static Type getMethodType(MethodInfo method, Direction direction) {
        if (direction.equals((Object)Direction.IN)) {
            return method.parameterType(0);
        }
        return FieldCreator.getReturnType(method);
    }

    private static Type getFieldType(FieldInfo fieldInfo) {
        return FieldCreator.getReturnType(fieldInfo);
    }

    private static Type getFieldType(FieldInfo fieldInfo, Type defaultType) {
        if (fieldInfo == null || fieldInfo.type().name().equals((Object)Classes.SERIALIZABLE) || fieldInfo.type().name().equals((Object)Classes.OBJECT)) {
            return defaultType;
        }
        return FieldCreator.getReturnType(fieldInfo);
    }

    static String getFieldName(Direction direction, Annotations annotationsForThisField, String defaultFieldName) {
        switch (direction) {
            case OUT: {
                return FieldCreator.getOutputNameForField(annotationsForThisField, defaultFieldName);
            }
            case IN: {
                return FieldCreator.getInputNameForField(annotationsForThisField, defaultFieldName);
            }
        }
        return defaultFieldName;
    }

    private static String getOutputNameForField(Annotations annotationsForThisField, String fieldName) {
        return annotationsForThisField.getOneOfTheseMethodAnnotationsValue(Annotations.NAME, Annotations.QUERY, Annotations.JAKARTA_JSONB_PROPERTY, Annotations.JAVAX_JSONB_PROPERTY, Annotations.JACKSON_PROPERTY).orElse(annotationsForThisField.getOneOfTheseAnnotationsValue(Annotations.NAME, Annotations.QUERY, Annotations.JAKARTA_JSONB_PROPERTY, Annotations.JAVAX_JSONB_PROPERTY, Annotations.JACKSON_PROPERTY).orElse(MethodHelper.getPropertyName(Direction.OUT, fieldName)));
    }

    private static String getInputNameForField(Annotations annotationsForThisField, String fieldName) {
        return annotationsForThisField.getOneOfTheseMethodAnnotationsValue(Annotations.NAME, Annotations.JAKARTA_JSONB_PROPERTY, Annotations.JAVAX_JSONB_PROPERTY, Annotations.JACKSON_PROPERTY).orElse(annotationsForThisField.getOneOfTheseAnnotationsValue(Annotations.NAME, Annotations.JAKARTA_JSONB_PROPERTY, Annotations.JAVAX_JSONB_PROPERTY, Annotations.JACKSON_PROPERTY).orElse(MethodHelper.getPropertyName(Direction.IN, fieldName)));
    }
}

