/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.graphql.schema.creator.type;

import io.smallrye.graphql.schema.Annotations;
import io.smallrye.graphql.schema.creator.type.Creator;
import io.smallrye.graphql.schema.helper.DescriptionHelper;
import io.smallrye.graphql.schema.helper.Direction;
import io.smallrye.graphql.schema.helper.IgnoreHelper;
import io.smallrye.graphql.schema.helper.TypeAutoNameStrategy;
import io.smallrye.graphql.schema.helper.TypeNameHelper;
import io.smallrye.graphql.schema.model.EnumType;
import io.smallrye.graphql.schema.model.EnumValue;
import io.smallrye.graphql.schema.model.Reference;
import io.smallrye.graphql.schema.model.ReferenceType;
import java.util.List;
import java.util.Optional;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.FieldInfo;
import org.jboss.jandex.Type;
import org.jboss.logging.Logger;

public class EnumCreator
implements Creator<EnumType> {
    private static final Logger LOG = Logger.getLogger((String)EnumCreator.class.getName());
    private final TypeAutoNameStrategy autoNameStrategy;

    public EnumCreator(TypeAutoNameStrategy autoNameStrategy) {
        this.autoNameStrategy = autoNameStrategy;
    }

    @Override
    public EnumType create(ClassInfo classInfo, Reference reference) {
        LOG.debug((Object)("Creating enum from " + classInfo.name().toString()));
        Annotations annotations = Annotations.getAnnotationsForClass(classInfo);
        String name = TypeNameHelper.getAnyTypeName(classInfo, annotations, this.autoNameStrategy, ReferenceType.ENUM, reference.getClassParametrizedTypes());
        Optional<String> maybeDescription = DescriptionHelper.getDescriptionForType(annotations);
        EnumType enumType = new EnumType(classInfo.name().toString(), name, (String)maybeDescription.orElse(null));
        List fields = classInfo.fields();
        for (FieldInfo field : fields) {
            if (!classInfo.name().equals((Object)field.type().name())) continue;
            Annotations annotationsForField = Annotations.getAnnotationsForPojo(Direction.OUT, field);
            if (field.type().kind().equals((Object)Type.Kind.ARRAY) || IgnoreHelper.shouldIgnore(annotationsForField, field)) continue;
            String description = annotationsForField.getOneOfTheseAnnotationsValue(Annotations.DESCRIPTION).orElse(null);
            enumType.addValue(new EnumValue(description, field.name()));
        }
        return enumType;
    }
}

