/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.graphql.schema.helper;

import io.smallrye.graphql.schema.Annotations;
import io.smallrye.graphql.schema.Classes;
import io.smallrye.graphql.schema.model.DirectiveArgument;
import io.smallrye.graphql.schema.model.DirectiveInstance;
import io.smallrye.graphql.schema.model.DirectiveType;
import io.smallrye.graphql.schema.model.Reference;
import io.smallrye.graphql.schema.model.ReferenceType;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.DotName;

public class BeanValidationDirectivesHelper {
    public static final DirectiveType CONSTRAINT_DIRECTIVE_TYPE = new DirectiveType();

    private static void addArgument(String name, Reference reference) {
        DirectiveArgument arg = new DirectiveArgument();
        arg.setName(name);
        arg.setReference(reference);
        CONSTRAINT_DIRECTIVE_TYPE.addArgumentType(arg);
    }

    public List<DirectiveInstance> transformBeanValidationConstraintsToDirectives(Annotations annotations) {
        ArrayList<DirectiveInstance> result = new ArrayList<DirectiveInstance>();
        Set<DotName> annotationNames = annotations.getAnnotationNames();
        for (DotName annotationName : annotationNames) {
            DirectiveInstance directive;
            if (annotationName.equals((Object)Classes.JAKARTA_VALIDATION_ANNOTATION_SIZE) || annotationName.equals((Object)Classes.JAVAX_VALIDATION_ANNOTATION_SIZE)) {
                Integer max;
                directive = new DirectiveInstance();
                directive.setType(CONSTRAINT_DIRECTIVE_TYPE);
                Integer min = this.getIntValue(annotations, annotationName, "min");
                if (min != null) {
                    directive.setValue("minLength", (Object)min);
                }
                if ((max = this.getIntValue(annotations, annotationName, "max")) != null) {
                    directive.setValue("maxLength", (Object)max);
                }
                result.add(directive);
            }
            if (annotationName.equals((Object)Classes.JAKARTA_VALIDATION_ANNOTATION_EMAIL) || annotationName.equals((Object)Classes.JAVAX_VALIDATION_ANNOTATION_EMAIL)) {
                directive = new DirectiveInstance();
                directive.setType(CONSTRAINT_DIRECTIVE_TYPE);
                directive.setValue("format", (Object)"email");
                result.add(directive);
            }
            if (annotationName.equals((Object)Classes.JAKARTA_VALIDATION_ANNOTATION_MAX) || annotationName.equals((Object)Classes.JAVAX_VALIDATION_ANNOTATION_MAX)) {
                directive = new DirectiveInstance();
                directive.setType(CONSTRAINT_DIRECTIVE_TYPE);
                directive.setValue("max", (Object)this.getLongValue(annotations, annotationName, "value"));
                result.add(directive);
            }
            if (annotationName.equals((Object)Classes.JAKARTA_VALIDATION_ANNOTATION_MIN) || annotationName.equals((Object)Classes.JAVAX_VALIDATION_ANNOTATION_MIN)) {
                directive = new DirectiveInstance();
                directive.setType(CONSTRAINT_DIRECTIVE_TYPE);
                directive.setValue("min", (Object)this.getLongValue(annotations, annotationName, "value"));
                result.add(directive);
            }
            if (!annotationName.equals((Object)Classes.JAKARTA_VALIDATION_ANNOTATION_PATTERN) && !annotationName.equals((Object)Classes.JAVAX_VALIDATION_ANNOTATION_PATTERN)) continue;
            directive = new DirectiveInstance();
            directive.setType(CONSTRAINT_DIRECTIVE_TYPE);
            directive.setValue("pattern", (Object)this.getStringValue(annotations, annotationName, "regexp"));
            result.add(directive);
        }
        return result;
    }

    private String getStringValue(Annotations annotations, DotName annotationName, String parameterName) {
        AnnotationValue aValue = annotations.getAnnotationValue(annotationName, parameterName);
        return aValue != null ? aValue.asString() : null;
    }

    private Integer getIntValue(Annotations annotations, DotName annotationName, String parameterName) {
        AnnotationValue aValue = annotations.getAnnotationValue(annotationName, parameterName);
        return aValue != null ? Integer.valueOf(aValue.asInt()) : null;
    }

    private Long getLongValue(Annotations annotations, DotName annotationName, String parameterName) {
        AnnotationValue aValue = annotations.getAnnotationValue(annotationName, parameterName);
        return aValue != null ? Long.valueOf(aValue.asLong()) : null;
    }

    static {
        CONSTRAINT_DIRECTIVE_TYPE.setName("constraint");
        LinkedHashSet<String> locations = new LinkedHashSet<String>();
        locations.add("INPUT_FIELD_DEFINITION");
        locations.add("ARGUMENT_DEFINITION");
        CONSTRAINT_DIRECTIVE_TYPE.setLocations(locations);
        CONSTRAINT_DIRECTIVE_TYPE.setDescription("Indicates a Bean Validation constraint");
        CONSTRAINT_DIRECTIVE_TYPE.setRepeatable(true);
        Reference INTEGER = new Reference();
        INTEGER.setType(ReferenceType.SCALAR);
        INTEGER.setClassName("java.lang.Integer");
        INTEGER.setGraphQlClassName("Int");
        INTEGER.setName("Int");
        Reference LONG = new Reference();
        LONG.setType(ReferenceType.SCALAR);
        LONG.setClassName("java.lang.Long");
        LONG.setGraphQlClassName("BigInteger");
        LONG.setName("BigInteger");
        Reference STRING = new Reference();
        STRING.setType(ReferenceType.SCALAR);
        STRING.setClassName("java.lang.String");
        STRING.setGraphQlClassName("String");
        STRING.setName("String");
        BeanValidationDirectivesHelper.addArgument("minLength", INTEGER);
        BeanValidationDirectivesHelper.addArgument("maxLength", INTEGER);
        BeanValidationDirectivesHelper.addArgument("format", STRING);
        BeanValidationDirectivesHelper.addArgument("min", LONG);
        BeanValidationDirectivesHelper.addArgument("max", LONG);
        BeanValidationDirectivesHelper.addArgument("pattern", STRING);
    }
}

