/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.graphql.schema.helper;

import io.smallrye.graphql.schema.Annotations;
import io.smallrye.graphql.schema.ScanningContext;
import io.smallrye.graphql.schema.model.AdaptTo;
import io.smallrye.graphql.schema.model.Field;
import io.smallrye.graphql.schema.model.Reference;
import io.smallrye.graphql.schema.model.ReferenceType;
import io.smallrye.graphql.schema.model.Scalars;
import java.util.Optional;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.Type;

public class AdaptToHelper {
    private static final String CONTRUCTOR_METHOD_NAME = "<init>";
    private static final String SET_VALUE_METHOD_NAME = "setValue";
    private static final String GET_INSTANCE_METHOD_NAME = "getInstance";
    private static final String FROM = "from";
    private static final String SERIALIZE_METHOD = "serializeMethod";
    private static final String DESERIALIZE_METHOD = "deserializeMethod";

    private AdaptToHelper() {
    }

    public static boolean shouldCreateTypeInSchema(Annotations annotations) {
        return !AdaptToHelper.hasAnyAdaptToAnnotations(annotations);
    }

    public static Optional<AdaptTo> getAdaptTo(Field field, Annotations annotations) {
        return AdaptToHelper.getAdaptTo(field.getReference(), annotations);
    }

    public static Optional<AdaptTo> getAdaptTo(Reference r, Annotations annotations) {
        Type type = AdaptToHelper.getAdaptTo(annotations);
        if (type != null) {
            String scalarName = AdaptToHelper.getScalarName(type);
            Reference reference = Scalars.getScalar((String)scalarName);
            AdaptTo adaptTo = new AdaptTo(reference);
            String deserializeMethod = AdaptToHelper.getDeserializeMethod(annotations);
            if (deserializeMethod != null) {
                adaptTo.setDeserializeMethod(deserializeMethod);
            } else {
                ClassInfo classInfo;
                String className = r.getClassName();
                if (!r.getType().equals((Object)ReferenceType.SCALAR) && (classInfo = ScanningContext.getIndex().getClassByName(DotName.createSimple((String)className))) != null) {
                    Type parameter = Type.create((DotName)DotName.createSimple((String)reference.getClassName()), (Type.Kind)Type.Kind.CLASS);
                    MethodInfo constructor = classInfo.method(CONTRUCTOR_METHOD_NAME, new Type[]{parameter});
                    if (constructor != null) {
                        adaptTo.setDeserializeMethod(CONTRUCTOR_METHOD_NAME);
                    } else {
                        MethodInfo setValueMethod = classInfo.method(SET_VALUE_METHOD_NAME, new Type[]{parameter});
                        if (setValueMethod != null) {
                            adaptTo.setDeserializeMethod(SET_VALUE_METHOD_NAME);
                        } else {
                            String staticFromMethodName = FROM + scalarName;
                            MethodInfo staticFromMethod = classInfo.method(staticFromMethodName, new Type[]{parameter});
                            if (staticFromMethod != null) {
                                adaptTo.setDeserializeMethod(staticFromMethodName);
                            } else {
                                MethodInfo staticGetInstance = classInfo.method(GET_INSTANCE_METHOD_NAME, new Type[]{parameter});
                                if (staticGetInstance != null) {
                                    adaptTo.setDeserializeMethod(GET_INSTANCE_METHOD_NAME);
                                }
                            }
                        }
                    }
                }
            }
            String serializeMethod = AdaptToHelper.getSerializeMethod(annotations);
            if (serializeMethod != null) {
                adaptTo.setSerializeMethod(serializeMethod);
            }
            return Optional.of(adaptTo);
        }
        return Optional.empty();
    }

    private static boolean hasAnyAdaptToAnnotations(Annotations annotations) {
        Type type = AdaptToHelper.getAdaptTo(annotations);
        return type != null;
    }

    private static Type getAdaptTo(Annotations annotations) {
        if (annotations != null) {
            AnnotationValue annotationValue;
            if (annotations.containsOneOfTheseAnnotations(Annotations.ADAPT_TO_SCALAR) && (annotationValue = annotations.getAnnotationValue(Annotations.ADAPT_TO_SCALAR)) != null) {
                return annotationValue.asClass();
            }
            if (annotations.containsOneOfTheseAnnotations(Annotations.TO_SCALAR) && (annotationValue = annotations.getAnnotationValue(Annotations.TO_SCALAR)) != null) {
                return annotationValue.asClass();
            }
        }
        return null;
    }

    private static String getSerializeMethod(Annotations annotations) {
        return AdaptToHelper.getAnnotationParameterAsString(annotations, SERIALIZE_METHOD);
    }

    private static String getDeserializeMethod(Annotations annotations) {
        return AdaptToHelper.getAnnotationParameterAsString(annotations, DESERIALIZE_METHOD);
    }

    private static String getAnnotationParameterAsString(Annotations annotations, String param) {
        if (annotations != null) {
            String value;
            AnnotationValue annotationValue;
            if (annotations.containsOneOfTheseAnnotations(Annotations.ADAPT_TO_SCALAR) && (annotationValue = annotations.getAnnotationValue(Annotations.ADAPT_TO_SCALAR, param)) != null && (value = annotationValue.asString()) != null && !value.isEmpty()) {
                return value;
            }
            if (annotations.containsOneOfTheseAnnotations(Annotations.TO_SCALAR) && (annotationValue = annotations.getAnnotationValue(Annotations.TO_SCALAR, param)) != null && (value = annotationValue.asString()) != null && !value.isEmpty()) {
                return value;
            }
        }
        return null;
    }

    private static String getScalarName(Type type) {
        String className = type.name().withoutPackagePrefix();
        if (className.contains("$")) {
            return className.substring(className.lastIndexOf("$") + 1);
        }
        return className;
    }
}

