/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.graphql.schema.helper;

import io.smallrye.graphql.schema.Annotations;
import io.smallrye.graphql.schema.model.Group;
import java.util.List;
import java.util.Optional;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;

public class GroupHelper {
    private GroupHelper() {
    }

    public static Optional<Group> getGroup(AnnotationInstance graphQLApiAnnotation) {
        Optional<String> name = GroupHelper.getName(graphQLApiAnnotation);
        if (name.isPresent()) {
            Optional<String> description = GroupHelper.getDescription(graphQLApiAnnotation);
            Group group = new Group();
            group.setName(name.get());
            group.setDescription((String)description.orElse(null));
            return Optional.of(group);
        }
        return Optional.empty();
    }

    private static Optional<String> getName(AnnotationInstance graphQLApiAnnotation) {
        AnnotationValue value = graphQLApiAnnotation.value();
        if (value != null && value.asString() != null && !value.asString().isEmpty()) {
            return Optional.of(value.asString());
        }
        ClassInfo apiClass = graphQLApiAnnotation.target().asClass();
        AnnotationInstance nameAnnotation = apiClass.classAnnotation(Annotations.NAME);
        if (nameAnnotation != null && nameAnnotation.value() != null && nameAnnotation.value().asString() != null && !nameAnnotation.value().asString().isEmpty()) {
            return Optional.of(nameAnnotation.value().asString());
        }
        return Optional.empty();
    }

    private static Optional<String> getDescription(AnnotationInstance graphQLApiAnnotation) {
        AnnotationValue value;
        List descriptionAnnotations;
        ClassInfo apiClass = graphQLApiAnnotation.target().asClass();
        if (apiClass.annotationsMap().containsKey(Annotations.DESCRIPTION) && (descriptionAnnotations = (List)apiClass.annotationsMap().get(Annotations.DESCRIPTION)) != null && !descriptionAnnotations.isEmpty() && (value = ((AnnotationInstance)descriptionAnnotations.get(0)).value()) != null && value.asString() != null && !value.asString().isEmpty()) {
            return Optional.of(value.asString());
        }
        return Optional.empty();
    }
}

