/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.graphql.schema.creator;

import io.smallrye.graphql.schema.Annotations;
import io.smallrye.graphql.schema.SchemaBuilderException;
import io.smallrye.graphql.schema.creator.ArgumentCreator;
import io.smallrye.graphql.schema.creator.ModelCreator;
import io.smallrye.graphql.schema.creator.ReferenceCreator;
import io.smallrye.graphql.schema.helper.Direction;
import io.smallrye.graphql.schema.helper.MethodHelper;
import io.smallrye.graphql.schema.model.Argument;
import io.smallrye.graphql.schema.model.Execute;
import io.smallrye.graphql.schema.model.Field;
import io.smallrye.graphql.schema.model.Operation;
import io.smallrye.graphql.schema.model.OperationType;
import io.smallrye.graphql.schema.model.Reference;
import io.smallrye.graphql.schema.model.Type;
import java.lang.reflect.Modifier;
import java.util.List;
import java.util.Optional;
import org.jboss.jandex.DotName;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.Type;

public class OperationCreator
extends ModelCreator {
    private final ArgumentCreator argumentCreator;

    public OperationCreator(ReferenceCreator referenceCreator, ArgumentCreator argumentCreator) {
        super(referenceCreator);
        this.argumentCreator = argumentCreator;
    }

    public Operation createOperation(MethodInfo methodInfo, OperationType operationType, Type type) {
        if (!Modifier.isPublic(methodInfo.flags())) {
            throw new IllegalArgumentException("Method " + methodInfo.declaringClass().name().toString() + "#" + methodInfo.name() + " is used as an operation, but is not public");
        }
        Annotations annotationsForMethod = Annotations.getAnnotationsForMethod(methodInfo);
        Annotations annotationsForClass = Annotations.getAnnotationsForClass(methodInfo.declaringClass());
        org.jboss.jandex.Type fieldType = OperationCreator.getReturnType(methodInfo);
        String name = OperationCreator.getOperationName(methodInfo, operationType, annotationsForMethod);
        OperationCreator.validateFieldType(methodInfo, operationType);
        Execute execute = this.getExecution(annotationsForMethod, annotationsForClass);
        Reference reference = this.referenceCreator.createReferenceForOperationField(fieldType, annotationsForMethod);
        Operation operation = new Operation(methodInfo.declaringClass().name().toString(), methodInfo.name(), MethodHelper.getPropertyName(Direction.OUT, methodInfo.name()), name, reference, operationType, execute);
        if (type != null) {
            operation.setSourceFieldOn(new Reference.Builder().reference((Reference)type).build());
        }
        List parameters = methodInfo.parameterTypes();
        for (short i = 0; i < parameters.size(); i = (short)(i + 1)) {
            Optional<Argument> maybeArgument = this.argumentCreator.createArgument(operation, methodInfo, i);
            maybeArgument.ifPresent(arg_0 -> ((Operation)operation).addArgument(arg_0));
        }
        this.populateField(Direction.OUT, (Field)operation, fieldType, annotationsForMethod);
        return operation;
    }

    private static void validateFieldType(MethodInfo methodInfo, OperationType operationType) {
        org.jboss.jandex.Type returnType = methodInfo.returnType();
        if (returnType.kind().equals((Object)Type.Kind.VOID)) {
            throw new SchemaBuilderException("Can not have a void return for [" + operationType.name() + "] on method [" + methodInfo.name() + "]");
        }
    }

    private static String getOperationName(MethodInfo methodInfo, OperationType operationType, Annotations annotations) {
        DotName operationAnnotation = OperationCreator.getOperationAnnotation(operationType);
        return annotations.getOneOfTheseMethodAnnotationsValue(operationAnnotation, Annotations.NAME, Annotations.JSONB_PROPERTY, Annotations.JACKSON_PROPERTY).orElse(OperationCreator.getDefaultExecutionTypeName(methodInfo, operationType));
    }

    private static DotName getOperationAnnotation(OperationType operationType) {
        switch (operationType) {
            case QUERY: {
                return Annotations.QUERY;
            }
            case MUTATION: {
                return Annotations.MUTATION;
            }
            case SUBSCRIPTION: {
                return Annotations.SUBCRIPTION;
            }
        }
        return null;
    }

    private static String getDefaultExecutionTypeName(MethodInfo methodInfo, OperationType operationType) {
        String methodName = methodInfo.name();
        if (operationType.equals((Object)OperationType.QUERY) || operationType.equals((Object)OperationType.SUBSCRIPTION)) {
            methodName = MethodHelper.getPropertyName(Direction.OUT, methodName);
        } else if (operationType.equals((Object)OperationType.MUTATION)) {
            methodName = MethodHelper.getPropertyName(Direction.IN, methodName);
        }
        return methodName;
    }

    private Execute getExecution(Annotations annotationsForMethod, Annotations annotationsForClass) {
        if (annotationsForMethod.containsOneOfTheseAnnotations(Annotations.BLOCKING)) {
            return Execute.BLOCKING;
        }
        if (annotationsForMethod.containsOneOfTheseAnnotations(Annotations.NON_BLOCKING)) {
            return Execute.NON_BLOCKING;
        }
        if (annotationsForClass.containsOneOfTheseAnnotations(Annotations.BLOCKING)) {
            return Execute.BLOCKING;
        }
        if (annotationsForClass.containsOneOfTheseAnnotations(Annotations.NON_BLOCKING)) {
            return Execute.NON_BLOCKING;
        }
        return Execute.DEFAULT;
    }
}

