/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.graphql.schema.helper;

import io.smallrye.graphql.schema.Annotations;
import io.smallrye.graphql.schema.Classes;
import io.smallrye.graphql.schema.ScanningContext;
import io.smallrye.graphql.schema.creator.ReferenceCreator;
import io.smallrye.graphql.schema.creator.WrapperCreator;
import io.smallrye.graphql.schema.helper.Direction;
import io.smallrye.graphql.schema.model.AdaptWith;
import io.smallrye.graphql.schema.model.Field;
import io.smallrye.graphql.schema.model.Reference;
import io.smallrye.graphql.schema.model.Scalars;
import io.smallrye.graphql.schema.model.Wrapper;
import java.util.List;
import java.util.Optional;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.ParameterizedType;
import org.jboss.jandex.Type;

public class AdaptWithHelper {
    private AdaptWithHelper() {
    }

    public static boolean shouldCreateTypeInSchema(Annotations annotations) {
        return !AdaptWithHelper.hasAnyAdaptWithAnnotations(annotations);
    }

    public static Optional<AdaptWith> getAdaptWith(Direction direction, ReferenceCreator referenceCreator, Field field, Annotations annotations) {
        return AdaptWithHelper.getAdaptWith(direction, referenceCreator, field.getReference(), annotations);
    }

    public static Optional<AdaptWith> getAdaptWith(Direction direction, ReferenceCreator referenceCreator, Reference r, Annotations annotations, AdapterType adapterType) {
        if (adapterType != null) {
            Type type = adapterType.type;
            AdaptWith adaptWith = adapterType.adaptWith;
            if (type.kind().equals((Object)Type.Kind.CLASS)) {
                ClassInfo classInfo = ScanningContext.getIndex().getClassByName(type.name());
                List interfaceTypes = classInfo.interfaceTypes();
                for (Type interfaceType : interfaceTypes) {
                    ParameterizedType adapterInterface;
                    List arguments;
                    if (!interfaceType.name().toString().equals(adaptWith.getAdapterInterface()) || !interfaceType.kind().equals((Object)Type.Kind.PARAMETERIZED_TYPE) || (arguments = (adapterInterface = interfaceType.asParameterizedType()).arguments()).size() != 2) continue;
                    Type from = (Type)arguments.get(0);
                    Type to = (Type)arguments.get(1);
                    adaptWith.setAdapterClass(type.name().toString());
                    r.setWrapper((Wrapper)WrapperCreator.createWrapper(from).orElse(null));
                    adaptWith.setFromReference(r);
                    if (Scalars.isScalar((String)to.name().toString())) {
                        adaptWith.setToReference(Scalars.getScalar((String)to.name().toString()));
                    } else {
                        Annotations annotationsAplicableToMe = annotations.removeAnnotations(Annotations.ADAPT_WITH, Annotations.JSONB_TYPE_ADAPTER);
                        Reference toRef = referenceCreator.createReferenceForAdapter(to, annotationsAplicableToMe, direction);
                        toRef.setWrapper((Wrapper)WrapperCreator.createWrapper(to).orElse(null));
                        adaptWith.setToReference(toRef);
                    }
                    return Optional.of(adaptWith);
                }
            }
        }
        return Optional.empty();
    }

    public static Optional<AdaptWith> getAdaptWith(Direction direction, ReferenceCreator referenceCreator, Reference r, Annotations annotations) {
        AdapterType adapterType = AdaptWithHelper.getAdapterType(annotations);
        return AdaptWithHelper.getAdaptWith(direction, referenceCreator, r, annotations, adapterType);
    }

    private static AdapterType getAdapterType(Annotations annotations) {
        if (annotations != null) {
            AnnotationValue annotationValue;
            if (annotations.containsOneOfTheseAnnotations(Annotations.ADAPT_WITH) && (annotationValue = annotations.getAnnotationValue(Annotations.ADAPT_WITH)) != null) {
                AdaptWith adaptWith = new AdaptWith(Classes.ADAPTER.toString(), "from", "to");
                Type type = annotationValue.asClass();
                return new AdapterType(type, adaptWith);
            }
            if (annotations.containsOneOfTheseAnnotations(Annotations.JSONB_TYPE_ADAPTER) && (annotationValue = annotations.getAnnotationValue(Annotations.JSONB_TYPE_ADAPTER)) != null) {
                AdaptWith adaptWith = new AdaptWith(Classes.JSONB_ADAPTER.toString(), "adaptFromJson", "adaptToJson");
                Type type = annotationValue.asClass();
                return new AdapterType(type, adaptWith);
            }
        }
        return null;
    }

    private static boolean hasAnyAdaptWithAnnotations(Annotations annotations) {
        AdapterType adapterType = AdaptWithHelper.getAdapterType(annotations);
        return adapterType != null && adapterType.type != null;
    }

    private static class AdapterType {
        Type type;
        AdaptWith adaptWith;

        public AdapterType(Type type, AdaptWith adaptWith) {
            this.type = type;
            this.adaptWith = adaptWith;
        }
    }
}

