/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.graphql.schema.helper;

import io.smallrye.graphql.schema.Annotations;
import java.lang.reflect.Modifier;
import org.jboss.jandex.FieldInfo;

public class IgnoreHelper {
    private IgnoreHelper() {
    }

    public static boolean shouldIgnore(Annotations annotations) {
        return IgnoreHelper.shouldIgnore(annotations, null);
    }

    public static boolean shouldIgnore(Annotations annotations, FieldInfo fieldInfo) {
        return IgnoreHelper.checkAnnotations(annotations) || IgnoreHelper.checkTransient(fieldInfo);
    }

    private static boolean checkAnnotations(Annotations annotations) {
        return annotations.containsOneOfTheseAnnotations(Annotations.IGNORE, Annotations.JSONB_TRANSIENT, Annotations.JACKSON_IGNORE);
    }

    private static boolean checkTransient(FieldInfo fieldInfo) {
        if (fieldInfo == null) {
            return false;
        }
        return Modifier.isTransient(fieldInfo.flags());
    }
}

