/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.graphql.schema.creator;

import io.smallrye.graphql.schema.Annotations;
import io.smallrye.graphql.schema.Classes;
import io.smallrye.graphql.schema.ScanningContext;
import io.smallrye.graphql.schema.SchemaBuilderException;
import io.smallrye.graphql.schema.helper.AdaptToHelper;
import io.smallrye.graphql.schema.helper.AdaptWithHelper;
import io.smallrye.graphql.schema.helper.Direction;
import io.smallrye.graphql.schema.helper.FormatHelper;
import io.smallrye.graphql.schema.helper.TypeAutoNameStrategy;
import io.smallrye.graphql.schema.helper.TypeNameHelper;
import io.smallrye.graphql.schema.model.AdaptTo;
import io.smallrye.graphql.schema.model.AdaptWith;
import io.smallrye.graphql.schema.model.Reference;
import io.smallrye.graphql.schema.model.ReferenceType;
import io.smallrye.graphql.schema.model.Scalars;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Queue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.ParameterizedType;
import org.jboss.jandex.Type;
import org.jboss.jandex.TypeVariable;
import org.jboss.logging.Logger;

public class ReferenceCreator {
    private static final Logger LOG = Logger.getLogger((String)ReferenceCreator.class.getName());
    private final Queue<Reference> inputReferenceQueue = new ArrayDeque<Reference>();
    private final Queue<Reference> typeReferenceQueue = new ArrayDeque<Reference>();
    private final Queue<Reference> enumReferenceQueue = new ArrayDeque<Reference>();
    private final Queue<Reference> interfaceReferenceQueue = new ArrayDeque<Reference>();
    private final Map<String, Reference> inputReferenceMap = new HashMap<String, Reference>();
    private final Map<String, Reference> typeReferenceMap = new HashMap<String, Reference>();
    private final Map<String, Reference> enumReferenceMap = new HashMap<String, Reference>();
    private final Map<String, Reference> interfaceReferenceMap = new HashMap<String, Reference>();
    private final TypeAutoNameStrategy autoNameStrategy;

    public ReferenceCreator(TypeAutoNameStrategy autoNameStrategy) {
        this.autoNameStrategy = autoNameStrategy;
    }

    public void clear() {
        this.inputReferenceMap.clear();
        this.typeReferenceMap.clear();
        this.enumReferenceMap.clear();
        this.interfaceReferenceMap.clear();
        this.inputReferenceQueue.clear();
        this.typeReferenceQueue.clear();
        this.enumReferenceQueue.clear();
        this.interfaceReferenceQueue.clear();
    }

    public Queue<Reference> values(ReferenceType referenceType) {
        return this.getReferenceQueue(referenceType);
    }

    public Reference createReferenceForAdapter(Direction direction, Type fieldType, Annotations annotations) {
        return this.getReference(direction, null, fieldType, annotations);
    }

    public Reference createReferenceForOperationField(Type fieldType, Annotations annotationsForMethod) {
        return this.getReference(Direction.OUT, null, fieldType, annotationsForMethod);
    }

    public Reference createReferenceForOperationArgument(Type argumentType, Annotations annotationsForThisArgument) {
        return this.getReference(Direction.IN, null, argumentType, annotationsForThisArgument);
    }

    public Reference createReferenceForSourceArgument(Type argumentType, Annotations annotationsForThisArgument) {
        return this.getReference(Direction.OUT, null, argumentType, annotationsForThisArgument);
    }

    public Reference createReferenceForInterfaceField(Type methodType, Annotations annotationsForThisMethod, Reference parentObjectReference) {
        return this.getReference(Direction.OUT, null, methodType, annotationsForThisMethod, parentObjectReference);
    }

    public Reference createReferenceForPojoField(Direction direction, Type fieldType, Type methodType, Annotations annotations, Reference parentObjectReference) {
        return this.getReference(direction, fieldType, methodType, annotations, parentObjectReference);
    }

    public Reference createReference(Direction direction, ClassInfo classInfo) {
        return this.createReference(direction, classInfo, true, true, null, null, true);
    }

    public Reference createReference(Direction direction, ClassInfo classInfo, boolean createAdapedToType, boolean createAdapedWithType, Reference parentObjectReference, Map<String, Reference> parametrizedTypeArgumentsReferences, boolean addParametrizedTypeNameExtension) {
        ReferenceType referenceType = ReferenceCreator.getCorrectReferenceType(direction);
        Annotations annotationsForClass = Annotations.getAnnotationsForClass(classInfo);
        if (this.isInterface(classInfo, annotationsForClass)) {
            Collection knownDirectImplementors = ScanningContext.getIndex().getAllKnownImplementors(classInfo.name());
            for (ClassInfo impl : knownDirectImplementors) {
                HashMap<String, Reference> parametrizedTypeArgumentsReferencesImpl = null;
                if (!classInfo.typeParameters().isEmpty()) {
                    Object it2;
                    ParameterizedType interfaceType = null;
                    for (Object it2 : impl.interfaceTypes()) {
                        if (!it2.name().equals((Object)classInfo.name())) continue;
                        interfaceType = it2.asParameterizedType();
                    }
                    parametrizedTypeArgumentsReferencesImpl = new HashMap<String, Reference>();
                    int i = 0;
                    it2 = classInfo.typeParameters().iterator();
                    while (it2.hasNext()) {
                        TypeVariable tp = (TypeVariable)it2.next();
                        Type type = (Type)interfaceType.arguments().get(i++);
                        if (type.kind() != Type.Kind.TYPE_VARIABLE) continue;
                        parametrizedTypeArgumentsReferencesImpl.put(type.asTypeVariable().identifier(), parametrizedTypeArgumentsReferences.get(tp.identifier()));
                    }
                }
                this.createReference(direction, impl, createAdapedToType, createAdapedWithType, parentObjectReference, parametrizedTypeArgumentsReferencesImpl, true);
            }
            referenceType = ReferenceType.INTERFACE;
        } else if (Classes.isEnum(classInfo)) {
            referenceType = ReferenceType.ENUM;
        }
        String className = classInfo.name().toString();
        String name = TypeNameHelper.getAnyTypeName(addParametrizedTypeNameExtension ? TypeNameHelper.createParametrizedTypeNameExtension(parametrizedTypeArgumentsReferences) : null, referenceType, classInfo, annotationsForClass, this.autoNameStrategy);
        Reference reference = new Reference(className, name, referenceType, parametrizedTypeArgumentsReferences, addParametrizedTypeNameExtension);
        boolean shouldCreateAdapedToType = AdaptToHelper.shouldCreateTypeInSchema(annotationsForClass);
        Optional<AdaptTo> adaptTo = AdaptToHelper.getAdaptTo(reference, annotationsForClass);
        reference.setAdaptTo((AdaptTo)adaptTo.orElse(null));
        if (shouldCreateAdapedToType && createAdapedToType) {
            this.putIfAbsent(name, reference, referenceType);
        }
        boolean shouldCreateAdapedWithType = AdaptWithHelper.shouldCreateTypeInSchema(annotationsForClass);
        Optional<AdaptWith> adaptWith = AdaptWithHelper.getAdaptWith(direction, this, reference, annotationsForClass);
        reference.setAdaptWith((AdaptWith)adaptWith.orElse(null));
        if (shouldCreateAdapedWithType && createAdapedWithType) {
            this.putIfAbsent(name, reference, referenceType);
        }
        return reference;
    }

    public TypeAutoNameStrategy getTypeAutoNameStrategy() {
        return this.autoNameStrategy;
    }

    private boolean isInterface(ClassInfo classInfo, Annotations annotationsForClass) {
        boolean isJavaInterface = Classes.isInterface(classInfo);
        if (isJavaInterface) {
            return !annotationsForClass.containsOneOfTheseAnnotations(Annotations.TYPE, Annotations.INPUT);
        }
        return false;
    }

    private Reference getReference(Direction direction, Type fieldType, Type methodType, Annotations annotations) {
        return this.getReference(direction, fieldType, methodType, annotations, null);
    }

    private Reference getReference(Direction direction, Type fieldType, Type methodType, Annotations annotations, Reference parentObjectReference) {
        if (fieldType == null) {
            fieldType = methodType;
        }
        String fieldTypeName = fieldType.name().toString();
        if (annotations != null && annotations.containsOneOfTheseAnnotations(Annotations.ID)) {
            return Scalars.getIDScalar((String)fieldTypeName);
        }
        if (Scalars.isScalar((String)fieldTypeName)) {
            if (FormatHelper.hasAnyFormatting(annotations)) {
                return Scalars.getFormattedScalar((String)fieldTypeName);
            }
            return Scalars.getScalar((String)fieldTypeName);
        }
        if (fieldType.kind().equals((Object)Type.Kind.ARRAY)) {
            Type typeInArray = fieldType.asArrayType().component();
            Type typeInMethodArray = methodType.asArrayType().component();
            return this.getReference(direction, typeInArray, typeInMethodArray, annotations, parentObjectReference);
        }
        if (Classes.isCollection(fieldType) || Classes.isUnwrappedType(fieldType)) {
            Type typeInCollection = (Type)fieldType.asParameterizedType().arguments().get(0);
            Type typeInMethodCollection = (Type)methodType.asParameterizedType().arguments().get(0);
            return this.getReference(direction, typeInCollection, typeInMethodCollection, annotations, parentObjectReference);
        }
        if (Classes.isMap(fieldType)) {
            ParameterizedType parameterizedFieldType = fieldType.asParameterizedType();
            List fieldArguments = parameterizedFieldType.arguments();
            ParameterizedType entryType = ParameterizedType.create((DotName)Classes.ENTRY, (Type[])fieldArguments.toArray(new Type[0]), null);
            return this.getReference(direction, (Type)entryType, (Type)entryType, annotations, parentObjectReference);
        }
        if (fieldType.kind().equals((Object)Type.Kind.CLASS)) {
            ClassInfo classInfo = ScanningContext.getIndex().getClassByName(fieldType.name());
            if (classInfo != null) {
                Map<String, Reference> parametrizedTypeArgumentsReferences = null;
                ParameterizedType parametrizedParentType = this.findParametrizedParentType(classInfo);
                if (parametrizedParentType != null) {
                    ClassInfo ci = ScanningContext.getIndex().getClassByName(parametrizedParentType.name());
                    if (ci == null) {
                        throw new SchemaBuilderException("No class info found for parametrizedParentType name [" + parametrizedParentType.name() + "]");
                    }
                    parametrizedTypeArgumentsReferences = this.collectParametrizedTypes(ci, parametrizedParentType.arguments(), direction, parentObjectReference);
                }
                boolean shouldCreateAdapedToType = AdaptToHelper.shouldCreateTypeInSchema(annotations);
                boolean shouldCreateAdapedWithType = AdaptWithHelper.shouldCreateTypeInSchema(annotations);
                return this.createReference(direction, classInfo, shouldCreateAdapedToType, shouldCreateAdapedWithType, parentObjectReference, parametrizedTypeArgumentsReferences, false);
            }
            return this.getNonIndexedReference(direction, fieldType);
        }
        if (fieldType.kind().equals((Object)Type.Kind.PARAMETERIZED_TYPE)) {
            ClassInfo classInfo = ScanningContext.getIndex().getClassByName(fieldType.name());
            if (classInfo != null) {
                List parametrizedTypeArguments = fieldType.asParameterizedType().arguments();
                Map<String, Reference> parametrizedTypeArgumentsReferences = this.collectParametrizedTypes(classInfo, parametrizedTypeArguments, direction, parentObjectReference);
                boolean shouldCreateAdapedToType = AdaptToHelper.shouldCreateTypeInSchema(annotations);
                boolean shouldCreateAdapedWithType = AdaptWithHelper.shouldCreateTypeInSchema(annotations);
                return this.createReference(direction, classInfo, shouldCreateAdapedToType, shouldCreateAdapedWithType, parentObjectReference, parametrizedTypeArgumentsReferences, true);
            }
            return this.getNonIndexedReference(direction, fieldType);
        }
        if (fieldType.kind().equals((Object)Type.Kind.TYPE_VARIABLE)) {
            if (parentObjectReference == null || parentObjectReference.getParametrizedTypeArguments() == null) {
                throw new SchemaBuilderException("Don't know what to do with [" + fieldType + "] of kind [" + fieldType.kind() + "] as parent object reference is missing or incomplete: " + parentObjectReference);
            }
            LOG.debug((Object)("Type variable: " + fieldType.asTypeVariable().name() + " identifier: " + fieldType.asTypeVariable().identifier()));
            Reference ret = (Reference)parentObjectReference.getParametrizedTypeArguments().get(fieldType.asTypeVariable().identifier());
            if (ret == null) {
                throw new SchemaBuilderException("Don't know what to do with [" + fieldType + "] of kind [" + fieldType.kind() + "] as parent object reference doesn't contain necessary info: " + parentObjectReference);
            }
            return ret;
        }
        throw new SchemaBuilderException("Don't know what to do with [" + fieldType + "] of kind [" + fieldType.kind() + "]");
    }

    public Map<String, Reference> collectParametrizedTypes(ClassInfo classInfo, List<? extends Type> parametrizedTypeArguments, Direction direction, Reference parentObjectReference) {
        LinkedHashMap<String, Reference> parametrizedTypeArgumentsReferences = null;
        if (parametrizedTypeArguments != null) {
            ArrayList<TypeVariable> tvl = new ArrayList<TypeVariable>();
            this.collectTypeVariables(tvl, classInfo);
            parametrizedTypeArgumentsReferences = new LinkedHashMap<String, Reference>();
            int i = 0;
            for (Type type : parametrizedTypeArguments) {
                if (i >= tvl.size()) {
                    throw new SchemaBuilderException("List of type variables is not correct for class " + classInfo + " and generics argument " + type);
                }
                parametrizedTypeArgumentsReferences.put(((TypeVariable)tvl.get(i++)).identifier(), this.getReference(direction, type, null, null, parentObjectReference));
            }
        }
        return parametrizedTypeArgumentsReferences;
    }

    private void collectTypeVariables(List<TypeVariable> tvl, ClassInfo classInfo) {
        if (classInfo == null) {
            return;
        }
        if (classInfo.typeParameters() != null) {
            tvl.addAll(classInfo.typeParameters());
        }
        if (classInfo.superClassType() != null) {
            this.collectTypeVariables(tvl, ScanningContext.getIndex().getClassByName(classInfo.superName()));
        }
    }

    public ParameterizedType findParametrizedParentType(ClassInfo classInfo) {
        if (classInfo != null && classInfo.superClassType() != null && !Classes.isEnum(classInfo)) {
            if (classInfo.superClassType().kind().equals((Object)Type.Kind.PARAMETERIZED_TYPE)) {
                return classInfo.superClassType().asParameterizedType();
            }
            return this.findParametrizedParentType(ScanningContext.getIndex().getClassByName(classInfo.superName()));
        }
        return null;
    }

    private void putIfAbsent(String key, Reference reference, ReferenceType referenceType) {
        Map<String, Reference> map = this.getReferenceMap(referenceType);
        Queue<Reference> queue = this.getReferenceQueue(referenceType);
        if (map != null && queue != null) {
            if (!map.containsKey(key)) {
                map.put(key, reference);
                queue.add(reference);
            } else {
                String newClass;
                String existingClass = map.get(key).getClassName();
                if (!existingClass.equals(newClass = reference.getClassName())) {
                    throw new SchemaBuilderException("Classes " + existingClass + " and " + newClass + " map to the same GraphQL type '" + key + "', consider using the @Name annotation or a different naming strategy to distinguish between them");
                }
            }
        }
    }

    private Map<String, Reference> getReferenceMap(ReferenceType referenceType) {
        switch (referenceType) {
            case ENUM: {
                return this.enumReferenceMap;
            }
            case INPUT: {
                return this.inputReferenceMap;
            }
            case INTERFACE: {
                return this.interfaceReferenceMap;
            }
            case TYPE: {
                return this.typeReferenceMap;
            }
        }
        return null;
    }

    private Queue<Reference> getReferenceQueue(ReferenceType referenceType) {
        switch (referenceType) {
            case ENUM: {
                return this.enumReferenceQueue;
            }
            case INPUT: {
                return this.inputReferenceQueue;
            }
            case INTERFACE: {
                return this.interfaceReferenceQueue;
            }
            case TYPE: {
                return this.typeReferenceQueue;
            }
        }
        return null;
    }

    private static ReferenceType getCorrectReferenceType(Direction direction) {
        if (direction.equals((Object)Direction.IN)) {
            return ReferenceType.INPUT;
        }
        return ReferenceType.TYPE;
    }

    private Reference getNonIndexedReference(Direction direction, Type fieldType) {
        if (fieldType.kind().equals((Object)Type.Kind.PARAMETERIZED_TYPE)) {
            if (direction.equals((Object)Direction.IN)) {
                throw new IllegalArgumentException("Invalid parameter type [" + fieldType.name().toString() + "]");
            }
            throw new IllegalArgumentException("Invalid return type [" + fieldType.name().toString() + "]");
        }
        LOG.warn((Object)("Class [" + fieldType.name() + "] is not indexed in Jandex. Can not scan Object Type, might not be mapped correctly. Kind = [" + fieldType.kind() + "]"));
        Reference r = new Reference();
        r.setClassName(fieldType.name().toString());
        r.setGraphQlClassName(fieldType.name().toString());
        r.setName(fieldType.name().local());
        boolean isNumber = Classes.isNumberLikeTypeOrContainedIn(fieldType);
        boolean isDate = Classes.isDateLikeTypeOrContainedIn(fieldType);
        if (isNumber || isDate) {
            r.setType(ReferenceType.SCALAR);
        } else if (direction.equals((Object)Direction.IN)) {
            r.setType(ReferenceType.INPUT);
        } else {
            r.setType(ReferenceType.TYPE);
        }
        return r;
    }
}

