/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.graphql.schema.creator.type;

import io.smallrye.graphql.schema.Classes;
import io.smallrye.graphql.schema.ScanningContext;
import io.smallrye.graphql.schema.creator.FieldCreator;
import io.smallrye.graphql.schema.creator.OperationCreator;
import io.smallrye.graphql.schema.creator.ReferenceCreator;
import io.smallrye.graphql.schema.creator.type.AbstractCreator;
import io.smallrye.graphql.schema.creator.type.InterfaceCreator;
import io.smallrye.graphql.schema.helper.Direction;
import io.smallrye.graphql.schema.helper.MethodHelper;
import io.smallrye.graphql.schema.helper.TypeAutoNameStrategy;
import io.smallrye.graphql.schema.model.Reference;
import io.smallrye.graphql.schema.model.ReferenceType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Objects;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.FieldInfo;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.Type;

public class TypeCreator
extends AbstractCreator {
    private final FieldCreator fieldCreator;

    public TypeCreator(ReferenceCreator referenceCreator, FieldCreator fieldCreator, OperationCreator operationCreator, TypeAutoNameStrategy autoNameStrategy) {
        super(operationCreator, referenceCreator, autoNameStrategy);
        this.fieldCreator = fieldCreator;
    }

    @Override
    protected void addFields(io.smallrye.graphql.schema.model.Type type, ClassInfo classInfo, Reference reference) {
        ArrayList allMethods = new ArrayList();
        HashMap<String, FieldInfo> allFields = new HashMap<String, FieldInfo>();
        ClassInfo c = classInfo;
        while (c != null) {
            if (InterfaceCreator.canAddInterfaceIntoScheme(c.toString())) {
                allMethods.addAll(c.methods());
                for (FieldInfo fieldInfo : c.fields()) {
                    allFields.putIfAbsent(fieldInfo.name(), fieldInfo);
                }
            }
            c = ScanningContext.getIndex().getClassByName(c.superName());
        }
        for (MethodInfo methodInfo : allMethods) {
            if (!MethodHelper.isPropertyMethod(Direction.OUT, methodInfo)) continue;
            String fieldName = MethodHelper.getPropertyName(Direction.OUT, methodInfo.name());
            FieldInfo fieldInfo = (FieldInfo)allFields.remove(fieldName);
            this.fieldCreator.createFieldForPojo(Direction.OUT, fieldInfo, methodInfo, reference).ifPresent(arg_0 -> ((io.smallrye.graphql.schema.model.Type)type).addField(arg_0));
        }
        if (Objects.equals(classInfo.superName(), Classes.RECORD)) {
            for (FieldInfo fieldInfo : allFields.values()) {
                MethodInfo methodInfo = classInfo.method(fieldInfo.name(), new Type[0]);
                this.fieldCreator.createFieldForPojo(Direction.OUT, fieldInfo, methodInfo, reference).ifPresent(arg_0 -> ((io.smallrye.graphql.schema.model.Type)type).addField(arg_0));
            }
        } else {
            for (FieldInfo fieldInfo : allFields.values()) {
                this.fieldCreator.createFieldForPojo(Direction.OUT, fieldInfo, reference).ifPresent(arg_0 -> ((io.smallrye.graphql.schema.model.Type)type).addField(arg_0));
            }
        }
    }

    @Override
    protected ReferenceType referenceType() {
        return ReferenceType.TYPE;
    }
}

