/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.graphql.schema.creator.type;

import io.smallrye.graphql.schema.ScanningContext;
import io.smallrye.graphql.schema.creator.FieldCreator;
import io.smallrye.graphql.schema.creator.OperationCreator;
import io.smallrye.graphql.schema.creator.ReferenceCreator;
import io.smallrye.graphql.schema.creator.type.AbstractCreator;
import io.smallrye.graphql.schema.helper.Direction;
import io.smallrye.graphql.schema.helper.MethodHelper;
import io.smallrye.graphql.schema.helper.TypeAutoNameStrategy;
import io.smallrye.graphql.schema.model.Reference;
import io.smallrye.graphql.schema.model.ReferenceType;
import io.smallrye.graphql.schema.model.Type;
import java.util.List;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.MethodInfo;

public class InterfaceCreator
extends AbstractCreator {
    private final FieldCreator fieldCreator;
    private static final String JAVA_DOT = "java.";

    public InterfaceCreator(ReferenceCreator referenceCreator, FieldCreator fieldCreator, TypeAutoNameStrategy autoNameStrategy, OperationCreator operationCreator) {
        super(operationCreator, referenceCreator, autoNameStrategy);
        this.fieldCreator = fieldCreator;
    }

    @Override
    protected void addFields(Type interfaceType, ClassInfo classInfo, Reference reference) {
        for (MethodInfo methodInfo : classInfo.methods()) {
            if (!MethodHelper.isPropertyMethod(Direction.OUT, methodInfo)) continue;
            this.fieldCreator.createFieldForInterface(methodInfo, reference).ifPresent(arg_0 -> ((Type)interfaceType).addField(arg_0));
        }
        List interfaceNames = classInfo.interfaceNames();
        for (DotName interfaceName : interfaceNames) {
            ClassInfo c;
            if (!InterfaceCreator.canAddInterfaceIntoScheme(interfaceName.toString()) || (c = ScanningContext.getIndex().getClassByName(interfaceName)) == null) continue;
            this.addFields(interfaceType, c, reference);
        }
    }

    public static boolean canAddInterfaceIntoScheme(String interfaceFullName) {
        return interfaceFullName != null && !interfaceFullName.startsWith(JAVA_DOT);
    }

    @Override
    protected ReferenceType referenceType() {
        return ReferenceType.INTERFACE;
    }
}

