/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.graphql.schema;

import io.smallrye.graphql.schema.Annotations;
import io.smallrye.graphql.schema.ScanningContext;
import io.smallrye.graphql.schema.creator.ArgumentCreator;
import io.smallrye.graphql.schema.creator.FieldCreator;
import io.smallrye.graphql.schema.creator.OperationCreator;
import io.smallrye.graphql.schema.creator.ReferenceCreator;
import io.smallrye.graphql.schema.creator.type.Creator;
import io.smallrye.graphql.schema.creator.type.DirectiveTypeCreator;
import io.smallrye.graphql.schema.creator.type.EnumCreator;
import io.smallrye.graphql.schema.creator.type.InputTypeCreator;
import io.smallrye.graphql.schema.creator.type.InterfaceCreator;
import io.smallrye.graphql.schema.creator.type.TypeCreator;
import io.smallrye.graphql.schema.helper.Directives;
import io.smallrye.graphql.schema.helper.GroupHelper;
import io.smallrye.graphql.schema.helper.TypeAutoNameStrategy;
import io.smallrye.graphql.schema.model.ErrorInfo;
import io.smallrye.graphql.schema.model.Group;
import io.smallrye.graphql.schema.model.Operation;
import io.smallrye.graphql.schema.model.OperationType;
import io.smallrye.graphql.schema.model.Reference;
import io.smallrye.graphql.schema.model.ReferenceType;
import io.smallrye.graphql.schema.model.Schema;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Queue;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.MethodInfo;
import org.jboss.logging.Logger;

public class SchemaBuilder {
    private static final Logger LOG = Logger.getLogger((String)SchemaBuilder.class.getName());
    private final InputTypeCreator inputTypeCreator;
    private final TypeCreator typeCreator;
    private final FieldCreator fieldCreator;
    private final InterfaceCreator interfaceCreator;
    private final EnumCreator enumCreator;
    private final ReferenceCreator referenceCreator;
    private final OperationCreator operationCreator;
    private final DirectiveTypeCreator directiveTypeCreator;

    public static Schema build(IndexView index) {
        return SchemaBuilder.build(index, TypeAutoNameStrategy.Default);
    }

    public static Schema build(IndexView index, TypeAutoNameStrategy autoNameStrategy) {
        ScanningContext.register(index);
        return new SchemaBuilder(autoNameStrategy).generateSchema();
    }

    private SchemaBuilder(TypeAutoNameStrategy autoNameStrategy) {
        this.enumCreator = new EnumCreator(autoNameStrategy);
        this.referenceCreator = new ReferenceCreator(autoNameStrategy);
        this.fieldCreator = new FieldCreator(this.referenceCreator);
        ArgumentCreator argumentCreator = new ArgumentCreator(this.referenceCreator, this.fieldCreator);
        this.inputTypeCreator = new InputTypeCreator(this.fieldCreator, autoNameStrategy);
        this.operationCreator = new OperationCreator(this.referenceCreator, argumentCreator, this.fieldCreator);
        this.typeCreator = new TypeCreator(this.referenceCreator, this.fieldCreator, this.operationCreator, autoNameStrategy);
        this.interfaceCreator = new InterfaceCreator(this.referenceCreator, this.fieldCreator, autoNameStrategy);
        this.directiveTypeCreator = new DirectiveTypeCreator(this.referenceCreator, autoNameStrategy, this.fieldCreator);
    }

    private Schema generateSchema() {
        Collection graphQLApiAnnotations = ScanningContext.getIndex().getAnnotations(Annotations.GRAPHQL_API);
        Schema schema = new Schema();
        this.addDirectiveTypes(schema);
        this.setupDirectives(new Directives(schema.getDirectiveTypes()));
        for (AnnotationInstance graphQLApiAnnotation : graphQLApiAnnotations) {
            ClassInfo apiClass = graphQLApiAnnotation.target().asClass();
            List methods = apiClass.methods();
            Optional<Group> group = GroupHelper.getGroup(graphQLApiAnnotation);
            this.addOperations(group, schema, methods);
        }
        this.addTypesToSchema(schema);
        this.addOutstandingTypesToSchema(schema);
        this.addErrors(schema);
        this.referenceCreator.clear();
        return schema;
    }

    private void addDirectiveTypes(Schema schema) {
        for (AnnotationInstance annotationInstance : ScanningContext.getIndex().getAnnotations(Annotations.DIRECTIVE)) {
            ClassInfo classInfo = annotationInstance.target().asClass();
            schema.addDirectiveType(this.directiveTypeCreator.create(classInfo));
        }
    }

    private void setupDirectives(Directives directives) {
        this.typeCreator.setDirectives(directives);
        this.fieldCreator.setDirectives(directives);
    }

    private void addTypesToSchema(Schema schema) {
        this.createAndAddToSchema(ReferenceType.INPUT, this.inputTypeCreator, arg_0 -> ((Schema)schema).addInput(arg_0));
        this.createAndAddToSchema(ReferenceType.TYPE, this.typeCreator, arg_0 -> ((Schema)schema).addType(arg_0));
        this.createAndAddToSchema(ReferenceType.INTERFACE, this.interfaceCreator, arg_0 -> ((Schema)schema).addInterface(arg_0));
        this.createAndAddToSchema(ReferenceType.ENUM, this.enumCreator, arg_0 -> ((Schema)schema).addEnum(arg_0));
    }

    private void addOutstandingTypesToSchema(Schema schema) {
        boolean keepGoing = false;
        if (this.findOutstandingAndAddToSchema(ReferenceType.INPUT, this.inputTypeCreator, arg_0 -> ((Schema)schema).containsInput(arg_0), arg_0 -> ((Schema)schema).addInput(arg_0))) {
            keepGoing = true;
        }
        if (this.findOutstandingAndAddToSchema(ReferenceType.TYPE, this.typeCreator, arg_0 -> ((Schema)schema).containsType(arg_0), arg_0 -> ((Schema)schema).addType(arg_0))) {
            keepGoing = true;
        }
        if (this.findOutstandingAndAddToSchema(ReferenceType.INTERFACE, this.interfaceCreator, arg_0 -> ((Schema)schema).containsInterface(arg_0), arg_0 -> ((Schema)schema).addInterface(arg_0))) {
            keepGoing = true;
        }
        if (this.findOutstandingAndAddToSchema(ReferenceType.ENUM, this.enumCreator, arg_0 -> ((Schema)schema).containsEnum(arg_0), arg_0 -> ((Schema)schema).addEnum(arg_0))) {
            keepGoing = true;
        }
        if (keepGoing) {
            this.addOutstandingTypesToSchema(schema);
        }
    }

    private void addErrors(Schema schema) {
        Collection errorAnnotations = ScanningContext.getIndex().getAnnotations(Annotations.ERROR_CODE);
        if (errorAnnotations != null && !errorAnnotations.isEmpty()) {
            for (AnnotationInstance errorAnnotation : errorAnnotations) {
                AnnotationTarget annotationTarget = errorAnnotation.target();
                if (annotationTarget.kind().equals((Object)AnnotationTarget.Kind.CLASS)) {
                    ClassInfo exceptionClass = annotationTarget.asClass();
                    AnnotationValue value = errorAnnotation.value();
                    if (value != null && value.asString() != null && !value.asString().isEmpty()) {
                        schema.addError(new ErrorInfo(exceptionClass.name().toString(), value.asString()));
                        continue;
                    }
                    LOG.warn((Object)("Ignoring @ErrorCode on " + annotationTarget + " - Annotation value is not set"));
                    continue;
                }
                LOG.warn((Object)("Ignoring @ErrorCode on " + annotationTarget + " - Wrong target, only apply to CLASS [" + annotationTarget.kind().toString() + "]"));
            }
        }
    }

    private <T> void createAndAddToSchema(ReferenceType referenceType, Creator<T> creator, Consumer<T> consumer) {
        Queue<Reference> queue = this.referenceCreator.values(referenceType);
        while (!queue.isEmpty()) {
            Reference reference = queue.poll();
            ClassInfo classInfo = ScanningContext.getIndex().getClassByName(DotName.createSimple((String)reference.getClassName()));
            consumer.accept(creator.create(classInfo, reference));
        }
    }

    private <T> boolean findOutstandingAndAddToSchema(ReferenceType referenceType, Creator<T> creator, Predicate<String> contains, Consumer<T> consumer) {
        boolean keepGoing = false;
        Queue<Reference> values = this.referenceCreator.values(referenceType);
        while (!values.isEmpty()) {
            Reference reference = values.poll();
            ClassInfo classInfo = ScanningContext.getIndex().getClassByName(DotName.createSimple((String)reference.getClassName()));
            if (contains.test(reference.getName())) continue;
            consumer.accept(creator.create(classInfo, reference));
            keepGoing = true;
        }
        return keepGoing;
    }

    private void addOperations(Optional<Group> group, Schema schema, List<MethodInfo> methodInfoList) {
        for (MethodInfo methodInfo : methodInfoList) {
            Annotations annotationsForMethod = Annotations.getAnnotationsForMethod(methodInfo);
            if (annotationsForMethod.containsOneOfTheseAnnotations(Annotations.QUERY)) {
                Operation query = this.operationCreator.createOperation(methodInfo, OperationType.QUERY, null);
                if (group.isPresent()) {
                    schema.addGroupedQuery(group.get(), query);
                    continue;
                }
                schema.addQuery(query);
                continue;
            }
            if (annotationsForMethod.containsOneOfTheseAnnotations(Annotations.MUTATION)) {
                Operation mutation = this.operationCreator.createOperation(methodInfo, OperationType.MUTATION, null);
                if (group.isPresent()) {
                    schema.addGroupedMutation(group.get(), mutation);
                    continue;
                }
                schema.addMutation(mutation);
                continue;
            }
            if (!annotationsForMethod.containsOneOfTheseAnnotations(Annotations.SUBCRIPTION)) continue;
            Operation subscription = this.operationCreator.createOperation(methodInfo, OperationType.SUBSCRIPTION, null);
            if (group.isPresent()) {
                schema.addGroupedSubscription(group.get(), subscription);
                continue;
            }
            schema.addSubscription(subscription);
        }
    }
}

