/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.graphql.schema.creator;

import io.smallrye.graphql.schema.Annotations;
import io.smallrye.graphql.schema.SchemaBuilderException;
import io.smallrye.graphql.schema.creator.ReferenceCreator;
import io.smallrye.graphql.schema.creator.WrapperCreator;
import io.smallrye.graphql.schema.helper.DefaultValueHelper;
import io.smallrye.graphql.schema.helper.DescriptionHelper;
import io.smallrye.graphql.schema.helper.Direction;
import io.smallrye.graphql.schema.helper.FormatHelper;
import io.smallrye.graphql.schema.helper.IgnoreHelper;
import io.smallrye.graphql.schema.helper.MappingHelper;
import io.smallrye.graphql.schema.helper.MethodHelper;
import io.smallrye.graphql.schema.helper.NonNullHelper;
import io.smallrye.graphql.schema.model.Field;
import io.smallrye.graphql.schema.model.Mapping;
import io.smallrye.graphql.schema.model.Reference;
import io.smallrye.graphql.schema.model.Transformation;
import io.smallrye.graphql.schema.model.Wrapper;
import java.lang.reflect.Modifier;
import java.util.Optional;
import org.jboss.jandex.FieldInfo;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.Type;

public class FieldCreator {
    private final ReferenceCreator referenceCreator;

    public FieldCreator(ReferenceCreator referenceCreator) {
        this.referenceCreator = referenceCreator;
    }

    public Optional<Field> createFieldForInterface(MethodInfo methodInfo, Reference parentObjectReference) {
        Annotations annotationsForMethod = Annotations.getAnnotationsForInterfaceField(methodInfo);
        if (!FieldCreator.isGraphQlField(Direction.OUT, null, methodInfo)) {
            return Optional.empty();
        }
        Type returnType = methodInfo.returnType();
        String name = FieldCreator.getFieldName(Direction.OUT, annotationsForMethod, methodInfo.name());
        FieldCreator.validateFieldType(Direction.OUT, methodInfo);
        Reference reference = this.referenceCreator.createReferenceForInterfaceField(returnType, annotationsForMethod, parentObjectReference);
        Field field = new Field(methodInfo.name(), MethodHelper.getPropertyName(Direction.OUT, methodInfo.name()), name, reference);
        FieldCreator.configure(field, returnType, annotationsForMethod);
        return Optional.of(field);
    }

    public static void configure(Field field, Type type, Annotations annotations) {
        field.setWrapper((Wrapper)WrapperCreator.createWrapper(type).orElse(null));
        FieldCreator.configure2(field, type, annotations);
    }

    private static void configure2(Field field, Type type, Annotations annotations) {
        DescriptionHelper.getDescriptionForField(annotations, type).ifPresent(arg_0 -> ((Field)field).setDescription(arg_0));
        if (NonNullHelper.markAsNonNull(type, annotations)) {
            field.setNotNull(true);
        }
        field.setTransformation((Transformation)FormatHelper.getFormat(type, annotations).orElse(null));
        field.setMapping((Mapping)MappingHelper.getMapping(field, annotations).orElse(null));
        field.setDefaultValue((String)DefaultValueHelper.getDefaultValue(annotations).orElse(null));
    }

    public Optional<Field> createFieldForPojo(Direction direction, FieldInfo fieldInfo, MethodInfo methodInfo, Reference parentObjectReference) {
        Annotations annotationsForPojo = Annotations.getAnnotationsForPojo(direction, fieldInfo, methodInfo);
        if (FieldCreator.isGraphQlField(direction, fieldInfo, methodInfo)) {
            Type methodType = FieldCreator.getMethodType(methodInfo, direction);
            String name = FieldCreator.getFieldName(direction, annotationsForPojo, methodInfo.name());
            FieldCreator.validateFieldType(direction, methodInfo);
            Type fieldType = FieldCreator.getFieldType(fieldInfo, methodType);
            Reference reference = this.referenceCreator.createReferenceForPojoField(direction, fieldType, methodType, annotationsForPojo, parentObjectReference);
            Field field = new Field(methodInfo.name(), MethodHelper.getPropertyName(direction, methodInfo.name()), name, reference);
            field.setWrapper((Wrapper)WrapperCreator.createWrapper(fieldType, methodType).orElse(null));
            FieldCreator.configure2(field, methodType, annotationsForPojo);
            return Optional.of(field);
        }
        return Optional.empty();
    }

    public Optional<Field> createFieldForParameter(MethodInfo method, short position, FieldInfo fieldInfo, Reference parentObjectReference) {
        Annotations annotationsForPojo = Annotations.getAnnotationsForInputCreator(method, position, fieldInfo);
        String name = FieldCreator.getFieldName(Direction.IN, annotationsForPojo, method.parameterName((int)position));
        Type fieldType = FieldCreator.getFieldType(fieldInfo, (Type)method.parameters().get(position));
        Reference reference = this.referenceCreator.createReferenceForPojoField(Direction.IN, fieldType, (Type)method.parameters().get(position), annotationsForPojo, parentObjectReference);
        String fieldName = fieldInfo != null ? fieldInfo.name() : null;
        Field field = new Field(null, fieldName, name, reference);
        field.setWrapper((Wrapper)WrapperCreator.createWrapper(fieldType, (Type)method.parameters().get(position)).orElse(null));
        FieldCreator.configure2(field, (Type)method.parameters().get(position), annotationsForPojo);
        return Optional.of(field);
    }

    public Optional<Field> createFieldForPojo(Direction direction, FieldInfo fieldInfo, Reference parentObjectReference) {
        if (FieldCreator.isGraphQlField(direction, fieldInfo, null)) {
            Annotations annotationsForPojo = Annotations.getAnnotationsForPojo(direction, fieldInfo);
            String name = FieldCreator.getFieldName(direction, annotationsForPojo, fieldInfo.name());
            Type fieldType = fieldInfo.type();
            Reference reference = this.referenceCreator.createReferenceForPojoField(direction, fieldType, fieldType, annotationsForPojo, parentObjectReference);
            Field field = new Field(null, fieldInfo.name(), name, reference);
            FieldCreator.configure(field, fieldType, annotationsForPojo);
            return Optional.of(field);
        }
        return Optional.empty();
    }

    protected static boolean isGraphQlField(Direction direction, FieldInfo fieldInfo, MethodInfo methodInfo) {
        boolean methodAccessible = FieldCreator.isPossibleField(methodInfo);
        boolean fieldAccessible = FieldCreator.isPossibleField(direction, fieldInfo);
        if (!methodAccessible && !fieldAccessible) {
            return false;
        }
        Annotations annotationsForPojo = Annotations.getAnnotationsForPojo(direction, fieldInfo, methodInfo);
        return !IgnoreHelper.shouldIgnore(annotationsForPojo, fieldInfo);
    }

    private static boolean isPossibleField(MethodInfo methodInfo) {
        return methodInfo != null && Modifier.isPublic(methodInfo.flags()) && !Modifier.isStatic(methodInfo.flags());
    }

    private static boolean isPossibleField(Direction direction, FieldInfo fieldInfo) {
        return fieldInfo != null && (direction != Direction.IN || !Modifier.isFinal(fieldInfo.flags())) && Modifier.isPublic(fieldInfo.flags()) && !Modifier.isStatic(fieldInfo.flags());
    }

    private static void validateFieldType(Direction direction, MethodInfo methodInfo) {
        Type returnType = methodInfo.returnType();
        if (direction.equals((Object)Direction.OUT) && returnType.kind().equals((Object)Type.Kind.VOID)) {
            throw new SchemaBuilderException("Can not have a void return method [" + methodInfo.name() + "] in class [" + methodInfo.declaringClass().name() + "]");
        }
    }

    private static Type getMethodType(MethodInfo method, Direction direction) {
        if (direction.equals((Object)Direction.IN)) {
            return (Type)method.parameters().get(0);
        }
        return method.returnType();
    }

    private static Type getFieldType(FieldInfo fieldInfo, Type defaultType) {
        if (fieldInfo == null) {
            return defaultType;
        }
        return fieldInfo.type();
    }

    static String getFieldName(Direction direction, Annotations annotationsForThisField, String defaultFieldName) {
        switch (direction) {
            case OUT: {
                return FieldCreator.getOutputNameForField(annotationsForThisField, defaultFieldName);
            }
            case IN: {
                return FieldCreator.getInputNameForField(annotationsForThisField, defaultFieldName);
            }
        }
        return defaultFieldName;
    }

    private static String getOutputNameForField(Annotations annotationsForThisField, String fieldName) {
        return annotationsForThisField.getOneOfTheseMethodAnnotationsValue(Annotations.NAME, Annotations.QUERY, Annotations.JSONB_PROPERTY).orElse(annotationsForThisField.getOneOfTheseAnnotationsValue(Annotations.NAME, Annotations.QUERY, Annotations.JSONB_PROPERTY).orElse(MethodHelper.getPropertyName(Direction.OUT, fieldName)));
    }

    private static String getInputNameForField(Annotations annotationsForThisField, String fieldName) {
        return annotationsForThisField.getOneOfTheseMethodAnnotationsValue(Annotations.NAME, Annotations.JSONB_PROPERTY).orElse(annotationsForThisField.getOneOfTheseAnnotationsValue(Annotations.NAME, Annotations.JSONB_PROPERTY).orElse(MethodHelper.getPropertyName(Direction.IN, fieldName)));
    }
}

