/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.graphql.schema.creator.type;

import io.smallrye.graphql.schema.Annotations;
import io.smallrye.graphql.schema.ScanningContext;
import io.smallrye.graphql.schema.creator.FieldCreator;
import io.smallrye.graphql.schema.creator.OperationCreator;
import io.smallrye.graphql.schema.creator.ReferenceCreator;
import io.smallrye.graphql.schema.creator.type.Creator;
import io.smallrye.graphql.schema.creator.type.InterfaceCreator;
import io.smallrye.graphql.schema.helper.DescriptionHelper;
import io.smallrye.graphql.schema.helper.Direction;
import io.smallrye.graphql.schema.helper.MethodHelper;
import io.smallrye.graphql.schema.helper.SourceOperationHelper;
import io.smallrye.graphql.schema.helper.TypeAutoNameStrategy;
import io.smallrye.graphql.schema.helper.TypeNameHelper;
import io.smallrye.graphql.schema.model.Operation;
import io.smallrye.graphql.schema.model.OperationType;
import io.smallrye.graphql.schema.model.Reference;
import io.smallrye.graphql.schema.model.ReferenceType;
import io.smallrye.graphql.schema.model.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.FieldInfo;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.MethodParameterInfo;
import org.jboss.jandex.Type;
import org.jboss.logging.Logger;

public class TypeCreator
implements Creator<Type> {
    private static final Logger LOG = Logger.getLogger((String)TypeCreator.class.getName());
    private final ReferenceCreator referenceCreator;
    private final FieldCreator fieldCreator;
    private final OperationCreator operationCreator;
    private final TypeAutoNameStrategy autoNameStrategy;

    public TypeCreator(ReferenceCreator referenceCreator, FieldCreator fieldCreator, OperationCreator operationCreator, TypeAutoNameStrategy autoNameStrategy) {
        this.referenceCreator = referenceCreator;
        this.fieldCreator = fieldCreator;
        this.operationCreator = operationCreator;
        this.autoNameStrategy = autoNameStrategy;
    }

    @Override
    public Type create(ClassInfo classInfo, Reference reference) {
        LOG.debug((Object)("Creating Type from " + classInfo.name().toString() + " for reference " + reference.getName()));
        Annotations annotations = Annotations.getAnnotationsForClass(classInfo);
        String name = TypeNameHelper.getAnyTypeName(reference, ReferenceType.TYPE, classInfo, annotations, this.autoNameStrategy);
        String description = DescriptionHelper.getDescriptionForType(annotations).orElse(null);
        Type type = new Type(classInfo.name().toString(), name, description);
        this.addFields(type, classInfo, reference);
        this.addOperations(type, classInfo);
        this.addInterfaces(type, classInfo, reference);
        return type;
    }

    private void addFields(Type type, ClassInfo classInfo, Reference reference) {
        ArrayList allMethods = new ArrayList();
        HashMap<String, FieldInfo> allFields = new HashMap<String, FieldInfo>();
        ClassInfo c = classInfo;
        while (c != null) {
            if (InterfaceCreator.canAddInterfaceIntoScheme(c.toString())) {
                allMethods.addAll(c.methods());
                if (c.fields() != null && !c.fields().isEmpty()) {
                    for (FieldInfo fieldInfo : c.fields()) {
                        allFields.putIfAbsent(fieldInfo.name(), fieldInfo);
                    }
                }
            }
            c = ScanningContext.getIndex().getClassByName(c.superName());
        }
        for (MethodInfo methodInfo : allMethods) {
            if (!MethodHelper.isPropertyMethod(Direction.OUT, methodInfo.name())) continue;
            String fieldName = MethodHelper.getPropertyName(Direction.OUT, methodInfo.name());
            FieldInfo fieldInfo = (FieldInfo)allFields.remove(fieldName);
            this.fieldCreator.createFieldForPojo(Direction.OUT, fieldInfo, methodInfo, reference).ifPresent(arg_0 -> ((Type)type).addField(arg_0));
        }
        if (!allFields.isEmpty()) {
            for (FieldInfo fieldInfo : allFields.values()) {
                this.fieldCreator.createFieldForPojo(Direction.OUT, fieldInfo, reference).ifPresent(arg_0 -> ((Type)type).addField(arg_0));
            }
        }
    }

    private void addOperations(Type type, ClassInfo classInfo) {
        SourceOperationHelper sourceOperationHelper = new SourceOperationHelper();
        Map<DotName, List<MethodParameterInfo>> sourceFields = sourceOperationHelper.getSourceAnnotations();
        Map<DotName, List<MethodParameterInfo>> batchedFields = sourceOperationHelper.getSourceListAnnotations();
        type.setOperations(this.toOperations(sourceFields, type, classInfo));
        type.setBatchOperations(this.toOperations(batchedFields, type, classInfo));
    }

    private Map<String, Operation> toOperations(Map<DotName, List<MethodParameterInfo>> sourceFields, Type type, ClassInfo classInfo) {
        HashMap<String, Operation> operations = new HashMap<String, Operation>();
        if (sourceFields.containsKey(classInfo.name())) {
            List<MethodParameterInfo> methodParameterInfos = sourceFields.get(classInfo.name());
            for (MethodParameterInfo methodParameterInfo : methodParameterInfos) {
                MethodInfo methodInfo = methodParameterInfo.method();
                Operation o = this.operationCreator.createOperation(methodInfo, OperationType.QUERY, type);
                operations.put(o.getName(), o);
            }
        }
        return operations;
    }

    private void addInterfaces(Type type, ClassInfo classInfo, Reference reference) {
        List interfaceNames = classInfo.interfaceTypes();
        for (org.jboss.jandex.Type interfaceType : interfaceNames) {
            ClassInfo interfaceInfo;
            if (!InterfaceCreator.canAddInterfaceIntoScheme(interfaceType.name().toString()) || (interfaceInfo = ScanningContext.getIndex().getClassByName(interfaceType.name())) == null) continue;
            Map<String, Reference> parametrizedTypeArgumentsReferences = null;
            if (interfaceType.kind().equals((Object)Type.Kind.PARAMETERIZED_TYPE)) {
                parametrizedTypeArgumentsReferences = this.referenceCreator.collectParametrizedTypes(interfaceInfo, interfaceType.asParameterizedType().arguments(), Direction.OUT, reference);
            }
            Reference interfaceRef = this.referenceCreator.createReference(Direction.OUT, interfaceInfo, true, reference, parametrizedTypeArgumentsReferences, true);
            type.addInterface(interfaceRef);
            this.addInterfaces(type, interfaceInfo, reference);
        }
    }
}

