/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.graphql.schema.creator;

import io.smallrye.graphql.schema.Annotations;
import io.smallrye.graphql.schema.Classes;
import io.smallrye.graphql.schema.ScanningContext;
import io.smallrye.graphql.schema.SchemaBuilderException;
import io.smallrye.graphql.schema.helper.Direction;
import io.smallrye.graphql.schema.helper.FormatHelper;
import io.smallrye.graphql.schema.helper.MappingHelper;
import io.smallrye.graphql.schema.helper.TypeNameHelper;
import io.smallrye.graphql.schema.model.MappingInfo;
import io.smallrye.graphql.schema.model.Reference;
import io.smallrye.graphql.schema.model.ReferenceType;
import io.smallrye.graphql.schema.model.Scalars;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Queue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.Type;
import org.jboss.jandex.TypeVariable;
import org.jboss.logging.Logger;

public class ReferenceCreator {
    private static final Logger LOG = Logger.getLogger((String)ReferenceCreator.class.getName());
    private final Queue<Reference> inputReferenceQueue = new ArrayDeque<Reference>();
    private final Queue<Reference> typeReferenceQueue = new ArrayDeque<Reference>();
    private final Queue<Reference> enumReferenceQueue = new ArrayDeque<Reference>();
    private final Queue<Reference> interfaceReferenceQueue = new ArrayDeque<Reference>();
    private final Map<String, Reference> inputReferenceMap = new HashMap<String, Reference>();
    private final Map<String, Reference> typeReferenceMap = new HashMap<String, Reference>();
    private final Map<String, Reference> enumReferenceMap = new HashMap<String, Reference>();
    private final Map<String, Reference> interfaceReferenceMap = new HashMap<String, Reference>();

    public void clear() {
        this.inputReferenceMap.clear();
        this.typeReferenceMap.clear();
        this.enumReferenceMap.clear();
        this.interfaceReferenceMap.clear();
        this.inputReferenceQueue.clear();
        this.typeReferenceQueue.clear();
        this.enumReferenceQueue.clear();
        this.interfaceReferenceQueue.clear();
    }

    public Queue<Reference> values(ReferenceType referenceType) {
        return this.getReferenceQueue(referenceType);
    }

    public Reference createReferenceForOperationField(Type fieldType, Annotations annotationsForMethod) {
        return this.getReference(Direction.OUT, null, fieldType, annotationsForMethod);
    }

    public Reference createReferenceForOperationArgument(Type argumentType, Annotations annotationsForThisArgument) {
        return this.getReference(Direction.IN, null, argumentType, annotationsForThisArgument);
    }

    public Reference createReferenceForSourceArgument(Type argumentType, Annotations annotationsForThisArgument) {
        return this.getReference(Direction.OUT, null, argumentType, annotationsForThisArgument);
    }

    public Reference createReferenceForInterfaceField(Type methodType, Annotations annotationsForThisMethod, Reference parentObjectReference) {
        return this.getReference(Direction.OUT, null, methodType, annotationsForThisMethod, parentObjectReference);
    }

    public Reference createReferenceForPojoField(Direction direction, Type fieldType, Type methodType, Annotations annotations, Reference parentObjectReference) {
        return this.getReference(direction, fieldType, methodType, annotations, parentObjectReference);
    }

    public Reference createReference(Direction direction, ClassInfo classInfo) {
        return this.createReference(direction, classInfo, true, null);
    }

    public Reference createReference(Direction direction, ClassInfo classInfo, boolean createType, List<Type> parametrizedTypeArguments) {
        ReferenceType referenceType = ReferenceCreator.getCorrectReferenceType(direction);
        if (Classes.isInterface(classInfo)) {
            Collection knownDirectImplementors = ScanningContext.getIndex().getAllKnownImplementors(classInfo.name());
            for (ClassInfo impl : knownDirectImplementors) {
                this.createReference(direction, impl, createType, parametrizedTypeArguments);
            }
            referenceType = ReferenceType.INTERFACE;
        } else if (Classes.isEnum(classInfo)) {
            referenceType = ReferenceType.ENUM;
        }
        String className = classInfo.name().toString();
        Annotations annotationsForClass = Annotations.getAnnotationsForClass(classInfo);
        String name = TypeNameHelper.getAnyTypeName(referenceType, classInfo, annotationsForClass, TypeNameHelper.createParametrizedTypeNameExtension(parametrizedTypeArguments));
        HashMap<String, Reference> parametrizedTypeArgumentsReferences = null;
        if (parametrizedTypeArguments != null && referenceType != ReferenceType.ENUM) {
            ArrayList<TypeVariable> tvl = new ArrayList<TypeVariable>();
            this.collectTypeVariables(tvl, classInfo);
            parametrizedTypeArgumentsReferences = new HashMap<String, Reference>();
            int i = 0;
            for (Type pat : parametrizedTypeArguments) {
                if (i >= tvl.size()) {
                    throw new SchemaBuilderException("List of type variables is not correct for class " + classInfo + " and generics argument " + pat);
                }
                parametrizedTypeArgumentsReferences.put(((TypeVariable)tvl.get(i++)).identifier(), this.getReference(direction, pat, null, null));
            }
        }
        Reference reference = new Reference(className, name, referenceType, parametrizedTypeArgumentsReferences);
        boolean shouldCreateType = MappingHelper.shouldCreateTypeInSchema(annotationsForClass);
        Optional<MappingInfo> mapping = MappingHelper.getMapping(reference, annotationsForClass);
        reference.setMappingInfo((MappingInfo)mapping.orElse(null));
        if (shouldCreateType && createType) {
            this.putIfAbsent(name, reference, referenceType);
        }
        return reference;
    }

    private void collectTypeVariables(List<TypeVariable> tvl, ClassInfo classInfo) {
        if (classInfo == null) {
            return;
        }
        if (classInfo.typeParameters() != null) {
            tvl.addAll(classInfo.typeParameters());
        }
        if (classInfo.superClassType() != null) {
            this.collectTypeVariables(tvl, ScanningContext.getIndex().getClassByName(classInfo.superName()));
        }
    }

    private Reference getReference(Direction direction, Type fieldType, Type methodType, Annotations annotations) {
        return this.getReference(direction, fieldType, methodType, annotations, null);
    }

    private Reference getReference(Direction direction, Type fieldType, Type methodType, Annotations annotations, Reference parentObjectReference) {
        if (fieldType == null) {
            fieldType = methodType;
        }
        String fieldTypeName = fieldType.name().toString();
        if (annotations != null && annotations.containsOneOfTheseAnnotations(Annotations.ID)) {
            return Scalars.getIDScalar((String)fieldTypeName);
        }
        if (Scalars.isScalar((String)fieldTypeName)) {
            if (FormatHelper.hasAnyFormatting(annotations)) {
                return Scalars.getFormattedScalar((String)fieldTypeName);
            }
            return Scalars.getScalar((String)fieldTypeName);
        }
        if (fieldType.kind().equals((Object)Type.Kind.ARRAY)) {
            Type typeInArray = fieldType.asArrayType().component();
            Type typeInMethodArray = methodType.asArrayType().component();
            return this.getReference(direction, typeInArray, typeInMethodArray, annotations);
        }
        if (Classes.isCollection(fieldType) || Classes.isUnwrappedType(fieldType)) {
            Type typeInCollection = (Type)fieldType.asParameterizedType().arguments().get(0);
            Type typeInMethodCollection = (Type)methodType.asParameterizedType().arguments().get(0);
            return this.getReference(direction, typeInCollection, typeInMethodCollection, annotations);
        }
        if (fieldType.kind().equals((Object)Type.Kind.CLASS)) {
            ClassInfo classInfo = ScanningContext.getIndex().getClassByName(fieldType.name());
            if (classInfo != null) {
                ArrayList<Type> parametrizedTypeArguments = new ArrayList<Type>();
                this.collectParametrizedTypeArguments(parametrizedTypeArguments, classInfo);
                boolean shouldCreateType = MappingHelper.shouldCreateTypeInSchema(annotations);
                return this.createReference(direction, classInfo, shouldCreateType, parametrizedTypeArguments.isEmpty() ? null : parametrizedTypeArguments);
            }
            LOG.warn((Object)("Class [" + fieldType.name() + "] in not indexed in Jandex. Can not scan Object Type, defaulting to String Scalar"));
            return Scalars.getScalar((String)String.class.getName());
        }
        if (fieldType.kind().equals((Object)Type.Kind.PARAMETERIZED_TYPE)) {
            ClassInfo classInfo = ScanningContext.getIndex().getClassByName(fieldType.name());
            if (classInfo != null) {
                List parametrizedTypeArguments = fieldType.asParameterizedType().arguments();
                boolean shouldCreateType = MappingHelper.shouldCreateTypeInSchema(annotations);
                return this.createReference(direction, classInfo, shouldCreateType, parametrizedTypeArguments);
            }
            LOG.warn((Object)("Class [" + fieldType.name() + "] in not indexed in Jandex. Can not scan Object Type, defaulting to String Scalar"));
            return Scalars.getScalar((String)String.class.getName());
        }
        if (fieldType.kind().equals((Object)Type.Kind.TYPE_VARIABLE)) {
            if (parentObjectReference == null || parentObjectReference.getParametrizedTypeArguments() == null) {
                throw new SchemaBuilderException("Don't know what to do with [" + fieldType + "] of kind [" + fieldType.kind() + "] as parent object reference is missing or incomplete");
            }
            LOG.debug((Object)("Type variable: " + fieldType.asTypeVariable().name() + " identifier: " + fieldType.asTypeVariable().identifier()));
            Reference ret = (Reference)parentObjectReference.getParametrizedTypeArguments().get(fieldType.asTypeVariable().identifier());
            if (ret == null) {
                throw new SchemaBuilderException("Don't know what to do with [" + fieldType + "] of kind [" + fieldType.kind() + "] as parent object reference doesn't contain necessary info");
            }
            return ret;
        }
        throw new SchemaBuilderException("Don't know what to do with [" + fieldType + "] of kind [" + fieldType.kind() + "]");
    }

    private void collectParametrizedTypeArguments(List<Type> parametrizedTypeArguments, ClassInfo classInfo) {
        if (classInfo == null) {
            return;
        }
        if (classInfo.superClassType() != null) {
            if (classInfo.superClassType().kind().equals((Object)Type.Kind.PARAMETERIZED_TYPE)) {
                parametrizedTypeArguments.addAll(classInfo.superClassType().asParameterizedType().arguments());
            }
            this.collectParametrizedTypeArguments(parametrizedTypeArguments, ScanningContext.getIndex().getClassByName(classInfo.superName()));
        }
    }

    private void putIfAbsent(String key, Reference reference, ReferenceType referenceType) {
        Map<String, Reference> map = this.getReferenceMap(referenceType);
        Queue<Reference> queue = this.getReferenceQueue(referenceType);
        if (map != null && queue != null && !map.containsKey(key)) {
            map.put(key, reference);
            queue.add(reference);
        }
    }

    private Map<String, Reference> getReferenceMap(ReferenceType referenceType) {
        switch (referenceType) {
            case ENUM: {
                return this.enumReferenceMap;
            }
            case INPUT: {
                return this.inputReferenceMap;
            }
            case INTERFACE: {
                return this.interfaceReferenceMap;
            }
            case TYPE: {
                return this.typeReferenceMap;
            }
        }
        return null;
    }

    private Queue<Reference> getReferenceQueue(ReferenceType referenceType) {
        switch (referenceType) {
            case ENUM: {
                return this.enumReferenceQueue;
            }
            case INPUT: {
                return this.inputReferenceQueue;
            }
            case INTERFACE: {
                return this.interfaceReferenceQueue;
            }
            case TYPE: {
                return this.typeReferenceQueue;
            }
        }
        return null;
    }

    private static ReferenceType getCorrectReferenceType(Direction direction) {
        if (direction.equals((Object)Direction.IN)) {
            return ReferenceType.INPUT;
        }
        return ReferenceType.TYPE;
    }
}

