/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.graphql.schema;

import io.smallrye.graphql.schema.Annotations;
import io.smallrye.graphql.schema.ScanningContext;
import io.smallrye.graphql.schema.creator.ArgumentCreator;
import io.smallrye.graphql.schema.creator.FieldCreator;
import io.smallrye.graphql.schema.creator.OperationCreator;
import io.smallrye.graphql.schema.creator.ReferenceCreator;
import io.smallrye.graphql.schema.creator.type.Creator;
import io.smallrye.graphql.schema.creator.type.EnumCreator;
import io.smallrye.graphql.schema.creator.type.InputTypeCreator;
import io.smallrye.graphql.schema.creator.type.InterfaceCreator;
import io.smallrye.graphql.schema.creator.type.TypeCreator;
import io.smallrye.graphql.schema.model.ErrorInfo;
import io.smallrye.graphql.schema.model.Operation;
import io.smallrye.graphql.schema.model.OperationType;
import io.smallrye.graphql.schema.model.Reference;
import io.smallrye.graphql.schema.model.ReferenceType;
import io.smallrye.graphql.schema.model.Schema;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.MethodInfo;
import org.jboss.logging.Logger;

public class SchemaBuilder {
    private static final Logger LOG = Logger.getLogger((String)SchemaBuilder.class.getName());
    private final InputTypeCreator inputTypeCreator;
    private final TypeCreator typeCreator;
    private final InterfaceCreator interfaceCreator;
    private final EnumCreator enumCreator = new EnumCreator();
    private final ReferenceCreator referenceCreator = new ReferenceCreator();
    private final OperationCreator operationCreator;

    public static Schema build(IndexView index) {
        ScanningContext.register(index);
        SchemaBuilder graphQLBootstrap = new SchemaBuilder();
        return graphQLBootstrap.generateSchema();
    }

    private SchemaBuilder() {
        FieldCreator fieldCreator = new FieldCreator(this.referenceCreator);
        ArgumentCreator argumentCreator = new ArgumentCreator(this.referenceCreator);
        this.inputTypeCreator = new InputTypeCreator(fieldCreator);
        this.operationCreator = new OperationCreator(this.referenceCreator, argumentCreator);
        this.typeCreator = new TypeCreator(this.referenceCreator, fieldCreator, this.operationCreator);
        this.interfaceCreator = new InterfaceCreator(this.referenceCreator, fieldCreator);
    }

    private Schema generateSchema() {
        Collection graphQLApiAnnotations = ScanningContext.getIndex().getAnnotations(Annotations.GRAPHQL_API);
        Schema schema = new Schema();
        for (AnnotationInstance graphQLApiAnnotation : graphQLApiAnnotations) {
            ClassInfo apiClass = graphQLApiAnnotation.target().asClass();
            List methods = apiClass.methods();
            this.addOperations(schema, methods);
        }
        this.addTypesToSchema(schema);
        this.addOutstandingTypesToSchema(schema);
        this.addErrors(schema);
        this.referenceCreator.clear();
        return schema;
    }

    private void addTypesToSchema(Schema schema) {
        this.createAndAddToSchema(ReferenceType.INPUT, this.inputTypeCreator, arg_0 -> ((Schema)schema).addInput(arg_0));
        this.createAndAddToSchema(ReferenceType.TYPE, this.typeCreator, arg_0 -> ((Schema)schema).addType(arg_0));
        this.createAndAddToSchema(ReferenceType.INTERFACE, this.interfaceCreator, arg_0 -> ((Schema)schema).addInterface(arg_0));
        this.createAndAddToSchema(ReferenceType.ENUM, this.enumCreator, arg_0 -> ((Schema)schema).addEnum(arg_0));
    }

    private void addOutstandingTypesToSchema(Schema schema) {
        boolean allDone = true;
        if (!this.findOutstandingAndAddToSchema(ReferenceType.INPUT, this.inputTypeCreator, arg_0 -> ((Schema)schema).containsInput(arg_0), arg_0 -> ((Schema)schema).addInput(arg_0))) {
            allDone = false;
        }
        if (!this.findOutstandingAndAddToSchema(ReferenceType.TYPE, this.typeCreator, arg_0 -> ((Schema)schema).containsType(arg_0), arg_0 -> ((Schema)schema).addType(arg_0))) {
            allDone = false;
        }
        if (!this.findOutstandingAndAddToSchema(ReferenceType.INTERFACE, this.interfaceCreator, arg_0 -> ((Schema)schema).containsInterface(arg_0), arg_0 -> ((Schema)schema).addInterface(arg_0))) {
            allDone = false;
        }
        if (!this.findOutstandingAndAddToSchema(ReferenceType.ENUM, this.enumCreator, arg_0 -> ((Schema)schema).containsEnum(arg_0), arg_0 -> ((Schema)schema).addEnum(arg_0))) {
            allDone = false;
        }
        if (!allDone) {
            this.addOutstandingTypesToSchema(schema);
        }
    }

    private void addErrors(Schema schema) {
        Collection errorAnnotations = ScanningContext.getIndex().getAnnotations(Annotations.ERROR_CODE);
        if (errorAnnotations != null && !errorAnnotations.isEmpty()) {
            for (AnnotationInstance errorAnnotation : errorAnnotations) {
                AnnotationTarget annotationTarget = errorAnnotation.target();
                if (annotationTarget.kind().equals((Object)AnnotationTarget.Kind.CLASS)) {
                    ClassInfo exceptionClass = annotationTarget.asClass();
                    AnnotationValue value = errorAnnotation.value();
                    if (value != null && value.asString() != null && !value.asString().isEmpty()) {
                        schema.addError(new ErrorInfo(exceptionClass.name().toString(), value.asString()));
                        continue;
                    }
                    LOG.warn((Object)("Ignoring @ErrorCode on " + annotationTarget.toString() + " - Annotation value is not set"));
                    continue;
                }
                LOG.warn((Object)("Ignoring @ErrorCode on " + annotationTarget.toString() + " - Wrong target, only apply to CLASS [" + annotationTarget.kind().toString() + "]"));
            }
        }
    }

    private <T> void createAndAddToSchema(ReferenceType referenceType, Creator creator, Consumer<T> consumer) {
        while (!this.referenceCreator.values(referenceType).isEmpty()) {
            Reference reference = this.referenceCreator.values(referenceType).poll();
            ClassInfo classInfo = ScanningContext.getIndex().getClassByName(DotName.createSimple((String)reference.getClassName()));
            consumer.accept(creator.create(classInfo, reference));
        }
    }

    private <T> boolean findOutstandingAndAddToSchema(ReferenceType referenceType, Creator creator, Predicate<String> contains, Consumer<T> consumer) {
        boolean allDone = true;
        while (!this.referenceCreator.values(referenceType).isEmpty()) {
            Reference reference = this.referenceCreator.values(referenceType).poll();
            ClassInfo classInfo = ScanningContext.getIndex().getClassByName(DotName.createSimple((String)reference.getClassName()));
            if (contains.test(reference.getName())) continue;
            consumer.accept(creator.create(classInfo, reference));
            allDone = false;
        }
        return allDone;
    }

    private void addOperations(Schema schema, List<MethodInfo> methodInfoList) {
        for (MethodInfo methodInfo : methodInfoList) {
            Annotations annotationsForMethod = Annotations.getAnnotationsForMethod(methodInfo);
            if (annotationsForMethod.containsOneOfTheseAnnotations(Annotations.QUERY)) {
                Operation query = this.operationCreator.createOperation(methodInfo, OperationType.Query, null);
                schema.addQuery(query);
                continue;
            }
            if (!annotationsForMethod.containsOneOfTheseAnnotations(Annotations.MUTATION)) continue;
            Operation mutation = this.operationCreator.createOperation(methodInfo, OperationType.Mutation, null);
            schema.addMutation(mutation);
        }
    }
}

