/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.graphql.schema.creator.type;

import io.smallrye.graphql.schema.Annotations;
import io.smallrye.graphql.schema.ScanningContext;
import io.smallrye.graphql.schema.creator.FieldCreator;
import io.smallrye.graphql.schema.creator.ReferenceCreator;
import io.smallrye.graphql.schema.creator.type.Creator;
import io.smallrye.graphql.schema.creator.type.InputTypeCreator;
import io.smallrye.graphql.schema.helper.DescriptionHelper;
import io.smallrye.graphql.schema.helper.Direction;
import io.smallrye.graphql.schema.helper.MethodHelper;
import io.smallrye.graphql.schema.helper.TypeNameHelper;
import io.smallrye.graphql.schema.model.InterfaceType;
import io.smallrye.graphql.schema.model.Reference;
import io.smallrye.graphql.schema.model.ReferenceType;
import java.util.ArrayList;
import java.util.List;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.MethodInfo;
import org.jboss.logging.Logger;

public class InterfaceCreator
implements Creator<InterfaceType> {
    private static final Logger LOG = Logger.getLogger((String)InputTypeCreator.class.getName());
    private static final String JAVA_DOT = "java.";

    @Override
    public InterfaceType create(ClassInfo classInfo) {
        LOG.debug((Object)("Creating Interface from " + classInfo.name().toString()));
        Annotations annotations = Annotations.getAnnotationsForClass(classInfo);
        String name = TypeNameHelper.getAnyTypeName(ReferenceType.INTERFACE, classInfo, annotations);
        String description = DescriptionHelper.getDescriptionForType(annotations).orElse(null);
        InterfaceType interfaceType = new InterfaceType(classInfo.name().toString(), name, description);
        this.addFields(interfaceType, classInfo);
        this.addInterfaces(interfaceType, classInfo);
        return interfaceType;
    }

    private void addFields(InterfaceType interfaceType, ClassInfo classInfo) {
        ArrayList allMethods = new ArrayList();
        ClassInfo c = classInfo;
        while (c != null) {
            if (!c.toString().startsWith(JAVA_DOT)) {
                allMethods.addAll(c.methods());
            }
            c = ScanningContext.getIndex().getClassByName(c.superName());
        }
        for (MethodInfo methodInfo : allMethods) {
            if (!MethodHelper.isPropertyMethod(Direction.OUT, methodInfo.name())) continue;
            FieldCreator.createFieldForInterface(methodInfo).ifPresent(arg_0 -> ((InterfaceType)interfaceType).addField(arg_0));
        }
    }

    private void addInterfaces(InterfaceType interfaceType, ClassInfo classInfo) {
        List interfaceNames = classInfo.interfaceNames();
        for (DotName interfaceName : interfaceNames) {
            ClassInfo c;
            if (interfaceName.toString().startsWith(JAVA_DOT) || (c = ScanningContext.getIndex().getClassByName(interfaceName)) == null) continue;
            Reference interfaceRef = ReferenceCreator.createReference(Direction.OUT, classInfo);
            interfaceType.addInterface(interfaceRef);
        }
    }
}

