/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.graphql.schema.creator;

import io.smallrye.graphql.schema.Annotations;
import io.smallrye.graphql.schema.Classes;
import io.smallrye.graphql.schema.ScanningContext;
import io.smallrye.graphql.schema.SchemaBuilderException;
import io.smallrye.graphql.schema.helper.Direction;
import io.smallrye.graphql.schema.helper.TypeNameHelper;
import io.smallrye.graphql.schema.model.Reference;
import io.smallrye.graphql.schema.model.ReferenceType;
import io.smallrye.graphql.schema.model.Scalars;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Queue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.Type;
import org.jboss.logging.Logger;

public class ReferenceCreator {
    private static final Logger LOG = Logger.getLogger((String)ReferenceCreator.class.getName());
    private static final Queue<Reference> inputReferenceQueue = new ArrayDeque<Reference>();
    private static final Queue<Reference> typeReferenceQueue = new ArrayDeque<Reference>();
    private static final Queue<Reference> enumReferenceQueue = new ArrayDeque<Reference>();
    private static final Queue<Reference> interfaceReferenceQueue = new ArrayDeque<Reference>();
    private static final Map<String, Reference> inputReferenceMap = new HashMap<String, Reference>();
    private static final Map<String, Reference> typeReferenceMap = new HashMap<String, Reference>();
    private static final Map<String, Reference> enumReferenceMap = new HashMap<String, Reference>();
    private static final Map<String, Reference> interfaceReferenceMap = new HashMap<String, Reference>();

    private ReferenceCreator() {
    }

    public static void clear() {
        inputReferenceMap.clear();
        typeReferenceMap.clear();
        enumReferenceMap.clear();
        interfaceReferenceMap.clear();
        inputReferenceQueue.clear();
        typeReferenceQueue.clear();
        enumReferenceQueue.clear();
        interfaceReferenceQueue.clear();
    }

    public static Queue<Reference> values(ReferenceType referenceType) {
        return ReferenceCreator.getReferenceQueue(referenceType);
    }

    public static Reference createReferenceForOperationField(Type fieldType, Annotations annotationsForMethod) {
        return ReferenceCreator.getReference(Direction.OUT, null, fieldType, annotationsForMethod);
    }

    public static Reference createReferenceForOperationArgument(Type argumentType, Annotations annotationsForThisArgument) {
        return ReferenceCreator.getReference(Direction.IN, null, argumentType, annotationsForThisArgument);
    }

    public static Reference createReferenceForInterfaceField(Type methodType, Annotations annotationsForThisMethod) {
        return ReferenceCreator.getReference(Direction.OUT, null, methodType, annotationsForThisMethod);
    }

    public static Reference createReferenceForPojoField(Direction direction, Type fieldType, Type methodType, Annotations annotations) {
        return ReferenceCreator.getReference(direction, fieldType, methodType, annotations);
    }

    public static Reference createReference(Direction direction, ClassInfo classInfo) {
        ReferenceType referenceType = ReferenceCreator.getCorrectReferenceType(direction);
        if (Classes.isInterface(classInfo)) {
            Collection knownDirectImplementors = ScanningContext.getIndex().getAllKnownImplementors(classInfo.name());
            for (ClassInfo impl : knownDirectImplementors) {
                ReferenceCreator.createReference(direction, impl);
            }
            referenceType = ReferenceType.INTERFACE;
        } else if (Classes.isEnum(classInfo)) {
            referenceType = ReferenceType.ENUM;
        }
        String className = classInfo.name().toString();
        Annotations annotationsForClass = Annotations.getAnnotationsForClass(classInfo);
        String name = TypeNameHelper.getAnyTypeName(referenceType, classInfo, annotationsForClass);
        Reference reference = new Reference(className, name, referenceType);
        ReferenceCreator.putIfAbsent(className, reference, referenceType);
        return reference;
    }

    private static Reference getReference(Direction direction, Type fieldType, Type methodType, Annotations annotations) {
        if (fieldType == null) {
            fieldType = methodType;
        }
        String fieldTypeName = fieldType.name().toString();
        if (annotations.containsOneOfTheseAnnotations(Annotations.ID)) {
            return Scalars.getIDScalar((String)fieldTypeName);
        }
        if (Scalars.isScalar((String)fieldTypeName)) {
            return Scalars.getScalar((String)fieldTypeName);
        }
        if (fieldType.kind().equals((Object)Type.Kind.ARRAY)) {
            Type typeInArray = fieldType.asArrayType().component();
            Type typeInMethodArray = methodType.asArrayType().component();
            return ReferenceCreator.getReference(direction, typeInArray, typeInMethodArray, annotations);
        }
        if (fieldType.kind().equals((Object)Type.Kind.PARAMETERIZED_TYPE)) {
            Type typeInCollection = (Type)fieldType.asParameterizedType().arguments().get(0);
            Type typeInMethodCollection = (Type)methodType.asParameterizedType().arguments().get(0);
            return ReferenceCreator.getReference(direction, typeInCollection, typeInMethodCollection, annotations);
        }
        if (fieldType.kind().equals((Object)Type.Kind.CLASS)) {
            ClassInfo classInfo = ScanningContext.getIndex().getClassByName(fieldType.name());
            if (classInfo != null) {
                return ReferenceCreator.createReference(direction, classInfo);
            }
            LOG.warn((Object)("Class [" + fieldType.name() + "] in not indexed in Jandex. Can not scan Object Type, defaulting to String Scalar"));
            return Scalars.getScalar((String)String.class.getName());
        }
        throw new SchemaBuilderException("Don't know what to do with [" + fieldType + "] of kind [" + fieldType.kind() + "]");
    }

    private static void putIfAbsent(String key, Reference reference, ReferenceType referenceType) {
        Map<String, Reference> map = ReferenceCreator.getReferenceMap(referenceType);
        Queue<Reference> queue = ReferenceCreator.getReferenceQueue(referenceType);
        if (!map.containsKey(key)) {
            map.put(key, reference);
            queue.add(reference);
        }
    }

    private static Map<String, Reference> getReferenceMap(ReferenceType referenceType) {
        switch (referenceType) {
            case ENUM: {
                return enumReferenceMap;
            }
            case INPUT: {
                return inputReferenceMap;
            }
            case INTERFACE: {
                return interfaceReferenceMap;
            }
            case TYPE: {
                return typeReferenceMap;
            }
        }
        return null;
    }

    private static Queue<Reference> getReferenceQueue(ReferenceType referenceType) {
        switch (referenceType) {
            case ENUM: {
                return enumReferenceQueue;
            }
            case INPUT: {
                return inputReferenceQueue;
            }
            case INTERFACE: {
                return interfaceReferenceQueue;
            }
            case TYPE: {
                return typeReferenceQueue;
            }
        }
        return null;
    }

    private static ReferenceType getCorrectReferenceType(Direction direction) {
        if (direction.equals((Object)Direction.IN)) {
            return ReferenceType.INPUT;
        }
        return ReferenceType.TYPE;
    }
}

