/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.graphql.schema;

import io.smallrye.graphql.schema.Annotations;
import io.smallrye.graphql.schema.OperationType;
import io.smallrye.graphql.schema.ScanningContext;
import io.smallrye.graphql.schema.creator.OperationCreator;
import io.smallrye.graphql.schema.creator.ReferenceCreator;
import io.smallrye.graphql.schema.creator.type.Creator;
import io.smallrye.graphql.schema.creator.type.EnumCreator;
import io.smallrye.graphql.schema.creator.type.InputTypeCreator;
import io.smallrye.graphql.schema.creator.type.InterfaceCreator;
import io.smallrye.graphql.schema.creator.type.TypeCreator;
import io.smallrye.graphql.schema.model.Operation;
import io.smallrye.graphql.schema.model.Reference;
import io.smallrye.graphql.schema.model.ReferenceType;
import io.smallrye.graphql.schema.model.Schema;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.MethodInfo;

public class SchemaBuilder {
    private final InputTypeCreator inputCreator = new InputTypeCreator();
    private final TypeCreator typeCreator = new TypeCreator();
    private final InterfaceCreator interfaceCreator = new InterfaceCreator();
    private final EnumCreator enumCreator = new EnumCreator();

    public static Schema build(IndexView index) {
        ScanningContext.register(index);
        SchemaBuilder graphQLBootstrap = new SchemaBuilder();
        return graphQLBootstrap.generateSchema();
    }

    private SchemaBuilder() {
    }

    private Schema generateSchema() {
        Collection graphQLApiAnnotations = ScanningContext.getIndex().getAnnotations(Annotations.GRAPHQL_API);
        Schema schema = new Schema();
        for (AnnotationInstance graphQLApiAnnotation : graphQLApiAnnotations) {
            ClassInfo apiClass = graphQLApiAnnotation.target().asClass();
            List methods = apiClass.methods();
            this.addOperations(schema, methods);
        }
        this.addTypesToSchema(schema);
        this.addOutstandingTypesToSchema(schema);
        ReferenceCreator.clear();
        return schema;
    }

    private void addTypesToSchema(Schema schema) {
        this.createAndAddToSchema(ReferenceType.INPUT, this.inputCreator, arg_0 -> ((Schema)schema).addInput(arg_0));
        this.createAndAddToSchema(ReferenceType.TYPE, this.typeCreator, arg_0 -> ((Schema)schema).addType(arg_0));
        this.createAndAddToSchema(ReferenceType.INTERFACE, this.interfaceCreator, arg_0 -> ((Schema)schema).addInterface(arg_0));
        this.createAndAddToSchema(ReferenceType.ENUM, this.enumCreator, arg_0 -> ((Schema)schema).addEnum(arg_0));
    }

    private void addOutstandingTypesToSchema(Schema schema) {
        boolean allDone = true;
        if (!this.findOutstandingAndAddToSchema(ReferenceType.INPUT, this.inputCreator, arg_0 -> ((Schema)schema).containsInput(arg_0), arg_0 -> ((Schema)schema).addInput(arg_0))) {
            allDone = false;
        }
        if (!this.findOutstandingAndAddToSchema(ReferenceType.TYPE, this.typeCreator, arg_0 -> ((Schema)schema).containsType(arg_0), arg_0 -> ((Schema)schema).addType(arg_0))) {
            allDone = false;
        }
        if (!this.findOutstandingAndAddToSchema(ReferenceType.INTERFACE, this.interfaceCreator, arg_0 -> ((Schema)schema).containsInterface(arg_0), arg_0 -> ((Schema)schema).addInterface(arg_0))) {
            allDone = false;
        }
        if (!this.findOutstandingAndAddToSchema(ReferenceType.ENUM, this.enumCreator, arg_0 -> ((Schema)schema).containsEnum(arg_0), arg_0 -> ((Schema)schema).addEnum(arg_0))) {
            allDone = false;
        }
        if (!allDone) {
            this.addOutstandingTypesToSchema(schema);
        }
    }

    private <T> void createAndAddToSchema(ReferenceType referenceType, Creator creator, Consumer<T> consumer) {
        while (!ReferenceCreator.values(referenceType).isEmpty()) {
            Reference reference = ReferenceCreator.values(referenceType).poll();
            ClassInfo classInfo = ScanningContext.getIndex().getClassByName(DotName.createSimple((String)reference.getClassName()));
            consumer.accept(creator.create(classInfo));
        }
    }

    private <T> boolean findOutstandingAndAddToSchema(ReferenceType referenceType, Creator creator, Predicate<String> contains, Consumer<T> consumer) {
        boolean allDone = true;
        while (!ReferenceCreator.values(referenceType).isEmpty()) {
            Reference reference = ReferenceCreator.values(referenceType).poll();
            ClassInfo classInfo = ScanningContext.getIndex().getClassByName(DotName.createSimple((String)reference.getClassName()));
            if (contains.test(reference.getName())) continue;
            consumer.accept(creator.create(classInfo));
            allDone = false;
        }
        return allDone;
    }

    private void addOperations(Schema schema, List<MethodInfo> methodInfoList) {
        for (MethodInfo methodInfo : methodInfoList) {
            Annotations annotationsForMethod = Annotations.getAnnotationsForMethod(methodInfo);
            if (annotationsForMethod.containsOneOfTheseAnnotations(Annotations.QUERY)) {
                Operation query = OperationCreator.createOperation(methodInfo, OperationType.Query);
                schema.addQuery(query);
                continue;
            }
            if (!annotationsForMethod.containsOneOfTheseAnnotations(Annotations.MUTATION)) continue;
            Operation mutation = OperationCreator.createOperation(methodInfo, OperationType.Mutation);
            schema.addMutation(mutation);
        }
    }
}

