/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.graphql.schema;

import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZonedDateTime;
import java.util.Optional;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.Type;

public class Classes {
    public static final DotName ENUM = DotName.createSimple((String)Enum.class.getName());
    public static final DotName OPTIONAL = DotName.createSimple((String)Optional.class.getName());
    public static final DotName LOCALDATE = DotName.createSimple((String)LocalDate.class.getName());
    public static final DotName LOCALDATETIME = DotName.createSimple((String)LocalDateTime.class.getName());
    public static final DotName LOCALTIME = DotName.createSimple((String)LocalTime.class.getName());
    public static final DotName ZONEDDATETIME = DotName.createSimple((String)ZonedDateTime.class.getName());
    public static final DotName OFFSETDATETIME = DotName.createSimple((String)OffsetDateTime.class.getName());
    public static final DotName OFFSETTIME = DotName.createSimple((String)OffsetTime.class.getName());
    public static final DotName UTIL_DATE = DotName.createSimple((String)java.util.Date.class.getName());
    public static final DotName SQL_DATE = DotName.createSimple((String)Date.class.getName());
    public static final DotName SQL_TIMESTAMP = DotName.createSimple((String)Timestamp.class.getName());
    public static final DotName SQL_TIME = DotName.createSimple((String)Time.class.getName());
    private static final DotName BYTE = DotName.createSimple((String)Byte.class.getName());
    private static final DotName BYTE_PRIMATIVE = DotName.createSimple((String)Byte.TYPE.getName());
    private static final DotName SHORT = DotName.createSimple((String)Short.class.getName());
    private static final DotName SHORT_PRIMATIVE = DotName.createSimple((String)Short.TYPE.getName());
    private static final DotName INTEGER = DotName.createSimple((String)Integer.class.getName());
    private static final DotName INTEGER_PRIMATIVE = DotName.createSimple((String)Integer.TYPE.getName());
    private static final DotName BIG_INTEGER = DotName.createSimple((String)BigInteger.class.getName());
    private static final DotName DOUBLE = DotName.createSimple((String)Double.class.getName());
    private static final DotName DOUBLE_PRIMATIVE = DotName.createSimple((String)Double.TYPE.getName());
    private static final DotName BIG_DECIMAL = DotName.createSimple((String)BigDecimal.class.getName());
    private static final DotName LONG = DotName.createSimple((String)Long.class.getName());
    private static final DotName LONG_PRIMATIVE = DotName.createSimple((String)Long.TYPE.getName());
    private static final DotName FLOAT = DotName.createSimple((String)Float.class.getName());
    private static final DotName FLOAT_PRIMATIVE = DotName.createSimple((String)Float.TYPE.getName());

    private Classes() {
    }

    public static boolean isOptional(Type type) {
        Type.Kind kind = type.kind();
        return kind.equals((Object)Type.Kind.PARAMETERIZED_TYPE) && type.name().equals((Object)OPTIONAL);
    }

    public static boolean isInterface(ClassInfo classInfo) {
        if (classInfo == null) {
            return false;
        }
        return Modifier.isInterface(classInfo.flags());
    }

    public static boolean isEnum(ClassInfo classInfo) {
        if (classInfo == null) {
            return false;
        }
        return classInfo.superName().equals((Object)ENUM);
    }

    public static boolean isNumberLikeTypeOrCollectionThereOf(Type type) {
        return Classes.isTypeOrCollectionThereOf(type, BYTE, BYTE_PRIMATIVE, SHORT, SHORT_PRIMATIVE, INTEGER, INTEGER_PRIMATIVE, BIG_INTEGER, DOUBLE, DOUBLE_PRIMATIVE, BIG_DECIMAL, LONG, LONG_PRIMATIVE, FLOAT, FLOAT_PRIMATIVE);
    }

    public static boolean isDateLikeTypeOrCollectionThereOf(Type type) {
        return Classes.isTypeOrCollectionThereOf(type, LOCALDATE, LOCALTIME, LOCALDATETIME, ZONEDDATETIME, OFFSETDATETIME, OFFSETTIME, UTIL_DATE, SQL_DATE, SQL_TIMESTAMP, SQL_TIME);
    }

    private static boolean isTypeOrCollectionThereOf(Type type, DotName ... valid) {
        switch (type.kind()) {
            case PARAMETERIZED_TYPE: {
                Type typeInCollection = (Type)type.asParameterizedType().arguments().get(0);
                return Classes.isTypeOrCollectionThereOf(typeInCollection, valid);
            }
            case ARRAY: {
                Type typeInArray = type.asArrayType().component();
                return Classes.isTypeOrCollectionThereOf(typeInArray, valid);
            }
        }
        for (DotName dotName : valid) {
            if (!type.name().toString().equals(dotName.toString())) continue;
            return true;
        }
        return false;
    }
}

