/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.graphql.mavenplugin;

import graphql.schema.GraphQLSchema;
import io.smallrye.graphql.bootstrap.Bootstrap;
import io.smallrye.graphql.execution.SchemaPrinter;
import io.smallrye.graphql.schema.SchemaBuilder;
import io.smallrye.graphql.schema.helper.TypeAutoNameStrategy;
import io.smallrye.graphql.schema.model.Schema;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.jboss.jandex.CompositeIndex;
import org.jboss.jandex.Index;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.Indexer;
import org.jboss.jandex.JarIndexer;
import org.jboss.jandex.Result;

@Mojo(name="generate-schema", defaultPhase=LifecyclePhase.PROCESS_CLASSES, requiresDependencyCollection=ResolutionScope.COMPILE_PLUS_RUNTIME, requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME)
public class GenerateSchemaMojo
extends AbstractMojo {
    private static MavenConfig mavenConfig;
    @Parameter(defaultValue="${project.build.directory}/generated/schema.graphql", property="destination")
    private String destination;
    @Parameter(defaultValue="false", property="includeDependencies")
    private boolean includeDependencies;
    @Parameter(defaultValue="compile,system", property="includeDependenciesScopes")
    private List<String> includeDependenciesScopes;
    @Parameter(defaultValue="jar", property="includeDependenciesTypes")
    private List<String> includeDependenciesTypes;
    @Parameter(defaultValue="false", property="includeScalars")
    private boolean includeScalars;
    @Parameter(defaultValue="false", property="includeDirectives")
    private boolean includeDirectives;
    @Parameter(defaultValue="false", property="includeSchemaDefinition")
    private boolean includeSchemaDefinition;
    @Parameter(defaultValue="false", property="includeIntrospectionTypes")
    private boolean includeIntrospectionTypes;
    @Parameter(defaultValue="Default", property="typeAutoNameStrategy")
    private String typeAutoNameStrategy;
    @Parameter(defaultValue="${project}", required=true)
    private MavenProject mavenProject;
    @Parameter(property="project.compileClasspathElements", required=true, readonly=true)
    private List<String> classpath;
    @Parameter(defaultValue="false", property="skip")
    private boolean skip;
    @Parameter(defaultValue="${project.build.outputDirectory}", property="classesDir")
    private File classesDir;

    public static MavenConfig getMavenConfig() {
        return mavenConfig;
    }

    public void execute() throws MojoExecutionException {
        mavenConfig = new MavenConfig(this.includeScalars, this.includeDirectives, this.includeSchemaDefinition, this.includeIntrospectionTypes, TypeAutoNameStrategy.valueOf((String)this.typeAutoNameStrategy));
        if (!this.skip) {
            ClassLoader classLoader = this.getClassLoader();
            Thread.currentThread().setContextClassLoader(classLoader);
            IndexView index = this.createIndex();
            String schema = this.generateSchema(index);
            if (schema != null) {
                this.write(schema);
            } else {
                this.getLog().warn((CharSequence)"No Schema generated. Check that your code contains the MicroProfile GraphQL Annotations");
            }
        }
    }

    private IndexView createIndex() throws MojoExecutionException {
        ArrayList<Index> indexes = new ArrayList<Index>();
        try {
            Index moduleIndex = this.indexModuleClasses();
            indexes.add(moduleIndex);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Can't compute index", (Exception)e);
        }
        Predicate<Artifact> isMutiny = a -> a.getGroupId().equals("io.smallrye.reactive") && a.getArtifactId().equals("mutiny");
        this.mavenProject.getArtifacts().stream().filter(isMutiny).findAny().ifPresent(a -> {
            Result r = this.indexJar(((Artifact)a).getFile());
            if (r != null) {
                indexes.add(r.getIndex());
            }
        });
        if (this.includeDependencies) {
            for (Object a2 : this.mavenProject.getArtifacts()) {
                Result result;
                Artifact artifact = (Artifact)a2;
                if (!this.includeDependenciesScopes.contains(artifact.getScope()) || !this.includeDependenciesTypes.contains(artifact.getType()) || isMutiny.test(artifact) || (result = this.indexJar(artifact.getFile())) == null) continue;
                indexes.add(result.getIndex());
            }
        }
        return CompositeIndex.create(indexes);
    }

    private Result indexJar(File file) {
        try {
            this.getLog().debug((CharSequence)("Indexing file " + file));
            return JarIndexer.createJarIndex((File)file, (Indexer)new Indexer(), (boolean)false, (boolean)false, (boolean)false);
        }
        catch (IOException e) {
            this.getLog().error((CharSequence)("Can't compute index of " + file.getAbsolutePath() + ", skipping"), (Throwable)e);
            return null;
        }
    }

    private Index indexModuleClasses() throws IOException {
        Indexer indexer = new Indexer();
        try (Stream<Path> classesDirStream = Files.walk(this.classesDir.toPath(), new FileVisitOption[0]);){
            List classFiles = classesDirStream.filter(path -> path.toString().endsWith(".class")).collect(Collectors.toList());
            for (Path path2 : classFiles) {
                indexer.index(Files.newInputStream(path2, new OpenOption[0]));
            }
        }
        return indexer.complete();
    }

    private String generateSchema(IndexView index) {
        Schema internalSchema = SchemaBuilder.build((IndexView)index, (TypeAutoNameStrategy)GenerateSchemaMojo.mavenConfig.typeAutoNameStrategy);
        GraphQLSchema graphQLSchema = Bootstrap.bootstrap((Schema)internalSchema, (boolean)true);
        if (graphQLSchema != null) {
            return new SchemaPrinter().print(graphQLSchema);
        }
        return null;
    }

    private void write(String schema) throws MojoExecutionException {
        try {
            if (this.destination == null || this.destination.isEmpty()) {
                this.getLog().info((CharSequence)schema);
            } else {
                Path path = new File(this.destination).toPath();
                path.toFile().getParentFile().mkdirs();
                Files.write(path, schema.getBytes(), StandardOpenOption.WRITE, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
                this.getLog().info((CharSequence)("Wrote the schema to " + path.toAbsolutePath().toString()));
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("Can't write the result", (Exception)e);
        }
    }

    private ClassLoader getClassLoader() {
        HashSet<URL> urls = new HashSet<URL>();
        for (String element : this.classpath) {
            try {
                urls.add(new File(element).toURI().toURL());
            }
            catch (MalformedURLException ex) {
                throw new RuntimeException(ex);
            }
        }
        return URLClassLoader.newInstance(urls.toArray(new URL[0]), Thread.currentThread().getContextClassLoader());
    }

    public static class MavenConfig {
        private final boolean includeScalars;
        private final boolean includeDirectives;
        private final boolean includeSchemaDefinition;
        private final boolean includeIntrospectionTypes;
        private final TypeAutoNameStrategy typeAutoNameStrategy;

        public MavenConfig(boolean includeScalars, boolean includeDirectives, boolean includeSchemaDefinition, boolean includeIntrospectionTypes, TypeAutoNameStrategy typeAutoNameStrategy) {
            this.includeScalars = includeScalars;
            this.includeDirectives = includeDirectives;
            this.includeSchemaDefinition = includeSchemaDefinition;
            this.includeIntrospectionTypes = includeIntrospectionTypes;
            this.typeAutoNameStrategy = typeAutoNameStrategy;
        }

        public boolean isIncludeScalars() {
            return this.includeScalars;
        }

        public boolean isIncludeDirectives() {
            return this.includeDirectives;
        }

        public boolean isIncludeSchemaDefinition() {
            return this.includeSchemaDefinition;
        }

        public boolean isIncludeIntrospectionTypes() {
            return this.includeIntrospectionTypes;
        }

        public TypeAutoNameStrategy getTypeAutoNameStrategy() {
            return this.typeAutoNameStrategy;
        }
    }
}

