/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.graphql.client.model;

import io.smallrye.graphql.client.model.Annotations;
import io.smallrye.graphql.client.model.ClientModel;
import io.smallrye.graphql.client.model.ClientModels;
import io.smallrye.graphql.client.model.QueryBuilder;
import io.smallrye.graphql.client.model.ScanningContext;
import io.smallrye.graphql.client.model.helper.OperationModel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.MethodInfo;
import org.jboss.logging.Logger;

public class ClientModelBuilder {
    private static final Logger LOG = Logger.getLogger((String)ClientModelBuilder.class.getName());

    public static ClientModels build(IndexView index) {
        ScanningContext.register(index);
        return new ClientModelBuilder().generateClientModels();
    }

    private ClientModelBuilder() {
    }

    private ClientModels generateClientModels() {
        ClientModels clientModels = new ClientModels();
        HashMap clientModelMap = new HashMap();
        Collection graphQLApiAnnotations = ScanningContext.getIndex().getAnnotations(Annotations.GRAPHQL_CLIENT_API);
        graphQLApiAnnotations.forEach(graphQLApiAnnotation -> {
            ClientModel operationMap = new ClientModel();
            ClassInfo apiClass = graphQLApiAnnotation.target().asClass();
            List<MethodInfo> methods = this.getAllMethodsIncludingFromSuperClasses(apiClass);
            methods.stream().forEach(method -> {
                String query = new QueryBuilder((MethodInfo)method).build();
                LOG.debugf("[%s] \u2013 Query created: %s", (Object)apiClass.name().toString(), (Object)query);
                operationMap.getOperationMap().putIfAbsent(OperationModel.of(method).getMethodKey(), query);
            });
            clientModelMap.put(graphQLApiAnnotation.value("configKey") == null ? apiClass.name().toString() : graphQLApiAnnotation.value("configKey").asString(), operationMap);
        });
        clientModels.setClientModelMap(clientModelMap);
        return clientModels;
    }

    private List<MethodInfo> getAllMethodsIncludingFromSuperClasses(ClassInfo classInfo) {
        ArrayList<MethodInfo> methods = new ArrayList<MethodInfo>();
        classInfo.methods().stream().filter(methodInfo -> !methodInfo.isSynthetic()).forEach(methods::add);
        List interfaceNames = classInfo.interfaceNames();
        interfaceNames.forEach(interfaceName -> {
            List<MethodInfo> parentMethods = this.getAllMethodsIncludingFromSuperClasses(ScanningContext.getIndex().getClassByName(interfaceName));
            methods.addAll(parentMethods);
        });
        return methods;
    }
}

