/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.graphql.client.model.helper;

import io.smallrye.graphql.client.model.Annotations;
import io.smallrye.graphql.client.model.Classes;
import io.smallrye.graphql.client.model.Scalars;
import io.smallrye.graphql.client.model.ScanningContext;
import io.smallrye.graphql.client.model.helper.FieldModel;
import java.lang.reflect.Modifier;
import java.security.AccessController;
import java.util.Arrays;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.FieldInfo;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.Type;

public class TypeModel {
    private Type type;

    public static TypeModel of(Type type) {
        return new TypeModel(type);
    }

    TypeModel(Type type) {
        this.type = type;
    }

    public boolean isPrimitive() {
        return Classes.isPrimitive(this.type);
    }

    public boolean isMap() {
        return Classes.isMap(this.type);
    }

    public boolean isCollectionOrArray() {
        return this.isArray() || this.isCollection();
    }

    public boolean isClassType() {
        return this.isSimpleClassType() || this.isParametrized() || this.type.name().equals((Object)Classes.OBJECT);
    }

    public boolean isSimpleClassType() {
        return Classes.isClass(this.type) && !this.isPrimitive();
    }

    public TypeModel getMapKeyType() {
        if (!this.isMap()) {
            throw new IllegalArgumentException("Expected type to be a Map");
        }
        return TypeModel.of((Type)this.type.asParameterizedType().arguments().get(0));
    }

    public TypeModel getMapValueType() {
        if (!this.isMap()) {
            throw new IllegalArgumentException("Expected type to be a Map");
        }
        return TypeModel.of((Type)this.type.asParameterizedType().arguments().get(1));
    }

    public boolean isNonNull() {
        return this.isPrimitive() || this.type.hasAnnotation(Annotations.NON_NULL) || this.type.hasAnnotation(Annotations.JAKARTA_NON_NULL);
    }

    public boolean isArray() {
        return Classes.isArray(this.type);
    }

    public boolean isCollection() {
        return Classes.isCollection(this.type);
    }

    public String getSimpleName() {
        return this.type.name().local();
    }

    public String getName() {
        StringBuilder name = new StringBuilder(this.isArray() ? this.getArrayElementType().getName() : this.type.name().toString());
        if (this.isParametrized()) {
            name.append(this.getItemTypes().map(TypeModel::getName).collect(Collectors.joining(", ", "<", ">")));
        }
        if (this.isArray()) {
            name.append("[]");
        }
        return name.toString();
    }

    public Stream<TypeModel> getItemTypes() {
        if (!Classes.isParameterized(this.type)) {
            throw new IllegalArgumentException("Type " + this.getName() + " is not parametrized, cannot get its Item Types");
        }
        return this.type.asParameterizedType().arguments().stream().map(TypeModel::of);
    }

    public TypeModel getArrayElementType() {
        if (!this.isArray()) {
            throw new IllegalArgumentException("Type " + this.getName() + " is not an array type, cannot get its Element Type");
        }
        return TypeModel.of(this.type.asArrayType().elementType());
    }

    public TypeModel getItemTypeOrElementType() {
        if (this.isArray()) {
            return this.getArrayElementType();
        }
        return this.getFirstRawType();
    }

    public TypeModel getCollectionElementType() {
        return this.getFirstRawType();
    }

    public TypeModel getFirstRawType() {
        return (TypeModel)this.getItemTypes().collect(Collectors.toList()).get(0);
    }

    public boolean isEnum() {
        return Classes.isEnum(this.type);
    }

    public boolean isScalar() {
        return Scalars.isScalar(this.getName()) || this.hasScalarConstructor() || this.isEnum();
    }

    private boolean hasScalarConstructor() {
        return this.isSimpleClassType() && ScanningContext.getIndex().getClassByName(this.type.name()).methods().stream().anyMatch(this::isStaticStringConstructor);
    }

    private boolean isStaticStringConstructor(MethodInfo method) {
        return this.isStaticConstructorMethodNamed(method, "of") || this.isStaticConstructorMethodNamed(method, "valueOf") || this.isStaticConstructorMethodNamed(method, "parse");
    }

    private boolean isStaticConstructorMethodNamed(MethodInfo method, String name) {
        return method.name().equals(name) && Modifier.isStatic(method.flags()) && method.returnType().equals((Object)this.type) && this.hasOneStringParameter(method);
    }

    private boolean hasOneStringParameter(MethodInfo methodInfo) {
        return methodInfo.parametersCount() == 1 && Scalars.isStringScalar(TypeModel.of(methodInfo.parameterType(0)).getName());
    }

    public boolean isTypesafeResponse() {
        return this.isParametrized() && this.type.name().equals((Object)Classes.TYPESAFE_RESPONSE);
    }

    public boolean isErrorOr() {
        return this.isParametrized() && this.type.name().equals((Object)Classes.ERROR_OR);
    }

    public boolean isOptional() {
        return this.isParametrized() && this.type.name().equals((Object)Classes.OPTIONAL);
    }

    public boolean isAsync() {
        return Classes.isAsync(this.type);
    }

    public boolean isParametrized() {
        return Classes.isParameterized(this.type);
    }

    public boolean isTypeVariable() {
        return Classes.isTypeVariable(this.type);
    }

    public Stream<FieldModel> fields() {
        if (!this.isClassType()) {
            throw new IllegalArgumentException("Expected type " + this.type.name().toString() + " to be Class type, cannot get fields from non-class type");
        }
        return this.fields(ScanningContext.getIndex().getClassByName(this.type.name()));
    }

    private Stream<FieldModel> fields(ClassInfo clazz) {
        return clazz == null ? Stream.of(new FieldModel[0]) : Stream.concat(this.fields(ScanningContext.getIndex().getClassByName(clazz.superClassType().name())), this.fieldsHelper(clazz).map(FieldModel::of).filter(this::isGraphQlField));
    }

    private Stream<FieldInfo> fieldsHelper(ClassInfo clazz) {
        if (System.getSecurityManager() == null) {
            return clazz.unsortedFields().stream();
        }
        return AccessController.doPrivileged(() -> clazz.unsortedFields().stream());
    }

    private boolean isGraphQlField(FieldModel field) {
        return !field.isStatic() && !field.isSynthetic() && !field.isTransient() && !this.isAnnotatedBy(field, Annotations.IGNORE, Annotations.JAKARTA_JSONB_TRANSIENT, Annotations.JACKSON_IGNORE);
    }

    private boolean isAnnotatedBy(FieldModel field, DotName ... annotationClasses) {
        return Arrays.stream(annotationClasses).anyMatch(field::hasAnnotation);
    }

    public boolean hasClassAnnotation(DotName annotationName) {
        ClassInfo clazz = ScanningContext.getIndex().getClassByName(this.type.name());
        return clazz.annotations().stream().anyMatch(annotation -> this.isClassAnnotation((AnnotationInstance)annotation) && annotation.name().equals((Object)annotationName));
    }

    public Optional<AnnotationInstance> getClassAnnotation(DotName annotationName) {
        ClassInfo clazz = ScanningContext.getIndex().getClassByName(this.type.name());
        return clazz.annotations().stream().filter(annotation -> this.isClassAnnotation((AnnotationInstance)annotation) && annotation.name().equals((Object)annotationName)).findFirst();
    }

    private boolean isClassAnnotation(AnnotationInstance annotationInstance) {
        return annotationInstance.target().kind().equals((Object)AnnotationTarget.Kind.CLASS);
    }

    public boolean isCustomParametrizedType() {
        return this.isParametrized() && !this.isAsync() && !this.isOptional() && !this.isTypesafeResponse() && !this.isErrorOr() && !this.isMap() && !this.isCollection();
    }
}

