/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.graphql.client.model.helper;

import io.smallrye.graphql.client.core.OperationType;
import io.smallrye.graphql.client.impl.SmallRyeGraphQLClientMessages;
import io.smallrye.graphql.client.model.Annotations;
import io.smallrye.graphql.client.model.MethodKey;
import io.smallrye.graphql.client.model.ScanningContext;
import io.smallrye.graphql.client.model.helper.DirectiveHelper;
import io.smallrye.graphql.client.model.helper.DirectiveInstance;
import io.smallrye.graphql.client.model.helper.FieldModel;
import io.smallrye.graphql.client.model.helper.NamedElement;
import io.smallrye.graphql.client.model.helper.ParameterModel;
import io.smallrye.graphql.client.model.helper.TypeModel;
import java.util.List;
import java.util.Optional;
import java.util.Stack;
import java.util.stream.Collectors;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.DotName;
import org.jboss.jandex.JandexReflection;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.Type;

public class OperationModel
implements NamedElement {
    private final MethodInfo method;
    private final List<ParameterModel> parameters;
    private final Stack<String> typeStack = new Stack();
    private final Stack<String> expressionStack = new Stack();
    private Stack<TypeModel> rawParametrizedTypes = new Stack();
    private final List<DirectiveInstance> directives;

    OperationModel(MethodInfo method) {
        this.method = method;
        this.parameters = method.parameters().stream().map(ParameterModel::of).collect(Collectors.toList());
        this.directives = DirectiveHelper.resolveDirectives(method.annotations().stream(), this.getDirectiveLocation(), AnnotationTarget.Kind.METHOD).map(DirectiveInstance::of).collect(Collectors.toList());
    }

    public static OperationModel of(MethodInfo method) {
        return new OperationModel(method);
    }

    public String fields(TypeModel type) {
        if (this.typeStack.contains(type.getName())) {
            throw SmallRyeGraphQLClientMessages.msg.fieldRecursionFound();
        }
        try {
            this.typeStack.push(type.getName());
            String string = this.recursionCheckedFields(type);
            return string;
        }
        finally {
            this.typeStack.pop();
        }
    }

    public String recursionCheckedFields(TypeModel type) {
        while (type.isOptional() || type.isErrorOr() || type.isTypesafeResponse()) {
            type = type.getFirstRawType();
        }
        if (type.isScalar()) {
            return "";
        }
        if (type.isCollectionOrArray() || type.isAsync()) {
            return this.fields(type.getItemTypeOrElementType());
        }
        if (type.isMap()) {
            String keyFields = this.fields(type.getMapKeyType());
            String valueFields = this.fields(type.getMapValueType());
            return " {key" + keyFields + " value" + valueFields + "}";
        }
        if (this.isRawParametrizedType(type)) {
            this.rawParametrizedTypes.push(type.getFirstRawType());
        }
        String fieldsResult = type.fields().map(this::field).collect(Collectors.joining(" ", " {", "}"));
        if (this.isRawParametrizedType(type)) {
            this.rawParametrizedTypes.pop();
        }
        return fieldsResult;
    }

    public String field(FieldModel field) {
        String path;
        List<ParameterModel> nestedParameters;
        TypeModel type = field.getType();
        if (type.isTypeVariable()) {
            type = this.rawParametrizedTypes.peek();
        }
        StringBuilder expression = new StringBuilder();
        field.getAlias().ifPresent(alias -> expression.append((String)alias).append(":"));
        expression.append(field.getName());
        if (field.hasDirectives()) {
            expression.append(field.getDirectives().stream().map(DirectiveInstance::buildDirective).collect(Collectors.joining()));
        }
        if (!(nestedParameters = this.nestedParameters(path = this.nestedExpressionPrefix() + field.getRawName())).isEmpty()) {
            expression.append(nestedParameters.stream().map(this::bind).collect(Collectors.joining(", ", "(", ")")));
        }
        this.expressionStack.push(path);
        expression.append(this.fields(type));
        this.expressionStack.pop();
        return expression.toString();
    }

    public String declare(ParameterModel parameter) {
        return "$" + parameter.getRawName() + ": " + parameter.graphQlInputTypeName() + (parameter.hasDirectives() ? parameter.getDirectives().stream().map(DirectiveInstance::buildDirective).collect(Collectors.joining()) : "");
    }

    public String bind(ParameterModel parameter) {
        return parameter.getName() + ": $" + parameter.getRawName();
    }

    public String nestedExpressionPrefix() {
        return this.expressionStack.isEmpty() ? "" : this.expressionStack.peek() + ".";
    }

    public OperationType getOperationType() {
        if (this.method.hasAnnotation(Annotations.MUTATION)) {
            return OperationType.MUTATION;
        }
        if (this.method.hasAnnotation(Annotations.SUBCRIPTION)) {
            return OperationType.SUBSCRIPTION;
        }
        return OperationType.QUERY;
    }

    public Optional<String> queryName() {
        Optional<AnnotationInstance> queryAnnotation = this.getMethodAnnotation(Annotations.QUERY);
        if (queryAnnotation.isPresent() && queryAnnotation.orElseThrow().value() != null) {
            return Optional.of(queryAnnotation.orElseThrow().value().asString());
        }
        Optional<AnnotationInstance> nameAnnotation = this.getMethodAnnotation(Annotations.NAME);
        if (nameAnnotation.isPresent()) {
            return Optional.of(nameAnnotation.orElseThrow().value().asString());
        }
        return Optional.empty();
    }

    public Optional<String> mutationName() {
        Optional<AnnotationInstance> mutationAnnotation = this.getMethodAnnotation(Annotations.MUTATION);
        if (mutationAnnotation.isPresent() && mutationAnnotation.orElseThrow().value() != null) {
            return Optional.of(mutationAnnotation.orElseThrow().value().asString());
        }
        return Optional.empty();
    }

    public Optional<String> subscriptionName() {
        Optional<AnnotationInstance> subscriptionAnnotation = this.getMethodAnnotation(Annotations.SUBCRIPTION);
        if (subscriptionAnnotation.isPresent() && subscriptionAnnotation.orElseThrow().value() != null) {
            return Optional.of(subscriptionAnnotation.orElseThrow().value().asString());
        }
        return Optional.empty();
    }

    @Override
    public String getName() {
        return this.queryName().orElseGet(() -> this.mutationName().orElseGet(() -> this.subscriptionName().orElseGet(this::getRawName)));
    }

    @Override
    public String getRawName() {
        String name = this.method.name();
        if (name.startsWith("get") && name.length() > 3 && Character.isUpperCase(name.charAt(3))) {
            return Character.toLowerCase(name.charAt(3)) + name.substring(4);
        }
        return name;
    }

    @Override
    public String getDirectiveLocation() {
        return "FIELD";
    }

    @Override
    public boolean hasDirectives() {
        return !this.directives.isEmpty();
    }

    @Override
    public List<DirectiveInstance> getDirectives() {
        return this.directives;
    }

    public List<ParameterModel> valueParameters() {
        return this.parameters.stream().filter(ParameterModel::isValueParameter).collect(Collectors.toList());
    }

    public List<ParameterModel> rootParameters() {
        return this.parameters.stream().filter(ParameterModel::isRootParameter).collect(Collectors.toList());
    }

    public List<ParameterModel> nestedParameters(String path) {
        return this.parameters.stream().filter(ParameterModel::isNestedParameter).filter(parameter -> parameter.getNestedParameterNames().anyMatch(path::equals)).collect(Collectors.toList());
    }

    public TypeModel getReturnType() {
        return TypeModel.of(this.method.returnType());
    }

    public boolean hasValueParameters() {
        return !this.valueParameters().isEmpty();
    }

    public boolean hasRootParameters() {
        return !this.rootParameters().isEmpty();
    }

    public boolean isSingle() {
        return this.getReturnType().isScalar() || this.getReturnType().isParametrized() || this.getReturnType().isArray() || !ScanningContext.getIndex().getClassByName(this.method.returnType().name()).hasAnnotation(Annotations.MULTIPLE);
    }

    public MethodKey getMethodKey() {
        return new MethodKey(JandexReflection.loadRawType((Type)this.method.returnType()), this.method.name(), (Class[])this.method.parameters().stream().map(methodParameterInfo -> JandexReflection.loadRawType((Type)methodParameterInfo.type())).toArray(Class[]::new));
    }

    public String getOperationTypeAsString() {
        switch (this.getOperationType()) {
            case MUTATION: {
                return "mutation";
            }
            case SUBSCRIPTION: {
                return "subscription";
            }
        }
        return "query";
    }

    private Optional<AnnotationInstance> getMethodAnnotation(DotName annotation) {
        return this.method.annotations().stream().filter(annotationInstance -> annotationInstance.target().kind() == AnnotationTarget.Kind.METHOD).filter(annotationInstance -> annotationInstance.name().equals((Object)annotation)).findFirst();
    }

    private boolean isRawParametrizedType(TypeModel type) {
        return type.isCustomParametrizedType() && !type.getFirstRawType().isTypeVariable();
    }
}

