/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.graphql.client.model.helper;

import io.smallrye.graphql.client.model.Annotations;
import io.smallrye.graphql.client.model.helper.DirectiveHelper;
import io.smallrye.graphql.client.model.helper.DirectiveInstance;
import io.smallrye.graphql.client.model.helper.NamedElement;
import io.smallrye.graphql.client.model.helper.TypeModel;
import java.lang.reflect.Modifier;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.jboss.jandex.DotName;
import org.jboss.jandex.FieldInfo;

public class FieldModel
implements NamedElement {
    private FieldInfo field;
    private List<DirectiveInstance> directives;

    FieldModel(FieldInfo field) {
        this.field = field;
        this.directives = DirectiveHelper.resolveDirectives(field.annotations().stream(), this.getDirectiveLocation()).map(DirectiveInstance::of).collect(Collectors.toList());
    }

    public static FieldModel of(FieldInfo field) {
        return new FieldModel(field);
    }

    public Optional<String> getAlias() {
        if (this.field.hasAnnotation(Annotations.NAME)) {
            return Optional.of(this.getRawName());
        }
        return Optional.empty();
    }

    @Override
    public String getName() {
        if (this.field.hasAnnotation(Annotations.NAME)) {
            return this.field.annotation(Annotations.NAME).value().asString();
        }
        return this.getRawName();
    }

    @Override
    public String getRawName() {
        return this.field.name();
    }

    @Override
    public String getDirectiveLocation() {
        return "FIELD";
    }

    public boolean hasAnnotation(DotName annotation) {
        return this.field.hasAnnotation(annotation);
    }

    public boolean isStatic() {
        return Modifier.isStatic(this.field.flags());
    }

    public boolean isTransient() {
        return Modifier.isTransient(this.field.flags());
    }

    public boolean isSynthetic() {
        return this.field.asField().isSynthetic();
    }

    public TypeModel getType() {
        return TypeModel.of(this.field.type());
    }

    @Override
    public boolean hasDirectives() {
        return !this.directives.isEmpty();
    }

    @Override
    public List<DirectiveInstance> getDirectives() {
        return this.directives;
    }
}

