/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.graphql.client.model;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.net.URL;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.Period;
import java.time.ZonedDateTime;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Map;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

public class Scalars {
    private static final Map<String, String> scalarMap = new HashMap<String, String>();
    private static final String STRING = "String";
    private static final String BOOLEAN = "Boolean";
    private static final String INTEGER = "Int";
    private static final String FLOAT = "Float";
    private static final String BIGINTEGER = "BigInteger";
    private static final String BIGDECIMAL = "BigDecimal";
    private static final String DATE = "Date";
    private static final String TIME = "Time";
    private static final String DATETIME = "DateTime";
    private static final String ID = "ID";
    private static final String PERIOD = "Period";
    private static final String DURATION = "Duration";
    private static final String VOID = "Void";

    private Scalars() {
    }

    public static boolean isScalar(String className) {
        return scalarMap.containsKey(className);
    }

    public static String getScalar(String identifier) {
        return scalarMap.get(identifier);
    }

    public static boolean isStringScalar(String className) {
        String potentionalString = scalarMap.get(className);
        return potentionalString != null && scalarMap.get(className).equals(STRING);
    }

    private static void populateScalar(String className, String scalarName) {
        scalarMap.put(className, scalarName);
    }

    static {
        Scalars.populateScalar(String.class.getName(), STRING);
        Scalars.populateScalar(Character.TYPE.getName(), STRING);
        Scalars.populateScalar(Character.class.getName(), STRING);
        Scalars.populateScalar(UUID.class.getName(), STRING);
        Scalars.populateScalar(URL.class.getName(), STRING);
        Scalars.populateScalar(URI.class.getName(), STRING);
        Scalars.populateScalar("org.bson.types.ObjectId", STRING);
        Scalars.populateScalar("javax.json.JsonObject", STRING);
        Scalars.populateScalar("javax.json.JsonArray", STRING);
        Scalars.populateScalar("jakarta.json.JsonObject", STRING);
        Scalars.populateScalar("jakarta.json.JsonArray", STRING);
        Scalars.populateScalar(Boolean.class.getName(), BOOLEAN);
        Scalars.populateScalar(Boolean.TYPE.getName(), BOOLEAN);
        Scalars.populateScalar(AtomicBoolean.class.getName(), BOOLEAN);
        Scalars.populateScalar(Integer.class.getName(), INTEGER);
        Scalars.populateScalar(Integer.TYPE.getName(), INTEGER);
        Scalars.populateScalar(Short.class.getName(), INTEGER);
        Scalars.populateScalar(Short.TYPE.getName(), INTEGER);
        Scalars.populateScalar(Byte.class.getName(), INTEGER);
        Scalars.populateScalar(Byte.TYPE.getName(), INTEGER);
        Scalars.populateScalar(OptionalInt.class.getName(), INTEGER);
        Scalars.populateScalar(AtomicInteger.class.getName(), INTEGER);
        Scalars.populateScalar(Float.class.getName(), FLOAT);
        Scalars.populateScalar(Float.TYPE.getName(), FLOAT);
        Scalars.populateScalar(Double.class.getName(), FLOAT);
        Scalars.populateScalar(Double.TYPE.getName(), FLOAT);
        Scalars.populateScalar(OptionalDouble.class.getName(), FLOAT);
        Scalars.populateScalar(BigInteger.class.getName(), BIGINTEGER);
        Scalars.populateScalar(Long.class.getName(), BIGINTEGER);
        Scalars.populateScalar(Long.TYPE.getName(), BIGINTEGER);
        Scalars.populateScalar(OptionalLong.class.getName(), BIGINTEGER);
        Scalars.populateScalar(AtomicLong.class.getName(), BIGINTEGER);
        Scalars.populateScalar(BigDecimal.class.getName(), BIGDECIMAL);
        Scalars.populateScalar(LocalDate.class.getName(), DATE);
        Scalars.populateScalar(Date.class.getName(), DATE);
        Scalars.populateScalar(LocalTime.class.getName(), TIME);
        Scalars.populateScalar(Time.class.getName(), TIME);
        Scalars.populateScalar(OffsetTime.class.getName(), TIME);
        Scalars.populateScalar(LocalDateTime.class.getName(), DATETIME);
        Scalars.populateScalar(java.util.Date.class.getName(), DATETIME);
        Scalars.populateScalar(Timestamp.class.getName(), DATETIME);
        Scalars.populateScalar(ZonedDateTime.class.getName(), DATETIME);
        Scalars.populateScalar(OffsetDateTime.class.getName(), DATETIME);
        Scalars.populateScalar(Instant.class.getName(), DATETIME);
        Scalars.populateScalar(Calendar.class.getName(), DATETIME);
        Scalars.populateScalar(GregorianCalendar.class.getName(), DATETIME);
        Scalars.populateScalar(Duration.class.getName(), DURATION);
        Scalars.populateScalar(Period.class.getName(), PERIOD);
        Scalars.populateScalar(Void.class.getName(), VOID);
        Scalars.populateScalar(Void.TYPE.getName(), VOID);
    }
}

